/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.utils.EnsurePath;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOStateManager;
import org.apache.phoenix.thirdparty.com.google.common.base.Charsets;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.AbstractScheduledService;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LeaseManager
extends AbstractScheduledService
implements LeaseManagement {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseManager.class);
    private final CuratorFramework zkClient;
    private final Panicker panicker;
    private final String tsoHostAndPort;
    private final TSOStateManager stateManager;
    private final ExecutorService tsoStateInitializer = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("tso-state-initializer").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LeaseManager.this.panicker.panic(t + " threw exception", e);
        }
    }).build());
    private final long leasePeriodInMs;
    private final TSOChannelHandler tsoChannelHandler;
    private int leaseNodeVersion;
    private final AtomicLong endLeaseInMs = new AtomicLong(0L);
    private final AtomicLong baseTimeInMs = new AtomicLong(0L);
    private final String leasePath;
    private final String currentTSOPath;

    LeaseManager(String tsoHostAndPort, TSOChannelHandler tsoChannelHandler, TSOStateManager stateManager, long leasePeriodInMs, String leasePath, String currentTSOPath, CuratorFramework zkClient, Panicker panicker) {
        this.tsoHostAndPort = tsoHostAndPort;
        this.tsoChannelHandler = tsoChannelHandler;
        this.stateManager = stateManager;
        this.leasePeriodInMs = leasePeriodInMs;
        this.leasePath = leasePath;
        this.currentTSOPath = currentTSOPath;
        this.zkClient = zkClient;
        this.panicker = panicker;
        LOG.info("LeaseManager {} initialized. Lease period {}ms", (Object)this.toString(), (Object)leasePeriodInMs);
    }

    @Override
    public void startService() throws LeaseManagement.LeaseManagementException {
        this.createLeaseManagementZNode();
        this.createCurrentTSOZNode();
        this.startAsync();
        this.awaitRunning();
    }

    @Override
    public void stopService() throws LeaseManagement.LeaseManagementException {
        this.stopAsync();
        this.awaitTerminated();
    }

    @Override
    public boolean stillInLeasePeriod() {
        return System.currentTimeMillis() <= this.getEndLeaseInMs();
    }

    void tryToGetInitialLeasePeriod() throws Exception {
        this.baseTimeInMs.set(System.currentTimeMillis());
        if (this.canAcquireLease()) {
            this.endLeaseInMs.set(this.baseTimeInMs.get() + this.leasePeriodInMs);
            LOG.info("{} got the lease (Master) Ver. {}/End of lease: {}ms", new Object[]{this.tsoHostAndPort, this.leaseNodeVersion, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.endLeaseInMs)});
            this.tsoStateInitializer.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TSOStateManager.TSOState newTSOState = LeaseManager.this.stateManager.initialize();
                        LeaseManager.this.advertiseTSOServerInfoThroughZK(newTSOState.getEpoch());
                        LeaseManager.this.tsoChannelHandler.reconnect();
                    }
                    catch (Exception e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            });
        } else {
            this.tsoStateInitializer.submit(new Runnable(){

                @Override
                public void run() {
                    LeaseManager.this.tsoChannelHandler.closeConnection();
                }
            });
        }
    }

    void tryToRenewLeasePeriod() throws Exception {
        this.baseTimeInMs.set(System.currentTimeMillis());
        if (this.canAcquireLease()) {
            if (System.currentTimeMillis() > this.getEndLeaseInMs()) {
                this.endLeaseInMs.set(0L);
                this.panicker.panic(this.tsoHostAndPort + " expired lease! Master is committing suicide");
            } else {
                this.endLeaseInMs.set(this.baseTimeInMs.get() + this.leasePeriodInMs);
                LOG.trace("{} renewed lease: Version {}/End of lease at {}ms", new Object[]{this.tsoHostAndPort, this.leaseNodeVersion, this.endLeaseInMs});
            }
        } else {
            this.endLeaseInMs.set(0L);
            this.panicker.panic(this.tsoHostAndPort + " lease lost (Ver. " + this.leaseNodeVersion + ")! Other instance is Master. Committing suicide...");
        }
    }

    private boolean haveLease() {
        return this.stillInLeasePeriod();
    }

    private long getEndLeaseInMs() {
        return this.endLeaseInMs.get();
    }

    private boolean canAcquireLease() throws Exception {
        try {
            int previousLeaseNodeVersion = this.leaseNodeVersion;
            byte[] instanceInfo = this.tsoHostAndPort.getBytes(Charsets.UTF_8);
            Stat stat = (Stat)((BackgroundPathAndBytesable)this.zkClient.setData().withVersion(previousLeaseNodeVersion)).forPath(this.leasePath, instanceInfo);
            this.leaseNodeVersion = stat.getVersion();
            LOG.trace("{} got new lease version {}", (Object)this.tsoHostAndPort, (Object)this.leaseNodeVersion);
        }
        catch (KeeperException.BadVersionException e) {
            return false;
        }
        return true;
    }

    protected void startUp() {
    }

    protected void shutDown() {
        try {
            this.tsoChannelHandler.close();
            LOG.info("Channel handler closed");
        }
        catch (IOException e) {
            LOG.error("Error closing TSOChannelHandler", (Throwable)e);
        }
    }

    protected void runOneIteration() throws Exception {
        if (!this.haveLease()) {
            this.tryToGetInitialLeasePeriod();
        } else {
            this.tryToRenewLeasePeriod();
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        final long guardLeasePeriodInMs = this.leasePeriodInMs / 4L;
        return new AbstractScheduledService.CustomScheduler(){

            protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                if (!LeaseManager.this.haveLease()) {
                    Stat stat = (Stat)LeaseManager.this.zkClient.checkExists().forPath(LeaseManager.this.leasePath);
                    LeaseManager.this.leaseNodeVersion = stat.getVersion();
                    LOG.trace("{} will try to get lease (with Ver. {}) in {}ms", new Object[]{LeaseManager.this.tsoHostAndPort, LeaseManager.this.leaseNodeVersion, LeaseManager.this.leasePeriodInMs});
                    return new AbstractScheduledService.CustomScheduler.Schedule(LeaseManager.this.leasePeriodInMs, TimeUnit.MILLISECONDS);
                }
                long waitTimeInMs = LeaseManager.this.getEndLeaseInMs() - System.currentTimeMillis() - guardLeasePeriodInMs;
                LOG.trace("{} will try to renew lease (with Ver. {}) in {}ms", new Object[]{LeaseManager.this.tsoHostAndPort, LeaseManager.this.leaseNodeVersion, waitTimeInMs});
                return new AbstractScheduledService.CustomScheduler.Schedule(waitTimeInMs, TimeUnit.MILLISECONDS);
            }
        };
    }

    public String toString() {
        return this.tsoHostAndPort;
    }

    private void createLeaseManagementZNode() throws LeaseManagement.LeaseManagementException {
        try {
            this.validateZKPath(this.leasePath);
        }
        catch (Exception e) {
            throw new LeaseManagement.LeaseManagementException("Error creating Lease Management ZNode", e);
        }
    }

    private void createCurrentTSOZNode() throws LeaseManagement.LeaseManagementException {
        try {
            this.validateZKPath(this.currentTSOPath);
        }
        catch (Exception e) {
            throw new LeaseManagement.LeaseManagementException("Error creating TSO ZNode", e);
        }
    }

    private void validateZKPath(String zkPath) throws Exception {
        EnsurePath path = this.zkClient.newNamespaceAwareEnsurePath(zkPath);
        path.ensure(this.zkClient.getZookeeperClient());
        Stat stat = (Stat)this.zkClient.checkExists().forPath(zkPath);
        Preconditions.checkNotNull((Object)stat);
        LOG.info("Path {} ensured", (Object)path.getPath());
    }

    private void advertiseTSOServerInfoThroughZK(long epoch) throws Exception {
        Stat previousTSOZNodeStat = new Stat();
        byte[] previousTSOInfoAsBytes = (byte[])((WatchPathable)this.zkClient.getData().storingStatIn(previousTSOZNodeStat)).forPath(this.currentTSOPath);
        if (previousTSOInfoAsBytes != null && !new String(previousTSOInfoAsBytes, Charsets.UTF_8).isEmpty()) {
            String previousTSOInfo = new String(previousTSOInfoAsBytes, Charsets.UTF_8);
            String[] previousTSOAndEpochArray = previousTSOInfo.split("#");
            Preconditions.checkArgument((previousTSOAndEpochArray.length == 2 ? 1 : 0) != 0, (String)"Incorrect TSO Info found: ", (Object)previousTSOInfo);
            long oldEpoch = Long.parseLong(previousTSOAndEpochArray[1]);
            if (oldEpoch > epoch) {
                throw new LeaseManagement.LeaseManagementException("Another TSO replica was found " + previousTSOInfo);
            }
        }
        String tsoInfoAsString = this.tsoHostAndPort + "#" + Long.toString(epoch);
        byte[] tsoInfoAsBytes = tsoInfoAsString.getBytes(Charsets.UTF_8);
        ((BackgroundPathAndBytesable)this.zkClient.setData().withVersion(previousTSOZNodeStat.getVersion())).forPath(this.currentTSOPath, tsoInfoAsBytes);
        LOG.info("TSO instance {} (Epoch {}) advertised through ZK", (Object)this.tsoHostAndPort, (Object)epoch);
    }
}

