/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.omid.metrics.Gauge;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.MetricsUtils;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorldClockOracleImpl
implements TimestampOracle {
    private static final Logger LOG = LoggerFactory.getLogger(WorldClockOracleImpl.class);
    static final long MAX_TX_PER_MS = 1000000L;
    static final long TIMESTAMP_INTERVAL_MS = 10000L;
    private static final long TIMESTAMP_ALLOCATION_INTERVAL_MS = 7000L;
    private long lastTimestamp;
    private long maxTimestamp;
    private TimestampStorage storage;
    private Panicker panicker;
    private volatile long maxAllocatedTime;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ts-persist-%d").build());
    private Runnable allocateTimestampsBatchTask;

    @Inject
    public WorldClockOracleImpl(MetricsRegistry metrics, TimestampStorage tsStorage, Panicker panicker) throws IOException {
        this.storage = tsStorage;
        this.panicker = panicker;
        metrics.gauge(MetricsUtils.name((String)"tso", (String[])new String[]{"maxTimestamp"}), (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return WorldClockOracleImpl.this.maxTimestamp;
            }
        });
    }

    @Override
    public void initialize() throws IOException {
        this.lastTimestamp = this.maxTimestamp = this.storage.getMaxTimestamp();
        this.allocateTimestampsBatchTask = new AllocateTimestampBatchTask(this.lastTimestamp);
        this.scheduler.schedule(this.allocateTimestampsBatchTask, 0L, TimeUnit.MILLISECONDS);
        while (System.currentTimeMillis() * 1000000L < this.lastTimestamp) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        this.scheduler.scheduleAtFixedRate(this.allocateTimestampsBatchTask, 7000L, 7000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long next() {
        long currentMsFirstTimestamp = System.currentTimeMillis() * 1000000L;
        this.lastTimestamp += 50L;
        if (this.lastTimestamp >= currentMsFirstTimestamp) {
            return this.lastTimestamp;
        }
        if (currentMsFirstTimestamp >= this.maxTimestamp) {
            while (this.maxAllocatedTime <= currentMsFirstTimestamp) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            assert (this.maxAllocatedTime > this.maxTimestamp);
            this.maxTimestamp = this.maxAllocatedTime;
        }
        this.lastTimestamp = currentMsFirstTimestamp;
        return this.lastTimestamp;
    }

    @Override
    public long getLast() {
        return this.lastTimestamp;
    }

    public String toString() {
        return String.format("TimestampOracle -> LastTimestamp: %d, MaxTimestamp: %d", this.lastTimestamp, this.maxTimestamp);
    }

    @VisibleForTesting
    static class InMemoryTimestampStorage
    implements TimestampStorage {
        long maxTime = 0L;

        InMemoryTimestampStorage() {
        }

        public void updateMaxTimestamp(long previousMaxTime, long nextMaxTime) {
            this.maxTime = nextMaxTime;
            LOG.info("Updating max timestamp: (previous:{}, new:{})", (Object)previousMaxTime, (Object)nextMaxTime);
        }

        public long getMaxTimestamp() {
            return this.maxTime;
        }
    }

    private class AllocateTimestampBatchTask
    implements Runnable {
        long previousMaxTime;

        AllocateTimestampBatchTask(long previousMaxTime) {
            this.previousMaxTime = previousMaxTime;
        }

        @Override
        public void run() {
            long newMaxTime = (System.currentTimeMillis() + 10000L) * 1000000L;
            try {
                WorldClockOracleImpl.this.storage.updateMaxTimestamp(this.previousMaxTime, newMaxTime);
                WorldClockOracleImpl.this.maxAllocatedTime = newMaxTime;
                this.previousMaxTime = newMaxTime;
            }
            catch (Throwable e) {
                WorldClockOracleImpl.this.panicker.panic("Can't store the new max timestamp", e);
            }
        }
    }
}

