/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.protobuf.MessageLite;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.client.ConnectionException;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOClientRaw {
    private static final Logger LOG = LoggerFactory.getLogger(TSOClientRaw.class);
    private final BlockingQueue<SettableFuture<TSOProto.Response>> responseQueue = new ArrayBlockingQueue<SettableFuture<TSOProto.Response>>(5);
    private final Channel channel;

    public TSOClientRaw(String host, int port) throws InterruptedException, ExecutionException {
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("tsoclient-boss-%d").build()), (Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("tsoclient-worker-%d").build()), 3);
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
        InetSocketAddress addr = new InetSocketAddress(host, port);
        ChannelPipeline pipeline = bootstrap.getPipeline();
        pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(8192, 0, 4, 0, 4));
        pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast("protobufdecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)TSOProto.Response.getDefaultInstance()));
        pipeline.addLast("protobufencoder", (ChannelHandler)new ProtobufEncoder());
        Handler handler = new Handler();
        pipeline.addLast("handler", (ChannelHandler)handler);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("connectTimeoutMillis", (Object)100);
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)addr).await();
        this.channel = channelFuture.getChannel();
    }

    public void write(TSOProto.Request request) {
        this.channel.write((Object)request);
    }

    public Future<TSOProto.Response> getResponse() throws InterruptedException {
        SettableFuture future = SettableFuture.create();
        this.responseQueue.put((SettableFuture<TSOProto.Response>)future);
        return future;
    }

    public void close() throws InterruptedException {
        this.responseQueue.put((SettableFuture<TSOProto.Response>)SettableFuture.create());
        this.channel.close();
    }

    private class Handler
    extends SimpleChannelHandler {
        private Handler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            LOG.info("Message received", (Object)e);
            if (e.getMessage() instanceof TSOProto.Response) {
                TSOProto.Response resp = (TSOProto.Response)e.getMessage();
                try {
                    SettableFuture future = (SettableFuture)TSOClientRaw.this.responseQueue.take();
                    future.set((Object)resp);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted in handler", (Throwable)ie);
                }
            } else {
                LOG.warn("Received unknown message", e.getMessage());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            LOG.info("Exception received", e.getCause());
            try {
                SettableFuture future = (SettableFuture)TSOClientRaw.this.responseQueue.take();
                future.setException(e.getCause());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted handling exception", (Throwable)ie);
            }
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            LOG.info("Disconnected");
            try {
                SettableFuture future = (SettableFuture)TSOClientRaw.this.responseQueue.take();
                future.setException((Throwable)new ConnectionException());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted handling exception", (Throwable)ie);
            }
        }
    }
}

