/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.debug;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import technology.tabula.Cell;
import technology.tabula.CommandLineApp;
import technology.tabula.Line;
import technology.tabula.ObjectExtractor;
import technology.tabula.Page;
import technology.tabula.ProjectionProfile;
import technology.tabula.Rectangle;
import technology.tabula.Ruling;
import technology.tabula.Table;
import technology.tabula.TextChunk;
import technology.tabula.TextElement;
import technology.tabula.Utils;
import technology.tabula.detectors.NurminenDetectionAlgorithm;
import technology.tabula.extractors.BasicExtractionAlgorithm;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

public class Debug {
    private static final float CIRCLE_RADIUS = 5.0f;
    private static final Color[] COLORS = new Color[]{new Color(27, 158, 119), new Color(217, 95, 2), new Color(117, 112, 179), new Color(231, 41, 138), new Color(102, 166, 30)};

    public static void debugIntersections(Graphics2D g, Page page) {
        int i = 0;
        for (Point2D p : Ruling.findIntersections(page.getHorizontalRulings(), page.getVerticalRulings()).keySet()) {
            g.setColor(COLORS[i++ % 5]);
            g.fill(new Ellipse2D.Float((float)p.getX() - 2.5f, (float)p.getY() - 2.5f, 5.0f, 5.0f));
        }
    }

    private static void debugNonCleanRulings(Graphics2D g, Page page) {
        Debug.drawShapes(g, page.getUnprocessedRulings());
    }

    private static void debugRulings(Graphics2D g, Page page) {
        ArrayList<Ruling> rulings = new ArrayList<Ruling>(page.getHorizontalRulings());
        rulings.addAll(page.getVerticalRulings());
        Debug.drawShapes(g, rulings);
    }

    private static void debugColumns(Graphics2D g, Page page) {
        List<TextChunk> textChunks = TextElement.mergeWords(page.getText());
        List<Line> lines = TextChunk.groupByLines(textChunks);
        List<Float> columns = BasicExtractionAlgorithm.columnPositions(lines);
        int i = 0;
        for (float p : columns) {
            Ruling r = new Ruling(new Point2D.Float(p, page.getTop()), new Point2D.Float(p, page.getBottom()));
            g.setColor(COLORS[i++ % 5]);
            Debug.drawShape(g, r);
        }
    }

    private static void debugCharacters(Graphics2D g, Page page) {
        Debug.drawShapes(g, page.getText());
    }

    private static void debugTextChunks(Graphics2D g, Page page) {
        List<TextChunk> chunks = TextElement.mergeWords(page.getText(), page.getVerticalRulings());
        Debug.drawShapes(g, chunks);
    }

    private static void debugSpreadsheets(Graphics2D g, Page page) {
        SpreadsheetExtractionAlgorithm sea = new SpreadsheetExtractionAlgorithm();
        List<Table> tables = sea.extract(page);
        Debug.drawShapes(g, tables);
    }

    private static void debugCells(Graphics2D g, Rectangle area, Page page) {
        List<Ruling> h = page.getHorizontalRulings();
        List<Ruling> v = page.getVerticalRulings();
        if (area != null) {
            h = Ruling.cropRulingsToArea(h, area);
            v = Ruling.cropRulingsToArea(v, area);
        }
        List<Cell> cells = SpreadsheetExtractionAlgorithm.findCells(h, v);
        Debug.drawShapes(g, cells);
    }

    private static void debugDetectedTables(Graphics2D g, Page page) {
        NurminenDetectionAlgorithm detectionAlgorithm = new NurminenDetectionAlgorithm();
        List<Rectangle> tables = detectionAlgorithm.detect(page);
        Debug.drawShapes(g, tables);
    }

    private static void drawShapes(Graphics2D g, Collection<? extends Shape> shapes, Stroke stroke) {
        int i = 0;
        g.setStroke(stroke);
        for (Shape shape : shapes) {
            g.setColor(COLORS[i++ % 5]);
            Debug.drawShape(g, shape);
        }
    }

    private static void drawShapes(Graphics2D g, Collection<? extends Shape> shapes) {
        Debug.drawShapes(g, shapes, new BasicStroke(2.0f));
    }

    private static void debugProjectionProfile(Graphics2D g, Page page) {
        int i;
        Point2D.Double cur;
        float horizSmoothKernel = 0.0f;
        float vertSmoothKernel = 0.0f;
        for (Rectangle rectangle : page.getText()) {
            horizSmoothKernel = (float)((double)horizSmoothKernel + rectangle.getWidth());
            vertSmoothKernel = (float)((double)vertSmoothKernel + rectangle.getHeight());
        }
        System.out.println("hsk: " + (horizSmoothKernel /= (float)page.getText().size()) + " vsk: " + (vertSmoothKernel /= (float)page.getText().size()));
        ProjectionProfile profile = new ProjectionProfile(page, TextElement.mergeWords(page.getText(), page.getVerticalRulings()), horizSmoothKernel * 1.5f, vertSmoothKernel);
        float f = (float)Math.pow(10.0, 1.0);
        float[] hproj = profile.getHorizontalProjection();
        float[] vproj = profile.getVerticalProjection();
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.RED);
        Point2D.Double last = new Point2D.Double(page.getLeft(), page.getBottom());
        for (int i2 = 0; i2 < hproj.length; ++i2) {
            cur = new Point2D.Double(page.getLeft() + (float)i2 / f, page.getBottom() - hproj[i2]);
            g.draw(new Line2D.Double(last, cur));
            last = cur;
        }
        g.setColor(Color.BLUE);
        float[] deriv = ProjectionProfile.filter(ProjectionProfile.getFirstDeriv(profile.getHorizontalProjection()), 0.01f);
        last = new Point2D.Double(page.getLeft(), page.getBottom());
        for (int i3 = 0; i3 < deriv.length; ++i3) {
            cur = new Point2D.Double(page.getLeft() + (float)i3 / f, page.getBottom() - deriv[i3]);
            g.draw(new Line2D.Double(last, cur));
            last = cur;
        }
        g.setColor(Color.MAGENTA);
        g.setStroke(new BasicStroke(1.0f));
        float[] seps = profile.findVerticalSeparators(horizSmoothKernel * 2.5f);
        for (i = 0; i < seps.length; ++i) {
            float x = page.getLeft() + seps[i];
            g.draw(new Line2D.Double(x, page.getTop(), x, page.getBottom()));
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.GREEN);
        last = new Point2D.Double(page.getLeft(), page.getTop());
        for (i = 0; i < vproj.length; ++i) {
            cur = new Point2D.Double(page.getLeft() + vproj[i] / f, page.getTop() + (float)i / f);
            g.draw(new Line2D.Double(last, cur));
            last = cur;
        }
        g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
        deriv = ProjectionProfile.filter(ProjectionProfile.getFirstDeriv(vproj), 0.1f);
        last = new Point2D.Double(page.getRight(), page.getTop());
        for (i = 0; i < deriv.length; ++i) {
            cur = new Point2D.Double(page.getRight() - deriv[i] * 10.0f, page.getTop() + (float)i / f);
            g.draw(new Line2D.Double(last, cur));
            last = cur;
        }
        g.setStroke(new BasicStroke(1.5f));
        seps = profile.findHorizontalSeparators(vertSmoothKernel);
        for (i = 0; i < seps.length; ++i) {
            float y = page.getTop() + seps[i];
            g.draw(new Line2D.Double(page.getLeft(), y, page.getRight(), y));
        }
    }

    private static void drawShape(Graphics2D g, Shape shape) {
        g.draw(shape);
    }

    public static void renderPage(String pdfPath, String outPath, int pageNumber, Rectangle area, boolean drawTextChunks, boolean drawSpreadsheets, boolean drawRulings, boolean drawIntersections, boolean drawColumns, boolean drawCharacters, boolean drawArea, boolean drawCells, boolean drawUnprocessedRulings, boolean drawProjectionProfile, boolean drawClippingPaths, boolean drawDetectedTables) throws IOException {
        PDDocument document = PDDocument.load((File)new File(pdfPath));
        ObjectExtractor oe = new ObjectExtractor(document);
        Page page = oe.extract(pageNumber + 1);
        if (area != null) {
            page = page.getArea(area);
        }
        PDPage p = document.getPage(pageNumber);
        BufferedImage image = Utils.pageConvertToImage(document, p, 72, ImageType.RGB);
        Graphics2D g = (Graphics2D)image.getGraphics();
        if (drawTextChunks) {
            Debug.debugTextChunks(g, page);
        }
        if (drawSpreadsheets) {
            Debug.debugSpreadsheets(g, page);
        }
        if (drawRulings) {
            Debug.debugRulings(g, page);
        }
        if (drawIntersections) {
            Debug.debugIntersections(g, page);
        }
        if (drawColumns) {
            Debug.debugColumns(g, page);
        }
        if (drawCharacters) {
            Debug.debugCharacters(g, page);
        }
        if (drawArea) {
            g.setColor(Color.ORANGE);
            Debug.drawShape(g, area);
        }
        if (drawCells) {
            Debug.debugCells(g, area, page);
        }
        if (drawUnprocessedRulings) {
            Debug.debugNonCleanRulings(g, page);
        }
        if (drawProjectionProfile) {
            Debug.debugProjectionProfile(g, page);
        }
        if (drawClippingPaths) {
            // empty if block
        }
        if (drawDetectedTables) {
            Debug.debugDetectedTables(g, page);
        }
        document.close();
        ImageIO.write((RenderedImage)image, "jpg", new File(outPath));
    }

    private static Options buildOptions() {
        Options o = new Options();
        o.addOption("h", "help", false, "Print this help text.");
        o.addOption("r", "rulings", false, "Show detected rulings.");
        o.addOption("i", "intersections", false, "Show intersections between rulings.");
        o.addOption("s", "spreadsheets", false, "Show detected spreadsheets.");
        o.addOption("t", "textchunks", false, "Show detected text chunks (merged characters)");
        o.addOption("c", "columns", false, "Show columns as detected by BasicExtractionAlgorithm");
        o.addOption("e", "characters", false, "Show detected characters");
        o.addOption("g", "region", false, "Show provided region (-a parameter)");
        o.addOption("l", "cells", false, "Show detected cells");
        o.addOption("u", "unprocessed-rulings", false, "Show non-cleaned rulings");
        o.addOption("f", "profile", false, "Show projection profile");
        o.addOption("n", "clipping-paths", false, "Show clipping paths");
        o.addOption("d", "detected-tables", false, "Show detected tables");
        o.addOption(Option.builder((String)"a").longOpt("area").desc("Portion of the page to analyze (top,left,bottom,right). Example: --area 269.875,12.75,790.5,561. Default is entire page").hasArg().argName("AREA").build());
        o.addOption(Option.builder((String)"p").longOpt("pages").desc("Comma separated list of ranges, or all. Examples: --pages 1-3,5-7, --pages 3 or --pages all. Default is --pages 1").hasArg().argName("PAGES").build());
        return o;
    }

    public static void main(String[] args) throws IOException {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(Debug.buildOptions(), args);
            List<Object> pages = new ArrayList<Integer>();
            if (line.hasOption('p')) {
                pages = Utils.parsePagesOption(line.getOptionValue('p'));
            } else {
                pages.add(1);
            }
            if (line.hasOption('h')) {
                Debug.printHelp();
                System.exit(0);
            }
            if (line.getArgs().length != 1) {
                throw new ParseException("Need one filename\nTry --help for help");
            }
            File pdfFile = new File(line.getArgs()[0]);
            if (!pdfFile.exists()) {
                throw new ParseException("File does not exist");
            }
            if (line.hasOption('g') && !line.hasOption('a')) {
                throw new ParseException("-g argument needs an area (-a)");
            }
            Rectangle area = null;
            if (line.hasOption('a')) {
                List<Float> f = CommandLineApp.parseFloatList(line.getOptionValue('a'));
                if (f.size() != 4) {
                    throw new ParseException("area parameters must be top,left,bottom,right");
                }
                area = new Rectangle(f.get(0).floatValue(), f.get(1).floatValue(), f.get(3).floatValue() - f.get(1).floatValue(), f.get(2).floatValue() - f.get(0).floatValue());
            }
            if (pages == null) {
                PDDocument document = PDDocument.load((File)pdfFile);
                int numPages = document.getNumberOfPages();
                pages = new ArrayList(numPages);
                for (int i = 1; i <= numPages; ++i) {
                    pages.add(i);
                }
                document.close();
            }
            Iterator<Object> iterator = pages.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Debug.renderPage(pdfFile.getAbsolutePath(), new File(pdfFile.getParent(), Debug.removeExtension(pdfFile.getName()) + "-" + i + ".jpg").getAbsolutePath(), i - 1, area, line.hasOption('t'), line.hasOption('s'), line.hasOption('r'), line.hasOption('i'), line.hasOption('c'), line.hasOption('e'), line.hasOption('g'), line.hasOption('l'), line.hasOption('u'), line.hasOption('f'), line.hasOption('n'), line.hasOption('d'));
            }
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("tabula-debug", "Generate debugging images", Debug.buildOptions(), "", true);
    }

    private static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }
}

