/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.ArrayTemplateBuilder;
import org.msgpack.template.builder.JavassistTemplateBuilder;
import org.msgpack.template.builder.OrdinalEnumTemplateBuilder;
import org.msgpack.template.builder.ReflectionBeansTemplateBuilder;
import org.msgpack.template.builder.ReflectionTemplateBuilder;
import org.msgpack.template.builder.TemplateBuilder;

public class TemplateBuilderChain {
    protected List<TemplateBuilder> templateBuilders = new ArrayList<TemplateBuilder>();
    protected TemplateBuilder forceBuilder;

    private static boolean enableDynamicCodeGeneration() {
        try {
            return !System.getProperty("java.vm.name").equals("Dalvik");
        }
        catch (Exception e) {
            return true;
        }
    }

    public TemplateBuilderChain(TemplateRegistry registry) {
        this(registry, null);
    }

    public TemplateBuilderChain(TemplateRegistry registry, ClassLoader cl) {
        this.reset(registry, cl);
    }

    protected void reset(TemplateRegistry registry, ClassLoader cl) {
        if (registry == null) {
            throw new NullPointerException("registry is null");
        }
        this.forceBuilder = new JavassistTemplateBuilder(registry);
        if (cl != null) {
            ((JavassistTemplateBuilder)this.forceBuilder).addClassLoader(cl);
        }
        this.templateBuilders.add(new ArrayTemplateBuilder(registry));
        this.templateBuilders.add(new OrdinalEnumTemplateBuilder(registry));
        if (TemplateBuilderChain.enableDynamicCodeGeneration()) {
            TemplateBuilder builder = this.forceBuilder;
            this.templateBuilders.add(builder);
            this.templateBuilders.add(new ReflectionBeansTemplateBuilder(registry));
        } else {
            ReflectionTemplateBuilder builder = new ReflectionTemplateBuilder(registry);
            this.templateBuilders.add(builder);
            this.templateBuilders.add(new ReflectionBeansTemplateBuilder(registry));
        }
    }

    public TemplateBuilder getForceBuilder() {
        return this.forceBuilder;
    }

    public TemplateBuilder select(Type targetType, boolean hasAnnotation) {
        for (TemplateBuilder tb : this.templateBuilders) {
            if (!tb.matchType(targetType, hasAnnotation)) continue;
            return tb;
        }
        return null;
    }
}

