/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.SerializableSupplier;

public class HadoopFileIO
implements FileIO,
HadoopConfigurable {
    private SerializableSupplier<Configuration> hadoopConf;

    public HadoopFileIO() {
    }

    public HadoopFileIO(Configuration hadoopConf) {
        this(new SerializableConfiguration(hadoopConf)::get);
    }

    public HadoopFileIO(SerializableSupplier<Configuration> hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    public Configuration conf() {
        return (Configuration)this.hadoopConf.get();
    }

    public InputFile newInputFile(String path) {
        return HadoopInputFile.fromLocation((CharSequence)path, (Configuration)this.hadoopConf.get());
    }

    public OutputFile newOutputFile(String path) {
        return HadoopOutputFile.fromPath(new Path(path), (Configuration)this.hadoopConf.get());
    }

    public void deleteFile(String path) {
        Path toDelete = new Path(path);
        FileSystem fs = Util.getFs(toDelete, (Configuration)this.hadoopConf.get());
        try {
            fs.delete(toDelete, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to delete file: %s", new Object[]{path});
        }
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = new SerializableConfiguration(conf)::get;
    }

    public Configuration getConf() {
        return (Configuration)this.hadoopConf.get();
    }

    @Override
    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }
}

