/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class DrillDateDateObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements DateObjectInspector {
        public Optional() {
            super(TypeInfoFactory.dateTypeInfo);
        }

        public Date getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableDateHolder h = (NullableDateHolder)o;
            return Date.ofEpochMilli((long)h.value);
        }

        public DateWritableV2 getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableDateHolder h = (NullableDateHolder)o;
            return new DateWritableV2(Date.ofEpochMilli((long)h.value));
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements DateObjectInspector {
        public Required() {
            super(TypeInfoFactory.dateTypeInfo);
        }

        public Date getPrimitiveJavaObject(Object o) {
            DateHolder h = (DateHolder)o;
            return Date.ofEpochMilli((long)h.value);
        }

        public DateWritableV2 getPrimitiveWritableObject(Object o) {
            DateHolder h = (DateHolder)o;
            return new DateWritableV2(Date.ofEpochMilli((long)h.value));
        }
    }
}

