/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveToRelDataTypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(HiveToRelDataTypeConverter.class);
    private static final String UNSUPPORTED_HIVE_DATA_TYPE_ERROR_MSG = "Unsupported Hive data type %s. %nFollowing Hive data types are supported in Drill INFORMATION_SCHEMA: BOOLEAN, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, DATE, TIMESTAMP, BINARY, DECIMAL, STRING, VARCHAR, CHAR, LIST, MAP, STRUCT and UNION";
    private final RelDataTypeFactory typeFactory;

    public HiveToRelDataTypeConverter(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public RelDataType convertToNullableRelDataType(FieldSchema field) {
        TypeInfo fieldTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
        return this.convertToRelDataType(fieldTypeInfo, true);
    }

    private RelDataType convertToRelDataType(TypeInfo typeInfo, boolean nullable) {
        ObjectInspector.Category typeCategory = typeInfo.getCategory();
        switch (typeCategory) {
            case PRIMITIVE: {
                return this.typeFactory.createTypeWithNullability(this.getRelDataType((PrimitiveTypeInfo)typeInfo), nullable);
            }
            case LIST: {
                return this.typeFactory.createTypeWithNullability(this.getRelDataType((ListTypeInfo)typeInfo, nullable), nullable);
            }
            case MAP: {
                return this.typeFactory.createTypeWithNullability(this.getRelDataType((MapTypeInfo)typeInfo, nullable), nullable);
            }
            case STRUCT: {
                return this.typeFactory.createTypeWithNullability(this.getRelDataType((StructTypeInfo)typeInfo, nullable), nullable);
            }
            case UNION: {
                logger.warn("There is no UNION data type in SQL. Converting it to Sql type OTHER to avoid breaking INFORMATION_SCHEMA queries");
                return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.OTHER), nullable);
            }
        }
        throw new RuntimeException(String.format(UNSUPPORTED_HIVE_DATA_TYPE_ERROR_MSG, typeCategory));
    }

    private RelDataType getRelDataType(StructTypeInfo structTypeInfo, boolean nullable) {
        ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
        List relDataTypes = structTypeInfo.getAllStructFieldTypeInfos().stream().map(typeInfo -> this.convertToRelDataType((TypeInfo)typeInfo, nullable)).collect(Collectors.toList());
        return this.typeFactory.createStructType(relDataTypes, (List)fieldNames);
    }

    private RelDataType getRelDataType(MapTypeInfo mapTypeInfo, boolean nullable) {
        RelDataType keyType = this.convertToRelDataType(mapTypeInfo.getMapKeyTypeInfo(), nullable);
        RelDataType valueType = this.convertToRelDataType(mapTypeInfo.getMapValueTypeInfo(), nullable);
        return this.typeFactory.createMapType(keyType, valueType);
    }

    private RelDataType getRelDataType(ListTypeInfo listTypeInfo, boolean nullable) {
        RelDataType listElemTypeInfo = this.convertToRelDataType(listTypeInfo.getListElementTypeInfo(), nullable);
        return this.typeFactory.createArrayType(listElemTypeInfo, -1L);
    }

    private RelDataType getRelDataType(PrimitiveTypeInfo primitiveTypeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case STRING: 
            case VARCHAR: {
                return this.getRelDataType(primitiveTypeInfo, SqlTypeName.VARCHAR);
            }
            case CHAR: {
                return this.getRelDataType(primitiveTypeInfo, SqlTypeName.CHAR);
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                return this.typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case DECIMAL: {
                return this.getRelDataType((DecimalTypeInfo)primitiveTypeInfo);
            }
            case BOOLEAN: {
                return this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case LONG: {
                return this.typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return this.typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case DOUBLE: {
                return this.typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case DATE: {
                return this.typeFactory.createSqlType(SqlTypeName.DATE);
            }
            case TIMESTAMP: {
                return this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case BINARY: {
                return this.typeFactory.createSqlType(SqlTypeName.VARBINARY);
            }
        }
        throw new RuntimeException(String.format(UNSUPPORTED_HIVE_DATA_TYPE_ERROR_MSG, primitiveCategory));
    }

    private RelDataType getRelDataType(PrimitiveTypeInfo pTypeInfo, SqlTypeName typeName) {
        int maxLen = TypeInfoUtils.getCharacterLengthForType((PrimitiveTypeInfo)pTypeInfo);
        RelDataType relDataType = this.typeFactory.createSqlType(typeName, maxLen);
        return this.typeFactory.createTypeWithCharsetAndCollation(relDataType, Util.getDefaultCharset(), SqlCollation.IMPLICIT);
    }

    private RelDataType getRelDataType(DecimalTypeInfo decimalTypeInfo) {
        return this.typeFactory.createSqlType(SqlTypeName.DECIMAL, decimalTypeInfo.precision(), decimalTypeInfo.scale());
    }
}

