/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.readers.HiveDefaultRecordReader;
import org.apache.drill.exec.store.hive.readers.HiveTextRecordReader;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.UserGroupInformation;

public class ReadersInitializer {
    private static final String TEXT_FORMAT = TextInputFormat.class.getCanonicalName();

    public static List<RecordReader> init(ExecutorFragmentContext ctx, HiveSubScan config) {
        HiveReaderFactory readerFactory = ReadersInitializer.getReaderFactory(config);
        UserGroupInformation proxyUgi = ImpersonationUtil.createProxyUgi((String)config.getUserName(), (String)ctx.getQueryUserName());
        List<List<InputSplit>> inputSplits = config.getInputSplits();
        HiveConf hiveConf = config.getHiveConf();
        if (inputSplits.isEmpty()) {
            return Collections.singletonList(readerFactory.createReader(config.getTable(), null, null, config.getColumns(), (FragmentContext)ctx, hiveConf, proxyUgi));
        }
        IndexedPartitions partitions = ReadersInitializer.getPartitions(config);
        return IntStream.range(0, inputSplits.size()).mapToObj(idx -> readerFactory.createReader(config.getTable(), partitions.get(idx), (Collection)inputSplits.get(idx), config.getColumns(), (FragmentContext)ctx, hiveConf, proxyUgi)).collect(Collectors.toList());
    }

    private static HiveReaderFactory getReaderFactory(HiveSubScan config) {
        String inputFormat = config.getTable().getSd().getInputFormat();
        return TEXT_FORMAT.equals(inputFormat) ? HiveTextRecordReader::new : HiveDefaultRecordReader::new;
    }

    private static IndexedPartitions getPartitions(HiveSubScan config) {
        return config.getPartitions() == null || config.getPartitions().isEmpty() ? idx -> null : config.getPartitions()::get;
    }

    @FunctionalInterface
    private static interface HiveReaderFactory {
        public RecordReader createReader(HiveTableWithColumnCache var1, HivePartition var2, Collection<InputSplit> var3, List<SchemaPath> var4, FragmentContext var5, HiveConf var6, UserGroupInformation var7);
    }

    @FunctionalInterface
    private static interface IndexedPartitions {
        public HivePartition get(int var1);
    }
}

