/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.complex;

import java.util.List;
import org.apache.drill.exec.store.hive.writers.HiveValueWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;

public class HiveListWriter
implements HiveValueWriter {
    private final ListObjectInspector listInspector;
    private final HiveValueWriter elementWriter;
    private final BaseWriter.ListWriter listWriter;

    public HiveListWriter(ListObjectInspector listInspector, BaseWriter.ListWriter listWriter, HiveValueWriter elementWriter) {
        this.listInspector = listInspector;
        this.elementWriter = elementWriter;
        this.listWriter = listWriter;
    }

    @Override
    public void write(Object value) {
        List list = this.listInspector.getList(value);
        if (list == null) {
            throw new UnsupportedOperationException("Null array is not supported in Hive.");
        }
        this.listWriter.startList();
        for (Object element : list) {
            if (element == null) {
                throw new UnsupportedOperationException("Null is not supported in Hive array!");
            }
            this.elementWriter.write(element);
        }
        this.listWriter.endList();
    }
}

