/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.util.CaseInsensitiveMap$;
import io.delta.standalone.internal.util.SchemaUtils$ParquetSchemaConverter$;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$ = new SchemaUtils$();

    public void checkFieldNames(Seq<String> names) {
        SchemaUtils$ParquetSchemaConverter$.MODULE$.checkFieldNames(names);
        names.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("\n"))).foreach((Function1 & Serializable)col -> {
            throw DeltaErrors$.MODULE$.invalidColumnName((String)col);
        });
    }

    public void checkUnenforceableNotNullConstraints(StructType schema) {
        this.traverseColumns$1((Seq)package$.MODULE$.Seq().empty(), schema);
    }

    public boolean isWriteCompatible(StructType existingSchema, StructType newSchema) {
        return this.isStructWriteCompatible$1(existingSchema, newSchema);
    }

    private Map<String, StructField> toFieldMap(Seq<StructField> fields) {
        return CaseInsensitiveMap$.MODULE$.apply(((IterableOnceOps)fields.map((Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private boolean matchesNullableType(DataType dt) {
        boolean bl;
        block12: {
            block13: {
                boolean bl2;
                block14: {
                    block15: {
                        while (true) {
                            DataType s2;
                            DataType s1;
                            DataType dataType;
                            if ((dataType = dt) instanceof StructType) {
                                StructType structType = (StructType)dataType;
                                bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])structType.getFields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$matchesNullableType$1(field)));
                                break block12;
                            }
                            if (dataType instanceof ArrayType) {
                                boolean bl3;
                                ArrayType arrayType = (ArrayType)dataType;
                                DataType dataType2 = arrayType.getElementType();
                                if (dataType2 instanceof StructType) {
                                    StructType structType = (StructType)dataType2;
                                    if (arrayType.containsNull()) {
                                        dt = structType;
                                        continue;
                                    }
                                    bl3 = false;
                                } else {
                                    bl3 = arrayType.containsNull();
                                }
                                bl = bl3;
                                break block12;
                            }
                            if (!(dataType instanceof MapType)) break block13;
                            MapType mapType = (MapType)dataType;
                            Tuple2 tuple2 = new Tuple2((Object)mapType.getKeyType(), (Object)mapType.getValueType());
                            if (tuple2 != null) {
                                DataType s12 = (DataType)tuple2._1();
                                DataType s22 = (DataType)tuple2._2();
                                if (s12 instanceof StructType) {
                                    StructType structType = (StructType)s12;
                                    if (s22 instanceof StructType) {
                                        StructType structType2 = (StructType)s22;
                                        if (mapType.valueContainsNull() && this.matchesNullableType(structType)) {
                                            dt = structType2;
                                            continue;
                                        }
                                        bl2 = false;
                                        break block14;
                                    }
                                }
                            }
                            if (tuple2 != null && (s1 = (DataType)tuple2._1()) instanceof StructType) {
                                StructType structType = (StructType)s1;
                                if (mapType.valueContainsNull()) {
                                    dt = structType;
                                    continue;
                                }
                                bl2 = false;
                                break block14;
                            }
                            if (tuple2 == null || !((s2 = (DataType)tuple2._2()) instanceof StructType)) break block15;
                            StructType structType = (StructType)s2;
                            if (!mapType.valueContainsNull()) break;
                            dt = structType;
                        }
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
                bl = bl2;
                break block12;
            }
            bl = true;
        }
        return bl;
    }

    private String prettyFieldName(Seq<String> columnPath) {
        return ((IterableOnceOps)columnPath.map((Function1 & Serializable)n -> n.contains(".") ? new StringBuilder(2).append("`").append((String)n).append("`").toString() : n)).mkString(".");
    }

    private final void checkField$1(Seq path, StructField f) {
        DataType dataType = f.getDataType();
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            if (!this.matchesNullableType(arrayType.getElementType())) {
                throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)f.getName()))), arrayType.getElementType(), "element");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            boolean keyTypeNullable = this.matchesNullableType(mapType.getKeyType());
            boolean valueTypeNullable = this.matchesNullableType(mapType.getValueType());
            if (!keyTypeNullable) {
                throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)f.getName()))), mapType.getKeyType(), "key");
            }
            if (!valueTypeNullable) {
                throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)f.getName()))), mapType.getValueType(), "value");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$checkUnenforceableNotNullConstraints$1(SchemaUtils$ $this, Seq path$1, StructField field) {
        $this.checkField$1(path$1, field);
        $this.traverseColumns$1((Seq)path$1.$colon$plus((Object)field.getName()), field.getDataType());
    }

    private final void traverseColumns$1(Seq path, DataType dt) {
        block3: {
            while (true) {
                DataType dataType;
                if ((dataType = dt) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.getFields()), (Function1 & Serializable)field -> {
                        SchemaUtils$.$anonfun$checkUnenforceableNotNullConstraints$1(this, path, field);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    dt = arrayType.getElementType();
                    path = (Seq)path.$colon$plus((Object)"element");
                    continue;
                }
                if (!(dataType instanceof MapType)) break;
                MapType mapType = (MapType)dataType;
                this.traverseColumns$1((Seq)path.$colon$plus((Object)"key"), mapType.getKeyType());
                dt = mapType.getValueType();
                path = (Seq)path.$colon$plus((Object)"value");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final boolean isDatatypeWriteCompatible$1(DataType _existingType, DataType _newType) {
        boolean bl;
        block10: {
            Tuple2 tuple2;
            block11: {
                while (true) {
                    if ((tuple2 = new Tuple2((Object)_existingType, (Object)_newType)) != null) {
                        DataType e = (DataType)tuple2._1();
                        DataType n = (DataType)tuple2._2();
                        if (e instanceof StructType) {
                            StructType structType = (StructType)e;
                            if (n instanceof StructType) {
                                StructType structType2 = (StructType)n;
                                bl = this.isWriteCompatible(structType, structType2);
                                break block10;
                            }
                        }
                    }
                    if (tuple2 != null) {
                        DataType e = (DataType)tuple2._1();
                        DataType n = (DataType)tuple2._2();
                        if (e instanceof ArrayType) {
                            ArrayType arrayType = (ArrayType)e;
                            if (n instanceof ArrayType) {
                                ArrayType arrayType2 = (ArrayType)n;
                                if (!arrayType.containsNull() || arrayType2.containsNull()) {
                                    _newType = arrayType2.getElementType();
                                    _existingType = arrayType.getElementType();
                                    continue;
                                }
                                bl = false;
                                break block10;
                            }
                        }
                    }
                    if (tuple2 == null) break block11;
                    DataType e = (DataType)tuple2._1();
                    DataType n = (DataType)tuple2._2();
                    if (!(e instanceof MapType)) break block11;
                    MapType mapType = (MapType)e;
                    if (!(n instanceof MapType)) break block11;
                    MapType mapType2 = (MapType)n;
                    if (mapType.valueContainsNull() && !mapType2.valueContainsNull() || !this.isDatatypeWriteCompatible$1(mapType.getKeyType(), mapType2.getKeyType())) break;
                    _newType = mapType2.getValueType();
                    _existingType = mapType.getValueType();
                }
                bl = false;
                break block10;
            }
            if (tuple2 != null) {
                DataType a = (DataType)tuple2._1();
                DataType b = (DataType)tuple2._2();
                DataType dataType = a;
                DataType dataType2 = b;
                bl = !(dataType != null ? !((Object)dataType).equals(dataType2) : dataType2 != null);
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isWriteCompatible$5(SchemaUtils$ $this, Map existing$1, StructField newField) {
        Option option = existing$1.get((Object)newField.getName());
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField existingField = (StructField)some.value();
            String string = existingField.getName();
            String string2 = newField.getName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (existingField.isNullable()) {
                if (!newField.isNullable()) return false;
            }
            if (!$this.isDatatypeWriteCompatible$1(existingField.getDataType(), newField.getDataType())) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        return newField.isNullable();
    }

    private final boolean isStructWriteCompatible$1(StructType _existingSchema, StructType _newSchema) {
        Map<String, StructField> existing = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)_existingSchema.getFields()));
        scala.collection.immutable.Set existingFieldNames = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])_existingSchema.getFieldNames()), (Function1 & Serializable)x$2 -> x$2.toLowerCase(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Predef$.MODULE$.assert(existingFieldNames.size() == _existingSchema.length(), (Function0 & Serializable)() -> "Delta tables don't allow field names that only differ by case");
        scala.collection.immutable.Set newFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])_newSchema.getFieldNames()), (Function1 & Serializable)x$3 -> x$3.toLowerCase(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Predef$.MODULE$.assert(newFields.size() == _newSchema.length(), (Function0 & Serializable)() -> "Delta tables don't allow field names that only differ by case");
        if (!existingFieldNames.subsetOf((Set)newFields)) {
            return false;
        }
        return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])_newSchema.getFields()), (Function1 & Serializable)newField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isWriteCompatible$5(this, existing, newField)));
    }

    public static final /* synthetic */ boolean $anonfun$matchesNullableType$1(StructField field) {
        return field.isNullable() && MODULE$.matchesNullableType(field.getDataType());
    }

    private SchemaUtils$() {
    }
}

