/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.spss;

class CaseBuffer {
    private String[] stringValues;
    private double[] doubleValues;
    private int[] trailingSpaces;

    CaseBuffer(int variableCount) {
        this.stringValues = new String[variableCount];
        this.doubleValues = new double[variableCount];
        this.trailingSpaces = new int[variableCount];
    }

    void set(int index, String value) {
        this.stringValues[index] = value;
    }

    void set(int index, double value) {
        this.doubleValues[index] = value;
    }

    void setTrailingSpaces(int index, int trailing) {
        this.trailingSpaces[index] = trailing;
    }

    void setMissing(int index) {
        this.doubleValues[index] = Double.NaN;
        this.stringValues[index] = null;
    }

    public String getStringValue(int variableIndex) {
        return this.stringValues[variableIndex];
    }

    private void appendStringSegmentValue(int variableIndex, StringBuilder sb) {
        String str = this.getStringValue(variableIndex);
        if (str != null) {
            sb.append(this.getStringValue(variableIndex));
            for (int i = 0; i < this.trailingSpaces[variableIndex]; ++i) {
                sb.append(' ');
            }
        }
    }

    public String getLongStringValue(int variableIndex, int segments) {
        StringBuilder sb = new StringBuilder();
        for (int currentIdx = variableIndex; 0 < segments-- && currentIdx < this.stringValues.length; ++currentIdx) {
            this.appendStringSegmentValue(currentIdx, sb);
        }
        return sb.toString().trim();
    }

    public Double getDoubleValue(int variableIndex) {
        return this.doubleValues[variableIndex];
    }

    public boolean isSystemMissing(int variableIndex) {
        return Double.isNaN(this.doubleValues[variableIndex]);
    }
}

