/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.CastedLiteralOperandTypeCheckers;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.NativelySupportsDistinct;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArraySqlAggregator
implements SqlAggregator {
    private static final String NAME = "ARRAY_AGG";
    private static final SqlAggFunction FUNCTION = new ArrayAggFunction();

    @Override
    public SqlAggFunction calciteFunction() {
        return FUNCTION;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        ColumnType elementType;
        String initialvalue;
        DruidExpression arg;
        List<RexNode> arguments = inputAccessor.getFields(aggregateCall.getArgList());
        Integer maxSizeBytes = null;
        if (arguments.size() > 1) {
            RexNode maxBytes = arguments.get(1);
            if (!maxBytes.isA(SqlKind.LITERAL)) {
                return null;
            }
            maxSizeBytes = ((Number)((Object)RexLiteral.value((RexNode)maxBytes))).intValue();
        }
        if ((arg = Expressions.toDruidExpression(plannerContext, inputAccessor.getInputRowSignature(), arguments.get(0))) == null) {
            return null;
        }
        ExprMacroTable macroTable = plannerContext.getPlannerToolbox().exprMacroTable();
        ColumnType druidType = Calcites.getValueTypeForRelDataTypeFull(aggregateCall.getType());
        if (druidType == null || !druidType.isArray()) {
            initialvalue = "[]";
            elementType = ColumnType.STRING;
        } else {
            initialvalue = ExpressionType.fromColumnTypeStrict((TypeSignature)druidType).asTypeString() + "[]";
            elementType = (ColumnType)druidType.getElementType();
        }
        String fieldName = arg.isDirectColumnAccess() ? arg.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, elementType);
        if (aggregateCall.isDistinct()) {
            return Aggregation.create((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, initialvalue, null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), StringUtils.format((String)"array_set_add(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_set_add_all(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, null, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable));
        }
        return Aggregation.create((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, initialvalue, null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), StringUtils.format((String)"array_append(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_concat(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, null, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable));
    }

    @NativelySupportsDistinct
    private static class ArrayAggFunction
    extends SqlAggFunction {
        private static final ArrayAggReturnTypeInference RETURN_TYPE_INFERENCE = new ArrayAggReturnTypeInference();

        ArrayAggFunction() {
            super(ArraySqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)RETURN_TYPE_INFERENCE, InferTypes.ANY_NULLABLE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)StringUtils.format((String)"'%s(expr, maxSizeBytes)'", (Object[])new Object[]{ArraySqlAggregator.NAME}), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC})})}), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.IGNORED);
        }
    }

    static class ArrayAggReturnTypeInference
    implements SqlReturnTypeInference {
        ArrayAggReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
            RelDataType type = sqlOperatorBinding.getOperandType(0);
            return sqlOperatorBinding.getTypeFactory().createArrayType(type, -1L);
        }
    }
}

