/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidRels;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidJoinQueryRel
extends DruidRel<DruidJoinQueryRel> {
    static final TableDataSource DUMMY_DATA_SOURCE = new TableDataSource("__join__"){

        public boolean isConcrete() {
            return false;
        }
    };
    private final Filter leftFilter;
    private final PartialDruidQuery partialQuery;
    private final Join joinRel;
    private final PlannerConfig plannerConfig;
    private RelNode left;
    private RelNode right;

    private DruidJoinQueryRel(RelOptCluster cluster, RelTraitSet traitSet, Join joinRel, Filter leftFilter, PartialDruidQuery partialQuery, PlannerContext plannerContext) {
        super(cluster, traitSet, plannerContext);
        this.joinRel = joinRel;
        this.left = joinRel.getLeft();
        this.right = joinRel.getRight();
        this.leftFilter = leftFilter;
        this.partialQuery = partialQuery;
        this.plannerConfig = plannerContext.getPlannerConfig();
    }

    public static DruidJoinQueryRel create(Join joinRel, Filter leftFilter, PlannerContext plannerContext) {
        return new DruidJoinQueryRel(joinRel.getCluster(), joinRel.getTraitSet(), joinRel, leftFilter, PartialDruidQuery.create((RelNode)joinRel), plannerContext);
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public DruidJoinQueryRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidJoinQueryRel(this.getCluster(), newQueryBuilder.getTraitSet(this.getConvention(), this.getPlannerContext()), this.joinRel, this.leftFilter, newQueryBuilder, this.getPlannerContext());
    }

    private SourceDescProducer.SourceDesc buildLeftSourceDesc() {
        DataSource leftDataSource;
        DruidRel leftDruidRel = (DruidRel)this.left;
        DruidQuery leftQuery = (DruidQuery)Preconditions.checkNotNull((Object)leftDruidRel.toDruidQuery(false), (Object)"leftQuery");
        RowSignature leftSignature = leftQuery.getOutputRowSignature();
        if (DruidJoinQueryRel.computeLeftRequiresSubquery(this.getPlannerContext(), leftDruidRel)) {
            leftDataSource = new QueryDataSource(leftQuery.getQuery());
            if (this.leftFilter != null) {
                throw new ISE("Filter on left table is supposed to be null if left child is a query source", new Object[0]);
            }
        } else {
            leftDataSource = leftQuery.getDataSource();
        }
        SourceDescProducer.SourceDesc leftDesc = new SourceDescProducer.SourceDesc(leftDataSource, leftSignature);
        return leftDesc;
    }

    private SourceDescProducer.SourceDesc buildRightSourceDesc() {
        DruidRel rightDruidRel = (DruidRel)this.right;
        DruidQuery rightQuery = (DruidQuery)Preconditions.checkNotNull((Object)rightDruidRel.toDruidQuery(false), (Object)"rightQuery");
        RowSignature rightSignature = rightQuery.getOutputRowSignature();
        Object rightDataSource = DruidJoinQueryRel.computeRightRequiresSubquery(this.getPlannerContext(), rightDruidRel) ? new QueryDataSource(rightQuery.getQuery()) : rightQuery.getDataSource();
        SourceDescProducer.SourceDesc rightDesc = new SourceDescProducer.SourceDesc((DataSource)rightDataSource, rightSignature);
        return rightDesc;
    }

    public static SourceDescProducer.SourceDesc buildJoinSourceDesc(SourceDescProducer.SourceDesc leftDesc, SourceDescProducer.SourceDesc rightDesc, PlannerContext plannerContext, Join joinRel, Filter leftFilter) {
        Pair<String, RowSignature> prefixSignaturePair = DruidJoinQueryRel.computeJoinRowSignature(leftDesc.rowSignature, rightDesc.rowSignature, DruidJoinQueryRel.findExistingJoinPrefixes(leftDesc.dataSource, rightDesc.dataSource));
        String prefix = (String)prefixSignaturePair.lhs;
        RowSignature signature = (RowSignature)prefixSignaturePair.rhs;
        VirtualColumnRegistry virtualColumnRegistry = VirtualColumnRegistry.create(signature, plannerContext.getExpressionParser(), plannerContext.getPlannerConfig().isForceExpressionVirtualColumns());
        plannerContext.setJoinExpressionVirtualColumnRegistry(virtualColumnRegistry);
        DruidExpression condition = Expressions.toDruidExpression(plannerContext, signature, joinRel.getCondition());
        plannerContext.setJoinExpressionVirtualColumnRegistry(null);
        if (condition == null) {
            throw new CannotBuildQueryException((RelNode)joinRel, joinRel.getCondition());
        }
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)leftDesc.dataSource, (DataSource)rightDesc.dataSource, (String)prefix, (JoinConditionAnalysis)JoinConditionAnalysis.forExpression((String)condition.getExpression(), (Expr)plannerContext.parseExpression(condition.getExpression()), (String)prefix), (JoinType)DruidJoinQueryRel.toDruidJoinType(joinRel.getJoinType()), (DimFilter)DruidJoinQueryRel.getDimFilter(plannerContext, leftDesc.rowSignature, leftFilter), (JoinableFactoryWrapper)plannerContext.getJoinableFactoryWrapper());
        SourceDescProducer.SourceDesc sourceDesc = new SourceDescProducer.SourceDesc((DataSource)joinDataSource, signature, virtualColumnRegistry);
        return sourceDesc;
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        SourceDescProducer.SourceDesc leftDesc = this.buildLeftSourceDesc();
        SourceDescProducer.SourceDesc rightDesc = this.buildRightSourceDesc();
        SourceDescProducer.SourceDesc sourceDesc = DruidJoinQueryRel.buildJoinSourceDesc(leftDesc, rightDesc, this.getPlannerContext(), this.joinRel, this.leftFilter);
        return this.partialQuery.build(sourceDesc.dataSource, sourceDesc.rowSignature, this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations, sourceDesc.virtualColumnRegistry);
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.partialQuery.build((DataSource)DUMMY_DATA_SOURCE, RowSignatures.fromRelDataType(this.joinRel.getRowType().getFieldNames(), this.joinRel.getRowType()), this.getPlannerContext(), this.getCluster().getRexBuilder(), false);
    }

    @Override
    public DruidJoinQueryRel asDruidConvention() {
        return new DruidJoinQueryRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.joinRel.copy(this.joinRel.getTraitSet(), this.joinRel.getInputs().stream().map(input -> RelOptRule.convert((RelNode)input, (RelTrait)DruidConvention.instance())).collect(Collectors.toList())), this.leftFilter, this.partialQuery, this.getPlannerContext());
    }

    public List<RelNode> getInputs() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this.joinRel.replaceInput(ordinalInParent, p);
        if (ordinalInParent == 0) {
            this.left = p;
        } else if (ordinalInParent == 1) {
            this.right = p;
        } else {
            throw new IndexOutOfBoundsException(StringUtils.format((String)"Invalid ordinalInParent[%s]", (Object[])new Object[]{ordinalInParent}));
        }
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidJoinQueryRel(this.getCluster(), traitSet, this.joinRel.copy(this.joinRel.getTraitSet(), inputs), this.leftFilter, this.getPartialDruidQuery(), this.getPlannerContext());
    }

    @Override
    public Set<String> getDataSourceNames() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.addAll(((DruidRel)this.left).getDataSourceNames());
        retVal.addAll(((DruidRel)this.right).getDataSourceNames());
        return retVal;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getPlannerContext().getJsonMapper().writeValueAsString(druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this.joinRel.explainTerms(pw).item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double joinCost = this.partialQuery.estimateCost();
        if (this.getPlannerContext().getJoinAlgorithm().requiresSubquery()) {
            joinCost *= 0.1;
        } else {
            if (DruidJoinQueryRel.computeLeftRequiresSubquery(this.getPlannerContext(), DruidJoinQueryRel.getSomeDruidChild(this.left))) {
                joinCost += 100000.0;
            } else if (this.joinRel.getJoinType() == JoinRelType.INNER && this.plannerConfig.isComputeInnerJoinCostAsFilter()) {
                joinCost *= 0.1;
            }
            if (DruidJoinQueryRel.computeRightRequiresSubquery(this.getPlannerContext(), DruidJoinQueryRel.getSomeDruidChild(this.right))) {
                joinCost += 100000.0;
            }
        }
        if (this.joinRel.getCondition().isA(SqlKind.LITERAL) && !this.joinRel.getCondition().isAlwaysFalse()) {
            joinCost += 1.0E8;
        }
        return planner.getCostFactory().makeCost(joinCost, 0.0, 0.0);
    }

    public static JoinType toDruidJoinType(JoinRelType calciteJoinType) {
        switch (calciteJoinType) {
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case FULL: {
                return JoinType.FULL;
            }
            case INNER: {
                return JoinType.INNER;
            }
        }
        throw InvalidSqlInput.exception((String)"Cannot handle joinType [%s]", (Object[])new Object[]{calciteJoinType});
    }

    public static boolean computeLeftRequiresSubquery(PlannerContext plannerContext, DruidRel<?> left) {
        if (plannerContext.getJoinAlgorithm().requiresSubquery()) {
            return true;
        }
        return !DruidRels.isScanOrMapping(left, true);
    }

    public static boolean computeRightRequiresSubquery(PlannerContext plannerContext, DruidRel<?> right) {
        if (plannerContext.getJoinAlgorithm().requiresSubquery()) {
            return true;
        }
        return !DruidRels.isScanOrMapping(right, false) || !DruidRels.druidTableIfLeafRel(right).filter(table -> table.getDataSource().isGlobal()).isPresent();
    }

    static Set<String> findExistingJoinPrefixes(DataSource ... dataSources) {
        ArrayList<DataSource> copy = new ArrayList<DataSource>(Arrays.asList(dataSources));
        HashSet<String> prefixes = new HashSet<String>();
        while (!copy.isEmpty()) {
            DataSource current = copy.remove(0);
            copy.addAll(current.getChildren());
            if (!(current instanceof JoinDataSource)) continue;
            JoinDataSource joiner = (JoinDataSource)current;
            prefixes.add(joiner.getRightPrefix());
        }
        return prefixes;
    }

    static Pair<String, RowSignature> computeJoinRowSignature(RowSignature leftSignature, RowSignature rightSignature, Set<String> prefixes) {
        String maybePrefix;
        RowSignature.Builder signatureBuilder = RowSignature.builder();
        for (String column : leftSignature.getColumnNames()) {
            signatureBuilder.add(column, (ColumnType)leftSignature.getColumnType(column).orElse(null));
        }
        StringBuilder base = new StringBuilder("j");
        do {
            maybePrefix = Calcites.findUnusedPrefixForDigits(base.toString(), leftSignature.getColumnNames()) + "0.";
            base.insert(0, "_");
        } while (prefixes.contains(maybePrefix));
        String rightPrefix = maybePrefix;
        for (String column : rightSignature.getColumnNames()) {
            signatureBuilder.add(rightPrefix + column, (ColumnType)rightSignature.getColumnType(column).orElse(null));
        }
        return Pair.of((Object)rightPrefix, (Object)signatureBuilder.build());
    }

    public static DruidRel<?> getSomeDruidChild(RelNode child) {
        if (child instanceof DruidRel) {
            return (DruidRel)child;
        }
        RelSubset subset = (RelSubset)child;
        return (DruidRel)((Object)Iterables.getFirst((Iterable)subset.getRels(), null));
    }

    @Nullable
    private static DimFilter getDimFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable Filter filter) {
        if (filter == null) {
            return null;
        }
        RexNode condition = filter.getCondition();
        DimFilter dimFilter = Expressions.toFilter(plannerContext, rowSignature, null, condition);
        if (dimFilter == null) {
            throw new CannotBuildQueryException((RelNode)filter, condition);
        }
        return dimFilter;
    }
}

