/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:   {    Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],    Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]  }  The resulting set of endpoints can be viewed as:   a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],  b: [ 10.10.1.1:309, 10.10.2.2:309 ]")
public class V1EndpointSubset {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<V1EndpointAddress> addresses = null;
    public static final String SERIALIZED_NAME_NOT_READY_ADDRESSES = "notReadyAddresses";
    @SerializedName(value="notReadyAddresses")
    private List<V1EndpointAddress> notReadyAddresses = null;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<CoreV1EndpointPort> ports = null;

    public V1EndpointSubset addresses(List<V1EndpointAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1EndpointSubset addAddressesItem(V1EndpointAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1EndpointAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.")
    public List<V1EndpointAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<V1EndpointAddress> addresses) {
        this.addresses = addresses;
    }

    public V1EndpointSubset notReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses = notReadyAddresses;
        return this;
    }

    public V1EndpointSubset addNotReadyAddressesItem(V1EndpointAddress notReadyAddressesItem) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddress>();
        }
        this.notReadyAddresses.add(notReadyAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.")
    public List<V1EndpointAddress> getNotReadyAddresses() {
        return this.notReadyAddresses;
    }

    public void setNotReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses = notReadyAddresses;
    }

    public V1EndpointSubset ports(List<CoreV1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1EndpointSubset addPortsItem(CoreV1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<CoreV1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port numbers available on the related IP addresses.")
    public List<CoreV1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<CoreV1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSubset v1EndpointSubset = (V1EndpointSubset)o;
        return Objects.equals(this.addresses, v1EndpointSubset.addresses) && Objects.equals(this.notReadyAddresses, v1EndpointSubset.notReadyAddresses) && Objects.equals(this.ports, v1EndpointSubset.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointSubset {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    notReadyAddresses: ").append(this.toIndentedString(this.notReadyAddresses)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

