/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UnsafeUtils;
import org.apache.druid.utils.JvmUtils;

public class ByteBufferUtils {
    private static final MethodHandle UNMAP;
    private static final RuntimeException UNMAP_NOT_SUPPORTED_EXCEPTION;
    private static final Comparator<ByteBuffer> COMPARATOR_UTF8;

    private static void clean(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Unmapping only works with direct buffers");
        }
        if (UNMAP == null) {
            throw new UnsupportedOperationException(UNMAP_NOT_SUPPORTED_EXCEPTION);
        }
        try {
            UNMAP.invokeExact(buffer);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to unmap the mapped buffer", throwable);
        }
    }

    private static MethodHandle lookupUnmapMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            if (JvmUtils.isIsJava9Compatible()) {
                return ByteBufferUtils.unmapJava9(lookup);
            }
            return ByteBufferUtils.unmapJava7Or8(lookup);
        }
        catch (ReflectiveOperationException | RuntimeException e1) {
            throw new UnsupportedOperationException("Unmapping is not supported on this platform, because internal Java APIs are not compatible with this Druid version", e1);
        }
    }

    private static MethodHandle unmapJava7Or8(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
        Method m = directBufferClass.getMethod("cleaner", new Class[0]);
        m.setAccessible(true);
        MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
        TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
        MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
        MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
        MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
        MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
        return unmapper;
    }

    private static MethodHandle unmapJava9(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        MethodHandle unmapper = lookup.findVirtual(UnsafeUtils.theUnsafeClass(), "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
        return unmapper.bindTo(UnsafeUtils.theUnsafe());
    }

    public static ResourceHolder<ByteBuffer> allocateDirect(int size) {
        class DirectByteBufferHolder
        implements ResourceHolder<ByteBuffer> {
            private final AtomicBoolean closed = new AtomicBoolean(false);
            private volatile ByteBuffer buf = ByteBuffer.allocateDirect(this.val$size);
            final /* synthetic */ int val$size;

            DirectByteBufferHolder(int n) {
                this.val$size = n;
            }

            @Override
            public ByteBuffer get() {
                ByteBuffer theBuf = this.buf;
                if (theBuf == null) {
                    throw new ISE("Closed", new Object[0]);
                }
                return theBuf;
            }

            @Override
            public void close() {
                if (!this.closed.compareAndSet(false, true)) {
                    throw new ISE("Already closed", new Object[0]);
                }
                ByteBuffer theBuf = this.buf;
                this.buf = null;
                ByteBufferUtils.free(theBuf);
            }
        }
        return new DirectByteBufferHolder(size);
    }

    public static void free(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            ByteBufferUtils.clean(buffer);
        }
    }

    public static void unmap(MappedByteBuffer buffer) {
        ByteBufferUtils.free(buffer);
    }

    public static int compareUtf8ByteBuffers(@Nullable ByteBuffer buf1, @Nullable ByteBuffer buf2) {
        if (buf1 == null) {
            return buf2 == null ? 0 : -1;
        }
        if (buf2 == null) {
            return 1;
        }
        return StringUtils.compareUtf8UsingJavaStringOrdering(buf1, buf1.position(), buf1.remaining(), buf2, buf2.position(), buf2.remaining());
    }

    public static Comparator<ByteBuffer> utf8Comparator() {
        return COMPARATOR_UTF8;
    }

    static {
        COMPARATOR_UTF8 = new Utf8ByteBufferComparator();
        MethodHandle unmap = null;
        RuntimeException exception = null;
        try {
            unmap = ByteBufferUtils.lookupUnmapMethodHandle();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (unmap != null) {
            UNMAP = unmap;
            UNMAP_NOT_SUPPORTED_EXCEPTION = null;
        } else {
            UNMAP = null;
            UNMAP_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }

    private static class Utf8ByteBufferComparator
    implements Comparator<ByteBuffer> {
        private Utf8ByteBufferComparator() {
        }

        @Override
        public int compare(@Nullable ByteBuffer o1, @Nullable ByteBuffer o2) {
            return ByteBufferUtils.compareUtf8ByteBuffers(o1, o2);
        }
    }
}

