/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;
import org.apache.druid.segment.column.Types;

class BinAndExpr
extends BinaryOpExprBase {
    BinAndExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinAndExpr(this.op, left, right);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval rightVal;
        ExprEval leftVal = this.left.eval(bindings);
        if (!ExpressionProcessing.useStrictBooleans()) {
            return leftVal.asBoolean() ? this.right.eval(bindings) : leftVal;
        }
        if (leftVal.value() != null && !leftVal.asBoolean()) {
            return ExprEval.ofLongBoolean(false);
        }
        if (NullHandling.sqlCompatible() || Types.is(leftVal.type(), ExprType.STRING)) {
            if (leftVal.value() == null) {
                ExprEval rightVal2 = this.right.eval(bindings);
                if (rightVal2.value() == null || rightVal2.asBoolean()) {
                    return ExprEval.ofLong(null);
                }
                return ExprEval.ofLongBoolean(false);
            }
            rightVal = this.right.eval(bindings);
            if (rightVal.value() == null) {
                return ExprEval.ofLong(null);
            }
        } else {
            rightVal = this.right.eval(bindings);
        }
        return ExprEval.ofLongBoolean(leftVal.asBoolean() && rightVal.asBoolean());
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return ExpressionProcessing.useStrictBooleans() && inspector.areSameTypes(this.left, this.right) && inspector.canVectorize(this.left, this.right);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.and(inspector, this.left, this.right);
    }

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        if (!ExpressionProcessing.useStrictBooleans()) {
            return super.getOutputType(inspector);
        }
        return ExpressionType.LONG;
    }
}

