/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.query.DimensionComparisonUtils;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.DimensionIdCodec;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.MemoryFootprint;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.ValueType;

@NotThreadSafe
class KeyMappingGroupByColumnSelectorStrategy<DimensionType>
implements GroupByColumnSelectorStrategy {
    final DimensionIdCodec<DimensionType> dimensionIdCodec;
    final ColumnType columnType;
    final NullableTypeStrategy<DimensionType> nullableTypeStrategy;
    final DimensionType defaultValue;

    KeyMappingGroupByColumnSelectorStrategy(DimensionIdCodec<DimensionType> dimensionIdCodec, ColumnType columnType, NullableTypeStrategy<DimensionType> nullableTypeStrategy, DimensionType defaultValue) {
        this.dimensionIdCodec = dimensionIdCodec;
        this.columnType = columnType;
        this.nullableTypeStrategy = nullableTypeStrategy;
        this.defaultValue = defaultValue;
    }

    @Override
    public int getGroupingKeySizeBytes() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            resultRow.set(selectorPlus.getResultRowPosition(), this.dimensionIdCodec.idToKey(id));
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), this.defaultValue);
        }
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        Object value = DimensionHandlerUtils.convertObjectToType(selector.getObject(), this.columnType);
        if (value == null) {
            valuess[columnIndex] = -1;
            return 0;
        }
        MemoryFootprint<Integer> idAndMemoryFootprint = this.dimensionIdCodec.lookupId(value);
        valuess[columnIndex] = idAndMemoryFootprint.value();
        return idAndMemoryFootprint.memoryIncrease();
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        int dictId = (Integer)rowObj;
        keyBuffer.putInt(keyBufferPosition, dictId);
        stack[dimensionIndex] = dictId == -1 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        Object value = DimensionHandlerUtils.convertObjectToType(selector.getObject(), this.columnType);
        if (value == null) {
            keyBuffer.putInt(keyBufferPosition, -1);
            return 0;
        }
        MemoryFootprint<Integer> idAndMemoryIncrease = this.dimensionIdCodec.lookupId(value);
        keyBuffer.putInt(keyBufferPosition, idAndMemoryIncrease.value());
        int memoryIncrease = idAndMemoryIncrease.memoryIncrease();
        return memoryIncrease;
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        boolean usesNaturalComparator;
        boolean bl = usesNaturalComparator = stringComparator == null || DimensionComparisonUtils.isNaturalComparator((ValueType)this.columnType.getType(), stringComparator);
        if (this.dimensionIdCodec.canCompareIds() && usesNaturalComparator) {
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Integer.compare(lhsBuffer.getInt(lhsPosition + keyBufferPosition), rhsBuffer.getInt(rhsPosition + keyBufferPosition));
        }
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            Object rhsObject;
            int lhsDictId = lhsBuffer.getInt(lhsPosition + keyBufferPosition);
            int rhsDictId = rhsBuffer.getInt(rhsPosition + keyBufferPosition);
            Object lhsObject = lhsDictId == -1 ? null : this.dimensionIdCodec.idToKey(lhsDictId);
            Object v0 = rhsObject = rhsDictId == -1 ? null : this.dimensionIdCodec.idToKey(rhsDictId);
            if (usesNaturalComparator) {
                return this.nullableTypeStrategy.compare(DimensionHandlerUtils.convertObjectToType(lhsObject, this.columnType), DimensionHandlerUtils.convertObjectToType(rhsObject, this.columnType));
            }
            return stringComparator.compare(String.valueOf(lhsObject), String.valueOf(rhsObject));
        };
    }

    @Override
    public void reset() {
        this.dimensionIdCodec.reset();
    }
}

