/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.rowsandcols.LazilyDecoratedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.RowsAndColumnsDecorator;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.filter.AndFilter;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class DefaultRowsAndColumnsDecorator
implements RowsAndColumnsDecorator {
    private RowsAndColumns base;
    private Interval interval;
    private Filter filter;
    private VirtualColumns virtualColumns;
    private OffsetLimit offsetLimit;
    private List<ColumnWithDirection> ordering;

    public DefaultRowsAndColumnsDecorator(RowsAndColumns base) {
        this(base, null, null, null, OffsetLimit.NONE, null);
    }

    public DefaultRowsAndColumnsDecorator(RowsAndColumns base, Interval interval, Filter filter, VirtualColumns virtualColumns, OffsetLimit limit, List<ColumnWithDirection> ordering) {
        this.base = base;
        this.interval = interval;
        this.filter = filter;
        this.virtualColumns = virtualColumns;
        this.offsetLimit = limit;
        this.ordering = ordering;
    }

    @Override
    public void limitTimeRange(Interval interval) {
        this.interval = this.interval == null ? interval : this.interval.overlap((ReadableInterval)interval);
    }

    @Override
    public void addFilter(Filter filter) {
        if (this.filter == null) {
            this.filter = filter;
        } else {
            LinkedHashSet<Filter> newFilters = new LinkedHashSet<Filter>();
            if (this.filter instanceof AndFilter) {
                newFilters.addAll(((AndFilter)this.filter).getFilters());
            } else {
                newFilters.add(this.filter);
            }
            newFilters.add(filter);
            this.filter = new AndFilter(newFilters);
        }
    }

    @Override
    public void addVirtualColumns(VirtualColumns virtualColumns) {
        if (this.virtualColumns == null) {
            this.virtualColumns = virtualColumns;
        } else {
            VirtualColumn[] existing = this.virtualColumns.getVirtualColumns();
            VirtualColumn[] incoming = virtualColumns.getVirtualColumns();
            ArrayList<VirtualColumn> cols = new ArrayList<VirtualColumn>(existing.length + incoming.length);
            cols.addAll(Arrays.asList(existing));
            cols.addAll(Arrays.asList(incoming));
            this.virtualColumns = VirtualColumns.create(cols);
        }
    }

    @Override
    public void setOffsetLimit(OffsetLimit offsetLimit) {
        this.offsetLimit = offsetLimit;
    }

    @Override
    public void setOrdering(List<ColumnWithDirection> ordering) {
        this.ordering = ordering;
    }

    @Override
    public RowsAndColumns restrictColumns(List<String> columns) {
        return new LazilyDecoratedRowsAndColumns(this.base, this.interval, this.filter, this.virtualColumns, this.offsetLimit, this.ordering, columns == null ? null : new LinkedHashSet<String>(columns));
    }

    @Override
    public RowsAndColumns toRowsAndColumns() {
        return this.restrictColumns(null);
    }
}

