/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedFieldDictionaryEncodedColumn;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CloseableUtils;

public abstract class CompressedNestedDataComplexColumn<TStringDictionary extends Indexed<ByteBuffer>>
extends NestedDataComplexColumn
implements NestedCommonFormatColumn {
    private static final ObjectStrategy<Object> STRATEGY = NestedDataComplexTypeSerde.INSTANCE.getObjectStrategy();
    public static final IntTypeStrategy INT_TYPE_STRATEGY = new IntTypeStrategy();
    private final ColumnConfig columnConfig;
    private final Closer closer;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final GenericIndexed<String> fields;
    private final FieldTypeInfo fieldInfo;
    private final Supplier<TStringDictionary> stringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    @Nullable
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final SmooshedFileMapper fileMapper;
    private final String rootFieldPath;
    private final ColumnType logicalType;
    private final String columnName;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ByteOrder byteOrder;
    private final ConcurrentHashMap<Integer, ColumnHolder> columns = new ConcurrentHashMap();
    private CompressedVariableSizedBlobColumn compressedRawColumn;

    public CompressedNestedDataComplexColumn(String columnName, ColumnType logicalType, ColumnConfig columnConfig, CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, GenericIndexed<String> fields, FieldTypeInfo fieldInfo, Supplier<TStringDictionary> stringDictionary, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, @Nullable Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, SmooshedFileMapper fileMapper, BitmapSerdeFactory bitmapSerdeFactory, ByteOrder byteOrder, String rootFieldPath) {
        this.columnName = columnName;
        this.logicalType = logicalType;
        this.nullValues = nullValues;
        this.fields = fields;
        this.fieldInfo = fieldInfo;
        this.stringDictionarySupplier = stringDictionary;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.fileMapper = fileMapper;
        this.closer = Closer.create();
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.byteOrder = byteOrder;
        this.rootFieldPath = rootFieldPath;
        this.columnConfig = columnConfig;
    }

    public abstract List<NestedPathPart> parsePath(String var1);

    public abstract String getField(List<NestedPathPart> var1);

    public abstract String getFieldFileName(String var1, String var2, int var3);

    @Override
    public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fieldMap = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldPath = (String)this.fields.get(i);
            FieldTypeInfo.TypeSet types = this.fieldInfo.getTypes(i);
            fieldMap.put(fieldPath, new FieldTypeInfo.MutableTypeSet(types.getByteValue()));
        }
        return fieldMap;
    }

    @Override
    public ColumnType getLogicalType() {
        return this.logicalType;
    }

    @Override
    public List<List<NestedPathPart>> getNestedFields() {
        ArrayList<List<NestedPathPart>> fieldParts = new ArrayList<List<NestedPathPart>>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            fieldParts.add(this.parsePath((String)this.fields.get(i)));
        }
        return fieldParts;
    }

    public TStringDictionary getUtf8BytesDictionary() {
        return (TStringDictionary)((Indexed)this.stringDictionarySupplier.get());
    }

    @Override
    public Indexed<String> getStringDictionary() {
        return new StringEncodingStrategies.Utf8ToStringIndexed((Indexed)this.stringDictionarySupplier.get());
    }

    @Override
    public Indexed<Long> getLongDictionary() {
        return (Indexed)this.longDictionarySupplier.get();
    }

    @Override
    public Indexed<Double> getDoubleDictionary() {
        return (Indexed)this.doubleDictionarySupplier.get();
    }

    @Override
    public Indexed<Object[]> getArrayDictionary() {
        if (this.arrayDictionarySupplier == null) {
            return Indexed.empty();
        }
        final Iterable arrays = () -> {
            final Indexed stringDictionary = (Indexed)this.stringDictionarySupplier.get();
            final FixedIndexed longDictionary = (FixedIndexed)this.longDictionarySupplier.get();
            final FixedIndexed doubleDictionary = (FixedIndexed)this.doubleDictionarySupplier.get();
            return new Iterator<Object[]>(){
                final Iterator delegate;
                {
                    this.delegate = ((FrontCodedIntArrayIndexed)CompressedNestedDataComplexColumn.this.arrayDictionarySupplier.get()).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public Object[] next() {
                    int[] next = (int[])this.delegate.next();
                    Object[] nextArray = new Object[next.length];
                    for (int i = 0; i < nextArray.length; ++i) {
                        nextArray[i] = this.lookupId(next[i]);
                    }
                    return nextArray;
                }

                private Object lookupId(int globalId) {
                    if (globalId == 0) {
                        return null;
                    }
                    int adjustLongId = stringDictionary.size();
                    int adjustDoubleId = stringDictionary.size() + longDictionary.size();
                    if (globalId < adjustLongId) {
                        return StringUtils.fromUtf8Nullable((ByteBuffer)stringDictionary.get(globalId));
                    }
                    if (globalId < adjustDoubleId) {
                        return longDictionary.get(globalId - adjustLongId);
                    }
                    if (globalId < adjustDoubleId + doubleDictionary.size()) {
                        return doubleDictionary.get(globalId - adjustDoubleId);
                    }
                    throw new IAE("Unknown globalId [%s]", globalId);
                }
            };
        };
        return new Indexed<Object[]>(){

            @Override
            public int size() {
                return ((FrontCodedIntArrayIndexed)CompressedNestedDataComplexColumn.this.arrayDictionarySupplier.get()).size();
            }

            @Override
            @Nullable
            public Object[] get(int index) {
                throw new UnsupportedOperationException("get not supported");
            }

            @Override
            public int indexOf(@Nullable Object[] value) {
                throw new UnsupportedOperationException("indexOf not supported");
            }

            @Override
            public Iterator<Object[]> iterator() {
                return arrays.iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    public ImmutableBitmap getNullValues() {
        return this.nullValues;
    }

    @Override
    @Nullable
    public Object getRowValue(int rowNum) {
        if (this.nullValues.get(rowNum)) {
            return null;
        }
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
        }
        ByteBuffer valueBuffer = this.compressedRawColumn.get(rowNum);
        return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        if (!this.logicalType.equals(ColumnType.NESTED_DATA) && this.fields.size() == 1 && this.rootFieldPath.equals(this.fields.get(0))) {
            return this.makeColumnValueSelector((List<NestedPathPart>)ImmutableList.of(), offset);
        }
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
        }
        return new ObjectColumnSelector(){

            @Override
            @Nullable
            public Object getObject() {
                if (CompressedNestedDataComplexColumn.this.nullValues.get(offset.getOffset())) {
                    return null;
                }
                ByteBuffer valueBuffer = CompressedNestedDataComplexColumn.this.compressedRawColumn.get(offset.getOffset());
                return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
            }

            @Override
            public Class classOfObject() {
                return CompressedNestedDataComplexColumn.this.getClazz();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", CompressedNestedDataComplexColumn.this);
            }
        };
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        if (!this.logicalType.equals(ColumnType.NESTED_DATA) && this.fields.size() == 1 && this.rootFieldPath.equals(this.fields.get(0))) {
            return this.makeVectorObjectSelector(Collections.emptyList(), offset);
        }
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
        }
        return new VectorObjectSelector(){
            final Object[] vector;
            private int id;
            {
                this.vector = new Object[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public Object[] getObjectVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    int startOffset = offset.getStartOffset();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = this.getForOffset(startOffset + i);
                    }
                } else {
                    int[] offsets = offset.getOffsets();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = this.getForOffset(offsets[i]);
                    }
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Nullable
            private Object getForOffset(int offset2) {
                if (CompressedNestedDataComplexColumn.this.nullValues.get(offset2)) {
                    return null;
                }
                ByteBuffer valueBuffer = CompressedNestedDataComplexColumn.this.compressedRawColumn.get(offset2);
                return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        };
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        if (!this.logicalType.equals(ColumnType.NESTED_DATA) && this.fields.size() == 1 && this.rootFieldPath.equals(this.fields.get(0))) {
            return this.makeVectorValueSelector(Collections.emptyList(), offset);
        }
        return super.makeVectorValueSelector(offset);
    }

    @Override
    public int getLength() {
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = this.closer.register(this.compressedRawColumnSupplier.get());
        }
        return this.compressedRawColumn.size();
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(this.closer);
    }

    @Override
    public DimensionSelector makeDimensionSelector(List<NestedPathPart> path, ReadableOffset readableOffset, ExtractionFn fn) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex >= 0) {
            DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(field, fieldIndex).getColumn();
            return col.makeDimensionSelector(readableOffset, fn);
        }
        if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement) {
            NestedPathPart lastPath = path.get(path.size() - 1);
            String arrayField = this.getField(path.subList(0, path.size() - 1));
            int arrayFieldIndex = this.fields.indexOf(arrayField);
            if (arrayFieldIndex >= 0) {
                final int elementNumber = ((NestedPathArrayElement)lastPath).getIndex();
                if (elementNumber < 0) {
                    throw new IAE("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
                }
                DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(arrayField, arrayFieldIndex).getColumn();
                final ColumnValueSelector<?> arraySelector = col.makeColumnValueSelector(readableOffset);
                return new BaseSingleValueDimensionSelector(){

                    @Override
                    @Nullable
                    protected String getValue() {
                        Object[] array;
                        Object o = arraySelector.getObject();
                        if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                            Object element = array[elementNumber];
                            if (element == null) {
                                return null;
                            }
                            return String.valueOf(element);
                        }
                        return null;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        arraySelector.inspectRuntimeShape(inspector);
                    }
                };
            }
        }
        return DimensionSelector.constant(null);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(List<NestedPathPart> path, ReadableOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex >= 0) {
            BaseColumn col = this.getColumnHolder(field, fieldIndex).getColumn();
            return col.makeColumnValueSelector(readableOffset);
        }
        if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement) {
            NestedPathPart lastPath = path.get(path.size() - 1);
            String arrayField = this.getField(path.subList(0, path.size() - 1));
            int arrayFieldIndex = this.fields.indexOf(arrayField);
            if (arrayFieldIndex >= 0) {
                final int elementNumber = ((NestedPathArrayElement)lastPath).getIndex();
                if (elementNumber < 0) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
                }
                DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(arrayField, arrayFieldIndex).getColumn();
                final ColumnValueSelector<?> arraySelector = col.makeColumnValueSelector(readableOffset);
                return new ColumnValueSelector<Object>(){

                    @Override
                    public boolean isNull() {
                        Object o = this.getObject();
                        return !(o instanceof Number);
                    }

                    @Override
                    public long getLong() {
                        Object o = this.getObject();
                        return o instanceof Number ? ((Number)o).longValue() : 0L;
                    }

                    @Override
                    public float getFloat() {
                        Object o = this.getObject();
                        return o instanceof Number ? ((Number)o).floatValue() : 0.0f;
                    }

                    @Override
                    public double getDouble() {
                        Object o = this.getObject();
                        return o instanceof Number ? ((Number)o).doubleValue() : 0.0;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        arraySelector.inspectRuntimeShape(inspector);
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        Object[] array;
                        Object o = arraySelector.getObject();
                        if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                            return array[elementNumber];
                        }
                        return null;
                    }

                    @Override
                    public Class<?> classOfObject() {
                        return Object.class;
                    }
                };
            }
        }
        return NilColumnValueSelector.instance();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(List<NestedPathPart> path, ReadableVectorOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex >= 0) {
            DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(field, fieldIndex).getColumn();
            return col.makeSingleValueDimensionVectorSelector(readableOffset);
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(List<NestedPathPart> path, final ReadableVectorOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex >= 0) {
            BaseColumn col = this.getColumnHolder(field, fieldIndex).getColumn();
            return col.makeVectorObjectSelector(readableOffset);
        }
        if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement) {
            NestedPathPart lastPath = path.get(path.size() - 1);
            String arrayField = this.getField(path.subList(0, path.size() - 1));
            int arrayFieldIndex = this.fields.indexOf(arrayField);
            if (arrayFieldIndex >= 0) {
                final int elementNumber = ((NestedPathArrayElement)lastPath).getIndex();
                if (elementNumber < 0) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
                }
                DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(arrayField, arrayFieldIndex).getColumn();
                final VectorObjectSelector arraySelector = col.makeVectorObjectSelector(readableOffset);
                return new VectorObjectSelector(){
                    private final Object[] elements;
                    private int id;
                    {
                        this.elements = new Object[arraySelector.getMaxVectorSize()];
                        this.id = -1;
                    }

                    @Override
                    public Object[] getObjectVector() {
                        if (readableOffset.getId() != this.id) {
                            Object[] delegate = arraySelector.getObjectVector();
                            for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                                Object maybeArray = delegate[i];
                                if (maybeArray instanceof Object[]) {
                                    Object[] anArray = (Object[])maybeArray;
                                    if (elementNumber < anArray.length) {
                                        Object element;
                                        this.elements[i] = element = anArray[elementNumber];
                                        continue;
                                    }
                                    this.elements[i] = null;
                                    continue;
                                }
                                this.elements[i] = null;
                            }
                            this.id = readableOffset.getId();
                        }
                        return this.elements;
                    }

                    @Override
                    public int getMaxVectorSize() {
                        return arraySelector.getMaxVectorSize();
                    }

                    @Override
                    public int getCurrentVectorSize() {
                        return arraySelector.getCurrentVectorSize();
                    }
                };
            }
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(List<NestedPathPart> path, final ReadableVectorOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex >= 0) {
            BaseColumn col = this.getColumnHolder(field, fieldIndex).getColumn();
            return col.makeVectorValueSelector(readableOffset);
        }
        if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement) {
            NestedPathPart lastPath = path.get(path.size() - 1);
            String arrayField = this.getField(path.subList(0, path.size() - 1));
            int arrayFieldIndex = this.fields.indexOf(arrayField);
            if (arrayFieldIndex >= 0) {
                final int elementNumber = ((NestedPathArrayElement)lastPath).getIndex();
                if (elementNumber < 0) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot make array element selector for path [%s], negative array index not supported for this selector", path);
                }
                DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(arrayField, arrayFieldIndex).getColumn();
                final VectorObjectSelector arraySelector = col.makeVectorObjectSelector(readableOffset);
                return new VectorValueSelector(){
                    private final long[] longs;
                    private final double[] doubles;
                    private final float[] floats;
                    private final boolean[] nulls;
                    private int id;
                    {
                        this.longs = new long[readableOffset.getMaxVectorSize()];
                        this.doubles = new double[readableOffset.getMaxVectorSize()];
                        this.floats = new float[readableOffset.getMaxVectorSize()];
                        this.nulls = new boolean[readableOffset.getMaxVectorSize()];
                        this.id = -1;
                    }

                    private void computeNumbers() {
                        if (readableOffset.getId() != this.id) {
                            Object[] maybeArrays = arraySelector.getObjectVector();
                            for (int i = 0; i < arraySelector.getCurrentVectorSize(); ++i) {
                                Object maybeArray = maybeArrays[i];
                                if (maybeArray instanceof Object[]) {
                                    Object[] anArray = (Object[])maybeArray;
                                    if (elementNumber < anArray.length) {
                                        Double d;
                                        if (anArray[elementNumber] instanceof Number) {
                                            Number n = (Number)anArray[elementNumber];
                                            this.longs[i] = n.longValue();
                                            this.doubles[i] = n.doubleValue();
                                            this.floats[i] = n.floatValue();
                                            this.nulls[i] = false;
                                            continue;
                                        }
                                        Double d2 = d = anArray[elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[elementNumber])) : null;
                                        if (d != null) {
                                            this.longs[i] = d.longValue();
                                            this.doubles[i] = d;
                                            this.floats[i] = d.floatValue();
                                            this.nulls[i] = false;
                                            continue;
                                        }
                                        this.nullElement(i);
                                        continue;
                                    }
                                    this.nullElement(i);
                                    continue;
                                }
                                this.nullElement(i);
                            }
                            this.id = readableOffset.getId();
                        }
                    }

                    private void nullElement(int i) {
                        this.longs[i] = 0L;
                        this.doubles[i] = 0.0;
                        this.floats[i] = 0.0f;
                        this.nulls[i] = true;
                    }

                    @Override
                    public long[] getLongVector() {
                        if (readableOffset.getId() != this.id) {
                            this.computeNumbers();
                        }
                        return this.longs;
                    }

                    @Override
                    public float[] getFloatVector() {
                        if (readableOffset.getId() != this.id) {
                            this.computeNumbers();
                        }
                        return this.floats;
                    }

                    @Override
                    public double[] getDoubleVector() {
                        if (readableOffset.getId() != this.id) {
                            this.computeNumbers();
                        }
                        return this.doubles;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        if (readableOffset.getId() != this.id) {
                            this.computeNumbers();
                        }
                        return this.nulls;
                    }

                    @Override
                    public int getMaxVectorSize() {
                        return arraySelector.getMaxVectorSize();
                    }

                    @Override
                    public int getCurrentVectorSize() {
                        return arraySelector.getCurrentVectorSize();
                    }
                };
            }
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    @Nullable
    public Set<ColumnType> getColumnTypes(List<NestedPathPart> path) {
        String field = this.getField(path);
        int index = this.fields.indexOf(field);
        if (index < 0) {
            if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement) {
                String arrayField = this.getField(path.subList(0, path.size() - 1));
                index = this.fields.indexOf(arrayField);
            }
            if (index < 0) {
                return null;
            }
            Set<ColumnType> arrayTypes = FieldTypeInfo.convertToSet(this.fieldInfo.getTypes(index).getByteValue());
            HashSet elementTypes = Sets.newHashSetWithExpectedSize((int)arrayTypes.size());
            for (ColumnType type : arrayTypes) {
                if (type.isArray()) {
                    elementTypes.add((ColumnType)type.getElementType());
                    continue;
                }
                elementTypes.add(type);
            }
            return elementTypes;
        }
        return FieldTypeInfo.convertToSet(this.fieldInfo.getTypes(index).getByteValue());
    }

    @Override
    @Nullable
    public ColumnHolder getColumnHolder(List<NestedPathPart> path) {
        String field = this.getField(path);
        int fieldIndex = this.fields.indexOf(field);
        return this.getColumnHolder(field, fieldIndex);
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getColumnIndexSupplier(List<NestedPathPart> path) {
        String arrayField;
        int arrayFieldIndex;
        String field = this.getField(path);
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex >= 0) {
            return this.getColumnHolder(field, fieldIndex).getIndexSupplier();
        }
        if (!path.isEmpty() && path.get(path.size() - 1) instanceof NestedPathArrayElement && (arrayFieldIndex = this.fields.indexOf(arrayField = this.getField(path.subList(0, path.size() - 1)))) >= 0) {
            return NoIndexesColumnIndexSupplier.getInstance();
        }
        return null;
    }

    @Override
    public boolean isNumeric(List<NestedPathPart> path) {
        String field = this.getField(path);
        int fieldIndex = this.fields.indexOf(field);
        if (fieldIndex < 0) {
            return true;
        }
        return this.getColumnHolder(field, fieldIndex).getCapabilities().isNumeric();
    }

    private ColumnHolder getColumnHolder(String field, int fieldIndex) {
        return this.columns.computeIfAbsent(fieldIndex, f -> this.readNestedFieldColumn(field, fieldIndex));
    }

    @Nullable
    private ColumnHolder readNestedFieldColumn(String field, int fieldIndex) {
        try {
            GenericIndexed<ImmutableBitmap> arrayElementBitmaps;
            Supplier<FixedIndexed<Integer>> arrayElementDictionarySupplier;
            if (fieldIndex < 0) {
                return null;
            }
            FieldTypeInfo.TypeSet types = this.fieldInfo.getTypes(fieldIndex);
            String fieldFileName = this.getFieldFileName(this.columnName, field, fieldIndex);
            ByteBuffer dataBuffer = this.fileMapper.mapFile(fieldFileName);
            if (dataBuffer == null) {
                throw new ISE("Can't find field [%s] with name [%s] in [%s] file.", field, fieldFileName, this.columnName);
            }
            ColumnBuilder columnBuilder = new ColumnBuilder().setFileMapper(this.fileMapper);
            DictionaryEncodedColumnPartSerde.VERSION version = DictionaryEncodedColumnPartSerde.VERSION.fromByte(dataBuffer.get());
            int flags = dataBuffer.getInt();
            if (flags != 0) {
                throw DruidException.defensive("Unrecognized bits set in space reserved for future flags for field column [%s]", field);
            }
            Supplier<FixedIndexed<Integer>> localDictionarySupplier = FixedIndexed.read(dataBuffer, INT_TYPE_STRATEGY, this.byteOrder, 4);
            ByteBuffer bb = dataBuffer.asReadOnlyBuffer().order(this.byteOrder);
            int longsLength = bb.getInt();
            int doublesLength = bb.getInt();
            dataBuffer.position(dataBuffer.position() + 4 + 4);
            int pos = dataBuffer.position();
            Supplier longs = longsLength > 0 ? CompressedColumnarLongsSupplier.fromByteBuffer(dataBuffer, this.byteOrder) : () -> null;
            dataBuffer.position(pos + longsLength);
            pos = dataBuffer.position();
            Supplier<ColumnarDoubles> doubles = doublesLength > 0 ? CompressedColumnarDoublesSuppliers.fromByteBuffer(dataBuffer, this.byteOrder) : () -> null;
            dataBuffer.position(pos + doublesLength);
            WritableSupplier<ColumnarInts> ints = version == DictionaryEncodedColumnPartSerde.VERSION.COMPRESSED ? CompressedVSizeColumnarIntsSupplier.fromByteBuffer(dataBuffer, this.byteOrder) : VSizeColumnarInts.readFromByteBuffer(dataBuffer);
            ColumnType theType = types.getSingleType();
            columnBuilder.setType(theType == null ? ColumnType.STRING : theType);
            GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(dataBuffer, this.bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
            if (dataBuffer.hasRemaining()) {
                arrayElementDictionarySupplier = FixedIndexed.read(dataBuffer, INT_TYPE_STRATEGY, this.byteOrder, 4);
                arrayElementBitmaps = GenericIndexed.read(dataBuffer, this.bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
            } else {
                arrayElementDictionarySupplier = null;
                arrayElementBitmaps = null;
            }
            boolean hasNull = (Integer)((FixedIndexed)localDictionarySupplier.get()).get(0) == 0;
            Supplier columnSupplier = () -> {
                FixedIndexed localDict = (FixedIndexed)localDictionarySupplier.get();
                return this.closer.register(new NestedFieldDictionaryEncodedColumn<Indexed>(types, (ColumnarLongs)longs.get(), (ColumnarDoubles)doubles.get(), (ColumnarInts)ints.get(), (Indexed)this.stringDictionarySupplier.get(), (FixedIndexed)this.longDictionarySupplier.get(), (FixedIndexed)this.doubleDictionarySupplier.get(), this.arrayDictionarySupplier != null ? (FrontCodedIntArrayIndexed)this.arrayDictionarySupplier.get() : null, localDict, hasNull ? (ImmutableBitmap)rBitmaps.get(0) : this.bitmapSerdeFactory.getBitmapFactory().makeEmptyImmutableBitmap()));
            };
            columnBuilder.setHasMultipleValues(false).setHasNulls(hasNull).setDictionaryEncodedColumnSupplier(columnSupplier);
            columnBuilder.setIndexSupplier(new NestedFieldColumnIndexSupplier<TStringDictionary>(types, this.bitmapSerdeFactory.getBitmapFactory(), this.columnConfig, rBitmaps, localDictionarySupplier, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, arrayElementDictionarySupplier, arrayElementBitmaps), true, false);
            return columnBuilder.build();
        }
        catch (IOException ex) {
            throw new RE(ex, "Failed to read data for [%s]", field);
        }
    }

    private static final class IntTypeStrategy
    implements TypeStrategy<Integer> {
        private IntTypeStrategy() {
        }

        @Override
        public int estimateSizeBytes(Integer value) {
            return 4;
        }

        @Override
        public Integer read(ByteBuffer buffer) {
            return buffer.getInt();
        }

        @Override
        public Integer read(ByteBuffer buffer, int offset) {
            return buffer.getInt(offset);
        }

        @Override
        public boolean readRetainsBufferReference() {
            return false;
        }

        @Override
        public int write(ByteBuffer buffer, Integer value, int maxSizeBytes) {
            TypeStrategies.checkMaxSize(buffer.remaining(), maxSizeBytes, ColumnType.LONG);
            int sizeBytes = 4;
            int remaining = maxSizeBytes - 4;
            if (remaining >= 0) {
                buffer.putInt(value);
                return 4;
            }
            return remaining;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return Integer.compare(((Number)o1).intValue(), ((Number)o2).intValue());
        }
    }
}

