/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentialUpdate;
import org.apache.druid.security.basic.authentication.validator.PasswordHashGenerator;

public class BasicAuthenticatorCredentials {
    private final byte[] salt;
    private final byte[] hash;
    private final int iterations;

    @JsonCreator
    public BasicAuthenticatorCredentials(@JsonProperty(value="salt") byte[] salt, @JsonProperty(value="hash") byte[] hash, @JsonProperty(value="iterations") int iterations) {
        Preconditions.checkNotNull((Object)salt);
        Preconditions.checkNotNull((Object)hash);
        this.salt = salt;
        this.hash = hash;
        this.iterations = iterations;
    }

    public BasicAuthenticatorCredentials(BasicAuthenticatorCredentialUpdate update) {
        this.iterations = update.getIterations();
        this.salt = BasicAuthUtils.generateSalt();
        this.hash = PasswordHashGenerator.computePasswordHash(update.getPassword().toCharArray(), this.salt, this.iterations);
    }

    @JsonProperty
    public byte[] getSalt() {
        return this.salt;
    }

    @JsonProperty
    public byte[] getHash() {
        return this.hash;
    }

    @JsonProperty
    public int getIterations() {
        return this.iterations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        BasicAuthenticatorCredentials that = (BasicAuthenticatorCredentials)o;
        if (this.getIterations() != that.getIterations()) {
            return false;
        }
        return Arrays.equals(this.getSalt(), that.getSalt()) && Arrays.equals(this.getHash(), that.getHash());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getSalt());
        result = 31 * result + Arrays.hashCode(this.getHash());
        result = 31 * result + this.getIterations();
        return result;
    }
}

