/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.Query;
import org.apache.druid.server.QueryStats;
import org.joda.time.DateTime;

public class RequestLogLine {
    private static final Joiner JOINER = Joiner.on((String)"\t");
    private final Query<?> query;
    private final String sql;
    private final Map<String, Object> sqlQueryContext;
    private final DateTime timestamp;
    private final String remoteAddr;
    private final QueryStats queryStats;

    private RequestLogLine(@Nullable Query<?> query, @Nullable String sql, @Nullable Map<String, Object> sqlQueryContext, DateTime timestamp, @Nullable String remoteAddr, QueryStats queryStats) {
        this.query = query;
        this.sql = sql;
        this.sqlQueryContext = sqlQueryContext != null ? sqlQueryContext : ImmutableMap.of();
        this.timestamp = (DateTime)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.remoteAddr = StringUtils.nullToEmptyNonDruidDataString((String)remoteAddr);
        this.queryStats = (QueryStats)Preconditions.checkNotNull((Object)queryStats, (Object)"queryStats");
    }

    public static RequestLogLine forNative(Query<?> query, DateTime timestamp, String remoteAddr, QueryStats queryStats) {
        return new RequestLogLine(query, null, null, timestamp, remoteAddr, queryStats);
    }

    public static RequestLogLine forSql(String sql, Map<String, Object> sqlQueryContext, DateTime timestamp, String remoteAddr, QueryStats queryStats) {
        return new RequestLogLine(null, sql, sqlQueryContext, timestamp, remoteAddr, queryStats);
    }

    public String getNativeQueryLine(ObjectMapper objectMapper) throws JsonProcessingException {
        return JOINER.join(Arrays.asList(this.timestamp, this.remoteAddr, objectMapper.writeValueAsString(this.query), objectMapper.writeValueAsString((Object)this.queryStats)));
    }

    public String getSqlQueryLine(ObjectMapper objectMapper) throws JsonProcessingException {
        return JOINER.join(Arrays.asList(this.timestamp, this.remoteAddr, "", objectMapper.writeValueAsString((Object)this.queryStats), objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"query", (Object)(this.sql == null ? "<unavailable>" : this.sql), (Object)"context", this.sqlQueryContext))));
    }

    @Nullable
    @JsonProperty(value="query")
    public Query<?> getQuery() {
        return this.query;
    }

    @Nullable
    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @Nullable
    @JsonProperty
    public Map<String, Object> getSqlQueryContext() {
        return this.sqlQueryContext;
    }

    @JsonProperty(value="timestamp")
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    @JsonProperty(value="remoteAddr")
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @JsonProperty(value="queryStats")
    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestLogLine)) {
            return false;
        }
        RequestLogLine that = (RequestLogLine)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.sql, that.sql) && Objects.equals(this.sqlQueryContext, that.sqlQueryContext) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.remoteAddr, that.remoteAddr) && Objects.equals(this.queryStats, that.queryStats);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.sql, this.sqlQueryContext, this.timestamp, this.remoteAddr, this.queryStats);
    }

    public String toString() {
        return "RequestLogLine{query=" + this.query + ", sql='" + this.sql + '\'' + ", sqlQueryContext=" + this.sqlQueryContext + ", timestamp=" + this.timestamp + ", remoteAddr='" + this.remoteAddr + '\'' + ", queryStats=" + this.queryStats + '}';
    }
}

