/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlets.QoSFilter;

public class JettyBindings {
    private JettyBindings() {
    }

    public static void addQosFilter(Binder binder, String path, int maxRequests) {
        JettyBindings.addQosFilter(binder, new String[]{path}, maxRequests);
    }

    public static void addQosFilter(Binder binder, String[] paths, int maxRequests) {
        if (maxRequests <= 0) {
            return;
        }
        Multibinder.newSetBinder((Binder)binder, QosFilterHolder.class).addBinding().toInstance((Object)new QosFilterHolder(paths, maxRequests));
    }

    public static void addHandler(Binder binder, Class<? extends Handler> handlerClass) {
        Multibinder.newSetBinder((Binder)binder, Handler.class).addBinding().to(handlerClass);
    }

    public static class QosFilterHolder
    implements ServletFilterHolder {
        private final String[] paths;
        private final int maxRequests;
        private final long timeoutMs;

        public QosFilterHolder(String[] paths, int maxRequests, long timeoutMs) {
            this.paths = paths;
            this.maxRequests = maxRequests;
            this.timeoutMs = timeoutMs;
        }

        public QosFilterHolder(String[] paths, int maxRequests) {
            this(paths, maxRequests, -1L);
        }

        @Override
        public Filter getFilter() {
            return new QoSFilter();
        }

        @Override
        public Class<? extends Filter> getFilterClass() {
            return QoSFilter.class;
        }

        @Override
        public Map<String, String> getInitParameters() {
            if (this.timeoutMs < 0L) {
                return ImmutableMap.of((Object)"maxRequests", (Object)String.valueOf(this.maxRequests));
            }
            if (this.timeoutMs > Integer.MAX_VALUE) {
                return ImmutableMap.of((Object)"maxRequests", (Object)String.valueOf(this.maxRequests), (Object)"suspendMs", (Object)String.valueOf(Integer.MAX_VALUE));
            }
            return ImmutableMap.of((Object)"maxRequests", (Object)String.valueOf(this.maxRequests), (Object)"suspendMs", (Object)String.valueOf(this.timeoutMs));
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public String[] getPaths() {
            return this.paths;
        }

        @Override
        public EnumSet<DispatcherType> getDispatcherType() {
            return null;
        }
    }
}

