/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.msq.dart.controller.DartControllerContextFactory;
import org.apache.druid.msq.dart.controller.DartControllerRegistry;
import org.apache.druid.msq.dart.controller.sql.DartQueryMaker;
import org.apache.druid.msq.dart.guice.DartControllerConfig;
import org.apache.druid.msq.sql.MSQTaskSqlEngine;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;
import org.apache.druid.sql.destination.IngestDestination;

public class DartSqlEngine
implements SqlEngine {
    private static final String NAME = "msq-dart";
    public static final String CTX_DART_QUERY_ID = "dartQueryId";
    public static final String CTX_FULL_REPORT = "fullReport";
    public static final boolean CTX_FULL_REPORT_DEFAULT = false;
    private final DartControllerContextFactory controllerContextFactory;
    private final DartControllerRegistry controllerRegistry;
    private final DartControllerConfig controllerConfig;
    private final ExecutorService controllerExecutor;

    public DartSqlEngine(DartControllerContextFactory controllerContextFactory, DartControllerRegistry controllerRegistry, DartControllerConfig controllerConfig, ExecutorService controllerExecutor) {
        this.controllerContextFactory = controllerContextFactory;
        this.controllerRegistry = controllerRegistry;
        this.controllerConfig = controllerConfig;
        this.controllerExecutor = controllerExecutor;
    }

    public String name() {
        return NAME;
    }

    public boolean featureAvailable(EngineFeature feature) {
        switch (feature) {
            case CAN_SELECT: 
            case SCAN_ORDER_BY_NON_TIME: 
            case SCAN_NEEDS_SIGNATURE: 
            case WINDOW_FUNCTIONS: 
            case WINDOW_LEAF_OPERATOR: 
            case UNNEST: {
                return true;
            }
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case ALLOW_BINDABLE_PLAN: 
            case ALLOW_BROADCAST_RIGHTY_JOIN: 
            case ALLOW_TOP_LEVEL_UNION_ALL: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: 
            case TIME_BOUNDARY_QUERY: 
            case GROUPING_SETS: 
            case GROUPBY_IMPLICITLY_SORTS: {
                return false;
            }
        }
        throw new IAE("Unrecognized feature: %s", new Object[]{feature});
    }

    public void validateContext(Map<String, Object> queryContext) {
        SqlEngines.validateNoSpecialContextKeys(queryContext, MSQTaskSqlEngine.SYSTEM_CONTEXT_PARAMETERS);
    }

    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        if (QueryContext.of(queryContext).getBoolean(CTX_FULL_REPORT, false)) {
            return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType((RelDataTypeFactory)typeFactory, (SqlTypeName)SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)CTX_FULL_REPORT));
        }
        return validatedRowType;
    }

    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        throw DruidException.defensive((String)"Cannot execute DML commands with engine[%s]", (Object[])new Object[]{this.name()});
    }

    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        return new DartQueryMaker((List<Map.Entry<Integer, String>>)relRoot.fields, this.controllerContextFactory, plannerContext, this.controllerRegistry, this.controllerConfig, this.controllerExecutor);
    }

    public QueryMaker buildQueryMakerForInsert(IngestDestination destination, RelRoot relRoot, PlannerContext plannerContext) {
        throw DruidException.defensive((String)"Cannot execute DML commands with engine[%s]", (Object[])new Object[]{this.name()});
    }
}

