/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.msq.exec.WorkerManagerClient;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.rpc.indexing.OverlordClient;

public class IndexerWorkerManagerClient
implements WorkerManagerClient {
    private final OverlordClient overlordClient;
    private final TaskLocationFetcher locationFetcher = new TaskLocationFetcher();

    public IndexerWorkerManagerClient(OverlordClient overlordClient) {
        this.overlordClient = overlordClient;
    }

    @Override
    public String run(String taskId, MSQWorkerTask task) {
        FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(taskId, (Object)task), (boolean)true);
        return taskId;
    }

    @Override
    public void cancel(String taskId) {
        FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.cancelTask(taskId), (boolean)true);
    }

    @Override
    public Map<String, TaskStatus> statuses(Set<String> taskIds) {
        return (Map)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskStatuses(taskIds), (boolean)true);
    }

    @Override
    public TaskLocation location(String workerId) {
        return this.locationFetcher.getLocation(workerId);
    }

    @Override
    public void close() {
    }

    private class TaskLocationFetcher {
        private TaskLocationFetcher() {
        }

        TaskLocation getLocation(String workerId) {
            TaskStatus taskStatus = (TaskStatus)((Map)FutureUtils.getUnchecked((ListenableFuture)IndexerWorkerManagerClient.this.overlordClient.taskStatuses((Set)ImmutableSet.of((Object)workerId)), (boolean)true)).get(workerId);
            if (taskStatus != null && !TaskLocation.unknown().equals((Object)taskStatus.getLocation())) {
                return taskStatus.getLocation();
            }
            TaskStatusResponse statusResponse = (TaskStatusResponse)FutureUtils.getUnchecked((ListenableFuture)IndexerWorkerManagerClient.this.overlordClient.taskStatus(workerId), (boolean)true);
            if (statusResponse == null || statusResponse.getStatus() == null) {
                return TaskLocation.unknown();
            }
            return statusResponse.getStatus().getLocation();
        }
    }
}

