/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;

public class ReadablePartition {
    private final int stageNumber;
    private final IntSortedSet workerNumbers;
    private final int partitionNumber;

    private ReadablePartition(int stageNumber, IntSortedSet workerNumbers, int partitionNumber) {
        this.stageNumber = stageNumber;
        this.workerNumbers = workerNumbers;
        this.partitionNumber = partitionNumber;
        if (workerNumbers.isEmpty()) {
            throw new IAE("Cannot have empty worker set", new Object[0]);
        }
    }

    public static ReadablePartition striped(int stageNumber, int numWorkers, int partitionNumber) {
        IntAVLTreeSet workerNumbers = new IntAVLTreeSet();
        for (int i = 0; i < numWorkers; ++i) {
            workerNumbers.add(i);
        }
        return new ReadablePartition(stageNumber, (IntSortedSet)workerNumbers, partitionNumber);
    }

    public static ReadablePartition striped(int stageNumber, IntSortedSet workerNumbers, int partitionNumber) {
        return new ReadablePartition(stageNumber, workerNumbers, partitionNumber);
    }

    public static ReadablePartition collected(int stageNumber, int workerNumber, int partitionNumber) {
        IntAVLTreeSet workerNumbers = new IntAVLTreeSet();
        workerNumbers.add(workerNumber);
        return new ReadablePartition(stageNumber, (IntSortedSet)workerNumbers, partitionNumber);
    }

    public int getStageNumber() {
        return this.stageNumber;
    }

    public IntSortedSet getWorkerNumbers() {
        return this.workerNumbers;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadablePartition that = (ReadablePartition)o;
        return this.stageNumber == that.stageNumber && this.partitionNumber == that.partitionNumber && Objects.equals(this.workerNumbers, that.workerNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.stageNumber, this.workerNumbers, this.partitionNumber);
    }

    public String toString() {
        return "ReadablePartition{stageNumber=" + this.stageNumber + ", workerNumbers=" + this.workerNumbers + ", partitionNumber=" + this.partitionNumber + '}';
    }
}

