/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.util.List;
import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.common.CustomJobParameterResolver;
import org.apache.fineract.cob.conditions.BatchManagerCondition;
import org.apache.fineract.cob.listener.COBExecutionListenerRunner;
import org.apache.fineract.cob.listener.JobExecutionContextCopyListener;
import org.apache.fineract.cob.loan.LoanCOBConstant;
import org.apache.fineract.cob.loan.LoanCOBPartitioner;
import org.apache.fineract.cob.loan.ResolveLoanCOBCustomJobParametersTasklet;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.cob.loan.StayedLockedLoansTasklet;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.springbatch.PropertyService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobScope;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.listener.ExecutionContextPromotionListener;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.integration.config.annotation.EnableBatchIntegration;
import org.springframework.batch.integration.partition.RemotePartitioningManagerStepBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableBatchIntegration
@Conditional(value={BatchManagerCondition.class})
public class LoanCOBManagerConfiguration {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RemotePartitioningManagerStepBuilderFactory stepBuilderFactory;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private DirectChannel outboundRequests;
    @Autowired
    private COBBusinessStepService cobBusinessStepService;
    @Autowired
    private JobOperator jobOperator;
    @Autowired
    private JobExplorer jobExplorer;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RetrieveLoanIdService retrieveLoanIdService;
    @Autowired
    private BusinessEventNotifierService businessEventNotifierService;
    @Autowired
    private CustomJobParameterResolver customJobParameterResolver;

    @Bean
    @StepScope
    public LoanCOBPartitioner partitioner() {
        return new LoanCOBPartitioner(this.propertyService, this.cobBusinessStepService, this.retrieveLoanIdService, this.jobOperator, this.jobExplorer, LoanCOBConstant.NUMBER_OF_DAYS_BEHIND);
    }

    @Bean
    public Step loanCOBStep() {
        return this.stepBuilderFactory.get("Loan COB partition - Step").partitioner("loanCOBWorkerStep", (Partitioner)this.partitioner()).pollInterval((long)this.propertyService.getPollInterval("LOAN_COB").intValue()).listener((StepExecutionListener)new JobExecutionContextCopyListener(List.of("BusinessDate", "IS_CATCH_UP"))).outputChannel((MessageChannel)this.outboundRequests).build();
    }

    @Bean
    public Step resolveCustomJobParametersStep() {
        return ((TaskletStepBuilder)new StepBuilder("Resolve custom job parameters - Step", this.jobRepository).tasklet((Tasklet)this.resolveCustomJobParametersTasklet(), this.transactionManager).listener((StepExecutionListener)this.customJobParametersPromotionListener())).build();
    }

    @Bean
    public Step stayedLockedStep() {
        return new StepBuilder("Stayed locked loan accounts - Step", this.jobRepository).tasklet((Tasklet)this.stayedLockedTasklet(), this.transactionManager).build();
    }

    @Bean
    @JobScope
    public ResolveLoanCOBCustomJobParametersTasklet resolveCustomJobParametersTasklet() {
        return new ResolveLoanCOBCustomJobParametersTasklet(this.customJobParameterResolver);
    }

    @Bean
    @JobScope
    public StayedLockedLoansTasklet stayedLockedTasklet() {
        return new StayedLockedLoansTasklet(this.businessEventNotifierService, this.retrieveLoanIdService);
    }

    @Bean(name={"loanCOBJob"})
    public Job loanCOBJob() {
        return ((SimpleJobBuilder)((JobBuilder)new JobBuilder(JobName.LOAN_COB.name(), this.jobRepository).listener((JobExecutionListener)new COBExecutionListenerRunner(this.applicationContext, JobName.LOAN_COB.name()))).start(this.resolveCustomJobParametersStep()).next(this.loanCOBStep()).next(this.stayedLockedStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    public ExecutionContextPromotionListener customJobParametersPromotionListener() {
        ExecutionContextPromotionListener listener = new ExecutionContextPromotionListener();
        listener.setKeys(new String[]{"BusinessDate", "IS_CATCH_UP"});
        return listener;
    }
}

