/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.service;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.codes.exception.CodeValueNotFoundException;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class CodeValueReadPlatformServiceImpl
implements CodeValueReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public CodeValueReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Cacheable(value={"code_values"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#code+'cv')")
    public List<CodeValueData> retrieveCodeValuesByCode(String code) {
        this.context.authenticatedUser();
        CodeValueDataMapper rm = new CodeValueDataMapper();
        String sql = "select " + rm.schema() + "where c.code_name like ? and cv.is_active = true order by position";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{code});
    }

    @Cacheable(value={"code_values"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#codeId+'cv')")
    public Collection<CodeValueData> retrieveAllCodeValues(Long codeId) {
        this.context.authenticatedUser();
        CodeValueDataMapper rm = new CodeValueDataMapper();
        String sql = "select " + rm.schema() + "where cv.code_id = ? order by position";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{codeId});
    }

    @Cacheable(value={"code_values"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#codeValueId+'cv_by_id')")
    public CodeValueData retrieveCodeValue(Long codeValueId) {
        try {
            this.context.authenticatedUser();
            CodeValueDataMapper rm = new CodeValueDataMapper();
            String sql = "select " + rm.schema() + " where cv.id = ? order by position";
            return (CodeValueData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{codeValueId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new CodeValueNotFoundException(codeValueId, e);
        }
    }
}

