/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.jms;

import jakarta.jms.ConnectionFactory;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.springbatch.OutputChannelInterceptor;
import org.apache.fineract.infrastructure.springbatch.messagehandler.conditions.jms.JmsManagerCondition;
import org.apache.fineract.infrastructure.springbatch.messagehandler.jms.JmsBrokerConfiguration;
import org.springframework.batch.integration.config.annotation.EnableBatchIntegration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.integration.jms.dsl.Jms;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

@Configuration
@EnableBatchIntegration
@Conditional(value={JmsManagerCondition.class})
@Import(value={JmsBrokerConfiguration.class})
public class JmsManagerConfig {
    @Autowired
    private DirectChannel outboundRequests;
    @Autowired
    private OutputChannelInterceptor outputInterceptor;
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public IntegrationFlow outboundFlow(ConnectionFactory connectionFactory) {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.outboundRequests).intercept(new ChannelInterceptor[]{this.outputInterceptor})).log(LoggingHandler.Level.DEBUG)).handle((MessageHandlerSpec)Jms.outboundAdapter((ConnectionFactory)connectionFactory).destination(this.fineractProperties.getRemoteJobMessageHandler().getJms().getRequestQueueName()))).get();
    }
}

