/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.data.ExtensionData;
import org.apache.fineract.interoperation.data.InteropRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionTypeData;
import org.apache.fineract.interoperation.data.MoneyData;
import org.apache.fineract.interoperation.domain.InteropTransactionRole;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;

public class InteropTransferRequestData
extends InteropRequestData {
    static final String[] PARAMS = new String[]{"transactionCode", "accountId", "amount", "transactionRole", "transactionType", "note", "expiration", "extensionList", "transferCode", "fspFee", "fspCommission", "locale", "dateFormat"};
    @NotNull
    private final String transferCode;
    private MoneyData fspFee;
    private MoneyData fspCommission;

    public InteropTransferRequestData(@NotNull String transactionCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionRole transactionRole, InteropTransactionTypeData transactionType, String note, LocalDateTime expiration, List<ExtensionData> extensionList, @NotNull String transferCode, MoneyData fspFee, MoneyData fspCommission) {
        super(transactionCode, null, accountId, amount, transactionRole, transactionType, note, null, expiration, extensionList);
        this.transferCode = transferCode;
        this.fspFee = fspFee;
        this.fspCommission = fspCommission;
    }

    public InteropTransferRequestData(@NotNull String transactionCode, @NotNull String transferCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionRole transactionRole) {
        this(transactionCode, accountId, amount, transactionRole, null, null, null, null, transferCode, null, null);
    }

    private InteropTransferRequestData(InteropRequestData other, @NotNull String transferCode, MoneyData fspFee, MoneyData fspCommission) {
        this(other.getTransactionCode(), other.getAccountId(), other.getAmount(), other.getTransactionRole(), other.getTransactionType(), other.getNote(), other.getExpiration(), other.getExtensionList(), transferCode, fspFee, fspCommission);
    }

    public String getTransferCode() {
        return this.transferCode;
    }

    public MoneyData getFspFee() {
        return this.fspFee;
    }

    public MoneyData getFspCommission() {
        return this.fspCommission;
    }

    public void normalizeAmounts(@NotNull MonetaryCurrency currency) {
        super.normalizeAmounts(currency);
        if (this.fspFee != null) {
            this.fspFee.normalizeAmount(currency);
        }
    }

    public static InteropTransferRequestData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, Arrays.asList(PARAMS));
        InteropRequestData interopRequestData = InteropRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)jsonHelper);
        String transferCode = jsonHelper.extractStringNamed("transferCode", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("transferCode").value((Object)transferCode).notBlank();
        JsonObject fspFeeElement = jsonHelper.extractJsonObjectNamed("fspFee", (JsonElement)element);
        dataValidator.merge(dataValidatorCopy);
        MoneyData fspFee = MoneyData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)fspFeeElement, (FromJsonHelper)jsonHelper);
        JsonObject fspCommissionElement = jsonHelper.extractJsonObjectNamed("fspCommission", (JsonElement)element);
        dataValidator.merge(dataValidatorCopy);
        MoneyData fspCommission = MoneyData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)fspCommissionElement, (FromJsonHelper)jsonHelper);
        String transactionRoleString = jsonHelper.extractStringNamed("transactionRole", (JsonElement)element);
        dataValidatorCopy = dataValidator.reset().parameter("transactionRole").value((Object)transactionRoleString).notNull();
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new InteropTransferRequestData(interopRequestData, transferCode, fspFee, fspCommission);
    }
}

