/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.AbstractFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.collateral.api.CollateralApiConstants;
import org.apache.fineract.portfolio.collateral.command.CollateralCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class CollateralCommandFromApiJsonDeserializer
extends AbstractFromApiJsonDeserializer<CollateralCommand> {
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CollateralCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public CollateralCommand commandFromApiJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        Set supportedParameters = CollateralApiConstants.CollateralJSONinputParams.getAllValues();
        supportedParameters.add("locale");
        supportedParameters.add("dateFormat");
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParameters);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        Long collateralTypeId = this.fromApiJsonHelper.extractLongNamed(CollateralApiConstants.CollateralJSONinputParams.COLLATERAL_TYPE_ID.getValue(), element);
        String description = this.fromApiJsonHelper.extractStringNamed(CollateralApiConstants.CollateralJSONinputParams.DESCRIPTION.getValue(), element);
        BigDecimal value = this.fromApiJsonHelper.extractBigDecimalNamed(CollateralApiConstants.CollateralJSONinputParams.VALUE.getValue(), element, locale);
        return new CollateralCommand(collateralTypeId, value, description);
    }
}

