/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.portfolio.collectionsheet.command.CollectionSheetBulkDisbursalCommand;
import org.apache.fineract.portfolio.collectionsheet.command.CollectionSheetBulkRepaymentCommand;
import org.apache.fineract.portfolio.collectionsheet.data.CollectionSheetTransactionDataValidator;
import org.apache.fineract.portfolio.collectionsheet.serialization.CollectionSheetBulkDisbursalCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.collectionsheet.serialization.CollectionSheetBulkRepaymentCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.apache.fineract.portfolio.meeting.service.MeetingWritePlatformService;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetailAssembler;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionDTO;
import org.apache.fineract.portfolio.savings.domain.DepositAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.service.DepositAccountWritePlatformService;

public class CollectionSheetWritePlatformServiceJpaRepositoryImpl
implements CollectionSheetWritePlatformService {
    private final LoanWritePlatformService loanWritePlatformService;
    private final CollectionSheetBulkRepaymentCommandFromApiJsonDeserializer bulkRepaymentCommandFromApiJsonDeserializer;
    private final CollectionSheetBulkDisbursalCommandFromApiJsonDeserializer bulkDisbursalCommandFromApiJsonDeserializer;
    private final CollectionSheetTransactionDataValidator transactionDataValidator;
    private final MeetingWritePlatformService meetingWritePlatformService;
    private final DepositAccountAssembler accountAssembler;
    private final DepositAccountWritePlatformService accountWritePlatformService;
    private final PaymentDetailAssembler paymentDetailAssembler;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;

    public CommandProcessingResult updateCollectionSheet(JsonCommand command) {
        this.transactionDataValidator.validateTransaction(command);
        HashMap<String, String> changes = new HashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
        }
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        changes.putAll(this.updateBulkRepayments(command, paymentDetail));
        changes.putAll(this.updateBulkDisbursals(command));
        changes.putAll(this.updateBulkMandatorySavingsDuePayments(command, paymentDetail));
        this.meetingWritePlatformService.updateCollectionSheetAttendance(command);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(command.entityId()).withGroupId(command.entityId()).with(changes).with(changes).build();
    }

    public CommandProcessingResult saveIndividualCollectionSheet(JsonCommand command) {
        this.transactionDataValidator.validateIndividualCollectionSheet(command);
        HashMap<String, String> changes = new HashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
        }
        PaymentDetail paymentDetail = null;
        changes.putAll(this.updateBulkRepayments(command, paymentDetail));
        changes.putAll(this.updateBulkDisbursals(command));
        changes.putAll(this.updateBulkMandatorySavingsDuePayments(command, paymentDetail));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(command.entityId()).withGroupId(command.entityId()).with(changes).with(changes).build();
    }

    private Map<String, Object> updateBulkRepayments(JsonCommand command, PaymentDetail paymentDetail) {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        CollectionSheetBulkRepaymentCommand bulkRepaymentCommand = this.bulkRepaymentCommandFromApiJsonDeserializer.commandFromApiJson(command.json(), paymentDetail);
        changes.putAll(this.loanWritePlatformService.makeLoanBulkRepayment(bulkRepaymentCommand));
        return changes;
    }

    private Map<String, Object> updateBulkDisbursals(JsonCommand command) {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        CollectionSheetBulkDisbursalCommand bulkDisbursalCommand = this.bulkDisbursalCommandFromApiJsonDeserializer.commandFromApiJson(command.json());
        changes.putAll(this.loanWritePlatformService.bulkLoanDisbursal(command, bulkDisbursalCommand, Boolean.valueOf(false)));
        return changes;
    }

    private Map<String, Object> updateBulkMandatorySavingsDuePayments(JsonCommand command, PaymentDetail paymentDetail) {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        Collection savingsTransactions = this.accountAssembler.assembleBulkMandatorySavingsAccountTransactionDTOs(command, paymentDetail);
        ArrayList<Long> depositTransactionIds = new ArrayList<Long>();
        for (SavingsAccountTransactionDTO savingsAccountTransactionDTO : savingsTransactions) {
            try {
                SavingsAccountTransaction savingsAccountTransaction = this.accountWritePlatformService.mandatorySavingsAccountDeposit(savingsAccountTransactionDTO);
                depositTransactionIds.add((Long)savingsAccountTransaction.getId());
            }
            catch (Exception exception) {}
        }
        changes.put("SavingsTransactions", depositTransactionIds);
        return changes;
    }

    @Generated
    public CollectionSheetWritePlatformServiceJpaRepositoryImpl(LoanWritePlatformService loanWritePlatformService, CollectionSheetBulkRepaymentCommandFromApiJsonDeserializer bulkRepaymentCommandFromApiJsonDeserializer, CollectionSheetBulkDisbursalCommandFromApiJsonDeserializer bulkDisbursalCommandFromApiJsonDeserializer, CollectionSheetTransactionDataValidator transactionDataValidator, MeetingWritePlatformService meetingWritePlatformService, DepositAccountAssembler accountAssembler, DepositAccountWritePlatformService accountWritePlatformService, PaymentDetailAssembler paymentDetailAssembler, PaymentDetailWritePlatformService paymentDetailWritePlatformService) {
        this.loanWritePlatformService = loanWritePlatformService;
        this.bulkRepaymentCommandFromApiJsonDeserializer = bulkRepaymentCommandFromApiJsonDeserializer;
        this.bulkDisbursalCommandFromApiJsonDeserializer = bulkDisbursalCommandFromApiJsonDeserializer;
        this.transactionDataValidator = transactionDataValidator;
        this.meetingWritePlatformService = meetingWritePlatformService;
        this.accountAssembler = accountAssembler;
        this.accountWritePlatformService = accountWritePlatformService;
        this.paymentDetailAssembler = paymentDetailAssembler;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
    }
}

