/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.api.RecurringDepositAccountTransactionsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/recurringdepositaccounts/{recurringDepositAccountId}/transactions")
@Component
@Tag(name="Recurring Deposit Account Transactions", description="Transactions possible on a recurring deposit account.")
public class RecurringDepositAccountTransactionsApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<SavingsAccountTransactionData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private static final Set<String> FIXED_DEPOSIT_TRANSACTION_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "accountId", "accountNo", "currency", "amount", "date", "paymentDetailData", "runningBalance", "reversed"));

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Recurring Deposit Account Transaction Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\nExample Requests:\n\nrecurringdepositaccounts/1/transactions/template?command=deposit\n\nrecurringdepositaccounts/1/transactions/template?command=withdrawal")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountTransactionsApiResourceSwagger.GetRecurringDepositAccountsRecurringDepositAccountIdTransactionsTemplateResponse.class))})})
    public String retrieveTemplate(@PathParam(value="recurringDepositAccountId") @Parameter(description="recurringDepositAccountId") Long recurringDepositAccountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositaccount");
        if (!this.is(commandParam, "deposit") && !this.is(commandParam, "withdrawal")) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"deposit", "withdrawal"});
        }
        SavingsAccountTransactionData savingsAccount = this.depositAccountReadPlatformService.retrieveRecurringAccountDepositTransactionTemplate(recurringDepositAccountId);
        if (this.is(commandParam, "withdrawal")) {
            savingsAccount = SavingsAccountTransactionData.withWithDrawalTransactionDetails((SavingsAccountTransactionData)savingsAccount);
        }
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        savingsAccount = SavingsAccountTransactionData.templateOnTop((SavingsAccountTransactionData)savingsAccount, (Collection)paymentTypeOptions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)savingsAccount, SavingsApiSetConstants.SAVINGS_TRANSACTION_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Recurring Deposit Account Transaction", description="Retrieves Recurring Deposit Account Transaction\n\nExample Requests:\n\nrecurringdepositaccounts/1/transactions/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountTransactionsApiResourceSwagger.GetRecurringDepositAccountsRecurringDepositAccountIdTransactionsTransactionIdResponse.class))})})
    public String retrieveOne(@PathParam(value="recurringDepositAccountId") @Parameter(description="recurringDepositAccountId") Long recurringDepositAccountId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositaccount");
        SavingsAccountTransactionData transactionData = this.savingsAccountReadPlatformService.retrieveSavingsTransaction(recurringDepositAccountId, transactionId, DepositAccountType.RECURRING_DEPOSIT);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
            transactionData = SavingsAccountTransactionData.templateOnTop((SavingsAccountTransactionData)transactionData, (Collection)paymentTypeOptions);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)transactionData, FIXED_DEPOSIT_TRANSACTION_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Deposit Transaction | Withdrawal Transaction", description="Deposit Transaction:\n\nUsed for a deposit transaction\n\nWithdrawal Transaction:\n\nUsed for a Withdrawal Transaction\n\nShowing request/response for Deposit Transaction")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositAccountTransactionsApiResourceSwagger.PostRecurringDepositAccountsRecurringDepositAccountIdTransactionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountTransactionsApiResourceSwagger.PostRecurringDepositAccountsRecurringDepositAccountIdTransactionsResponse.class))})})
    public String transaction(@PathParam(value="recurringDepositAccountId") @Parameter(description="recurringDepositAccountId") Long recurringDepositAccountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "deposit")) {
            CommandWrapper commandRequest = builder.recurringAccountDeposit(recurringDepositAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "withdrawal")) {
            CommandWrapper commandRequest = builder.recurringAccountWithdrawal(recurringDepositAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"deposit", "withdrawal"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adjust Transaction | Undo transaction", description="Adjust Transaction:\n\nThis command modifies the given transaction.\n\nUndo transaction:\n\nThis command reverses the given transaction.\n\nShowing request/response for 'Adjust Transaction'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositAccountTransactionsApiResourceSwagger.PostRecurringDepositAccountsRecurringDepositAccountIdTransactionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountTransactionsApiResourceSwagger.PostRecurringDepositAccountsRecurringDepositAccountIdTransactionsTransactionIdResponse.class))})})
    public String handleTransactionCommands(@PathParam(value="recurringDepositAccountId") @Parameter(description="recurringDepositAccountId") Long recurringDepositAccountId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "undo")) {
            CommandWrapper commandRequest = builder.undoRecurringAccountTransaction(recurringDepositAccountId, transactionId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "modify")) {
            CommandWrapper commandRequest = builder.adjustRecurringAccountTransaction(recurringDepositAccountId, transactionId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"undo", "modify"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public RecurringDepositAccountTransactionsApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<SavingsAccountTransactionData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, SavingsAccountReadPlatformService savingsAccountReadPlatformService, DepositAccountReadPlatformService depositAccountReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
    }
}

