/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.portfolio.self.pockets.api.PocketApiResourceSwagger;
import org.apache.fineract.portfolio.self.pockets.service.PocketAccountMappingReadPlatformService;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/pockets")
@Component
@Tag(name="Pocket", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class PocketApiResource {
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final DefaultToApiJsonSerializer toApiJsonSerializer;
    private final PocketAccountMappingReadPlatformService pocketAccountMappingReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Link/delink accounts to/from pocket", description="Pockets behave as favourites. An user can link his/her Loan, Savings and Share accounts to pocket for faster access. In a similar way linked accounts can be delinked from the pocket.\n\nExample Requests:\n\nself/pockets?command=linkAccounts\n\nself/pockets?command=delinkAccounts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PocketApiResourceSwagger.PostLinkDelinkAccountsToFromPocketResponse.class))})})
    public String handleCommands(@QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "linkAccounts")) {
            CommandWrapper commandRequest = builder.linkAccountsToPocket().build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "delinkAccounts")) {
            CommandWrapper commandRequest = builder.delinkAccountsFromPocket().build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve accounts linked to pocket", description="All linked loan\n\nExample Requests:\n\n\nself/pockets")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PocketApiResourceSwagger.GetAccountsLinkedToPocketResponse.class))})})
    public String retrieveAll() {
        return this.toApiJsonSerializer.serialize((Object)this.pocketAccountMappingReadPlatformService.retrieveAll());
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @Generated
    public PocketApiResource(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, DefaultToApiJsonSerializer toApiJsonSerializer, PocketAccountMappingReadPlatformService pocketAccountMappingReadPlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.pocketAccountMappingReadPlatformService = pocketAccountMappingReadPlatformService;
    }
}

