/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.domain;

import org.apache.fineract.infrastructure.core.service.PlatformEmailService;
import org.apache.fineract.infrastructure.security.domain.PlatformUser;
import org.apache.fineract.infrastructure.security.service.PlatformPasswordEncoder;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.apache.fineract.useradministration.domain.UserDomainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaUserDomainService
implements UserDomainService {
    private final AppUserRepository userRepository;
    private final PlatformPasswordEncoder applicationPasswordEncoder;
    private final PlatformEmailService emailService;

    @Autowired
    public JpaUserDomainService(AppUserRepository userRepository, PlatformPasswordEncoder applicationPasswordEncoder, PlatformEmailService emailService) {
        this.userRepository = userRepository;
        this.applicationPasswordEncoder = applicationPasswordEncoder;
        this.emailService = emailService;
    }

    @Transactional
    public void create(AppUser appUser, Boolean sendPasswordToEmail) {
        this.generateKeyUsedForPasswordSalting(appUser);
        String unencodedPassword = appUser.getPassword();
        String encodePassword = this.applicationPasswordEncoder.encode((PlatformUser)appUser);
        appUser.updatePassword(encodePassword);
        this.userRepository.saveAndFlush((Object)appUser);
        if (sendPasswordToEmail.booleanValue()) {
            this.emailService.sendToUserAccount(appUser.getOffice().getName(), appUser.getFirstname(), appUser.getEmail(), appUser.getUsername(), unencodedPassword);
        }
    }

    private void generateKeyUsedForPasswordSalting(AppUser appUser) {
        this.userRepository.save((Object)appUser);
    }
}

