/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.services;

import java.util.Map;
import org.apache.fineract.client.models.InteropAccountData;
import org.apache.fineract.client.models.InteropIdentifierAccountResponseData;
import org.apache.fineract.client.models.InteropIdentifierRequestData;
import org.apache.fineract.client.models.InteropIdentifiersResponseData;
import org.apache.fineract.client.models.InteropKycResponseData;
import org.apache.fineract.client.models.InteropQuoteRequestData;
import org.apache.fineract.client.models.InteropQuoteResponseData;
import org.apache.fineract.client.models.InteropTransactionRequestData;
import org.apache.fineract.client.models.InteropTransactionRequestResponseData;
import org.apache.fineract.client.models.InteropTransactionsData;
import org.apache.fineract.client.models.InteropTransferRequestData;
import org.apache.fineract.client.models.InteropTransferResponseData;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface InterOperationApi {
    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/quotes")
    public Call<InteropQuoteResponseData> createQuote(@Body InteropQuoteRequestData var1);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/requests")
    public Call<InteropTransactionRequestResponseData> createTransactionRequest(@Body InteropTransactionRequestData var1);

    @Headers(value={"Content-Type:application/json"})
    @DELETE(value="v1/interoperation/parties/{idType}/{idValue}")
    public Call<InteropIdentifierAccountResponseData> deleteAccountIdentifier(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Body InteropIdentifierRequestData var3);

    @Headers(value={"Content-Type:application/json"})
    @DELETE(value="v1/interoperation/parties/{idType}/{idValue}/{subIdOrType}")
    public Call<InteropIdentifierAccountResponseData> deleteAccountIdentifier1(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Path(value="subIdOrType") String var3, @Body InteropIdentifierRequestData var4);

    @POST(value="v1/interoperation/transactions/{accountId}/disburse")
    public Call<String> disburseLoan(@Path(value="accountId") String var1);

    @GET(value="v1/interoperation/parties/{idType}/{idValue}")
    public Call<InteropIdentifierAccountResponseData> getAccountByIdentifier(@Path(value="idType") String var1, @Path(value="idValue") String var2);

    @GET(value="v1/interoperation/parties/{idType}/{idValue}/{subIdOrType}")
    public Call<InteropIdentifierAccountResponseData> getAccountByIdentifier1(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Path(value="subIdOrType") String var3);

    @GET(value="v1/interoperation/accounts/{accountId}")
    public Call<InteropAccountData> getAccountDetails(@Path(value="accountId") String var1);

    @GET(value="v1/interoperation/accounts/{accountId}/identifiers")
    public Call<InteropIdentifiersResponseData> getAccountIdentifiers(@Path(value="accountId") String var1);

    @GET(value="v1/interoperation/accounts/{accountId}/transactions")
    public Call<InteropTransactionsData> getAccountTransactions(@Path(value="accountId") String var1, @Query(value="debit") Boolean var2, @Query(value="credit") Boolean var3, @Query(value="fromBookingDateTime") String var4, @Query(value="toBookingDateTime") String var5);

    @GET(value="v1/interoperation/accounts/{accountId}/kyc")
    public Call<InteropKycResponseData> getClientKyc(@Path(value="accountId") String var1);

    @GET(value="v1/interoperation/transactions/{transactionCode}/quotes/{quoteCode}")
    public Call<InteropQuoteResponseData> getQuote(@Path(value="transactionCode") String var1, @Path(value="quoteCode") String var2);

    @GET(value="v1/interoperation/transactions/{transactionCode}/requests/{requestCode}")
    public Call<InteropTransactionRequestResponseData> getTransactionRequest(@Path(value="transactionCode") String var1, @Path(value="requestCode") String var2);

    @GET(value="v1/interoperation/transactions/{transactionCode}/transfers/{transferCode}")
    public Call<InteropTransferResponseData> getTransfer(@Path(value="transactionCode") String var1, @Path(value="transferCode") String var2);

    @GET(value="v1/interoperation/health")
    public Call<Void> health();

    @POST(value="v1/interoperation/transactions/{accountId}/loanrepayment")
    public Call<String> loanRepayment(@Path(value="accountId") String var1);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/transfers")
    public Call<InteropTransferResponseData> performTransfer(@Body InteropTransferRequestData var1, @Query(value="action") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/parties/{idType}/{idValue}")
    public Call<InteropIdentifierAccountResponseData> registerAccountIdentifier(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Body InteropIdentifierRequestData var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/parties/{idType}/{idValue}/{subIdOrType}")
    public Call<InteropIdentifierAccountResponseData> registerAccountIdentifier1(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Path(value="subIdOrType") String var3, @Body InteropIdentifierRequestData var4);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/quotes")
    public Call<InteropQuoteResponseData> createQuote(@Body InteropQuoteRequestData var1, @HeaderMap Map<String, String> var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/requests")
    public Call<InteropTransactionRequestResponseData> createTransactionRequest(@Body InteropTransactionRequestData var1, @HeaderMap Map<String, String> var2);

    @Headers(value={"Content-Type:application/json"})
    @DELETE(value="v1/interoperation/parties/{idType}/{idValue}")
    public Call<InteropIdentifierAccountResponseData> deleteAccountIdentifier(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Body InteropIdentifierRequestData var3, @HeaderMap Map<String, String> var4);

    @Headers(value={"Content-Type:application/json"})
    @DELETE(value="v1/interoperation/parties/{idType}/{idValue}/{subIdOrType}")
    public Call<InteropIdentifierAccountResponseData> deleteAccountIdentifier1(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Path(value="subIdOrType") String var3, @Body InteropIdentifierRequestData var4, @HeaderMap Map<String, String> var5);

    @POST(value="v1/interoperation/transactions/{accountId}/disburse")
    public Call<String> disburseLoan(@Path(value="accountId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/interoperation/parties/{idType}/{idValue}")
    public Call<InteropIdentifierAccountResponseData> getAccountByIdentifier(@Path(value="idType") String var1, @Path(value="idValue") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="v1/interoperation/parties/{idType}/{idValue}/{subIdOrType}")
    public Call<InteropIdentifierAccountResponseData> getAccountByIdentifier1(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Path(value="subIdOrType") String var3, @HeaderMap Map<String, String> var4);

    @GET(value="v1/interoperation/accounts/{accountId}")
    public Call<InteropAccountData> getAccountDetails(@Path(value="accountId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/interoperation/accounts/{accountId}/identifiers")
    public Call<InteropIdentifiersResponseData> getAccountIdentifiers(@Path(value="accountId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/interoperation/accounts/{accountId}/transactions")
    public Call<InteropTransactionsData> getAccountTransactions(@Path(value="accountId") String var1, @Query(value="debit") Boolean var2, @Query(value="credit") Boolean var3, @Query(value="fromBookingDateTime") String var4, @Query(value="toBookingDateTime") String var5, @HeaderMap Map<String, String> var6);

    @GET(value="v1/interoperation/accounts/{accountId}/kyc")
    public Call<InteropKycResponseData> getClientKyc(@Path(value="accountId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/interoperation/transactions/{transactionCode}/quotes/{quoteCode}")
    public Call<InteropQuoteResponseData> getQuote(@Path(value="transactionCode") String var1, @Path(value="quoteCode") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="v1/interoperation/transactions/{transactionCode}/requests/{requestCode}")
    public Call<InteropTransactionRequestResponseData> getTransactionRequest(@Path(value="transactionCode") String var1, @Path(value="requestCode") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="v1/interoperation/transactions/{transactionCode}/transfers/{transferCode}")
    public Call<InteropTransferResponseData> getTransfer(@Path(value="transactionCode") String var1, @Path(value="transferCode") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="v1/interoperation/health")
    public Call<Void> health(@HeaderMap Map<String, String> var1);

    @POST(value="v1/interoperation/transactions/{accountId}/loanrepayment")
    public Call<String> loanRepayment(@Path(value="accountId") String var1, @HeaderMap Map<String, String> var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/transfers")
    public Call<InteropTransferResponseData> performTransfer(@Body InteropTransferRequestData var1, @Query(value="action") String var2, @HeaderMap Map<String, String> var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/parties/{idType}/{idValue}")
    public Call<InteropIdentifierAccountResponseData> registerAccountIdentifier(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Body InteropIdentifierRequestData var3, @HeaderMap Map<String, String> var4);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/interoperation/parties/{idType}/{idValue}/{subIdOrType}")
    public Call<InteropIdentifierAccountResponseData> registerAccountIdentifier1(@Path(value="idType") String var1, @Path(value="idValue") String var2, @Path(value="subIdOrType") String var3, @Body InteropIdentifierRequestData var4, @HeaderMap Map<String, String> var5);
}

