package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.GetLoansLoanIdTransactionsResponse;
import org.apache.fineract.client.models.GetLoansLoanIdTransactionsTemplateResponse;
import org.apache.fineract.client.models.GetLoansLoanIdTransactionsTransactionIdResponse;
import org.apache.fineract.client.models.LoanScheduleData;
import org.apache.fineract.client.models.PostLoansLoanIdTransactionsRequest;
import org.apache.fineract.client.models.PostLoansLoanIdTransactionsResponse;
import org.apache.fineract.client.models.PostLoansLoanIdTransactionsTransactionIdRequest;
import org.apache.fineract.client.models.PutChargeTransactionChangesRequest;
import org.apache.fineract.client.models.PutChargeTransactionChangesResponse;
import org.apache.fineract.client.models.TransactionType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanTransactionsApi {
    /**
    * Adjust a Transaction
    * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
        * @param loanId loanId (required)
        * @param transactionId transactionId (required)
        * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/transactions/{transactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Adjust a Transaction
    * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
        * @param loanId loanId (required)
        * @param externalTransactionId externalTransactionId (required)
        * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/transactions/external-id/{externalTransactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Adjust a Transaction
    * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
        * @param loanExternalId loanExternalId (required)
        * @param transactionId transactionId (required)
        * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/transactions/{transactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Adjust a Transaction
    * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
        * @param loanExternalId loanExternalId (required)
        * @param externalTransactionId externalTransactionId (required)
        * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/transactions/external-id/{externalTransactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Significant Loan Transactions
    * This API covers the major loan transaction functionality  Example Requests:  loans/1/transactions?command&#x3D;repayment | Make a Repayment |  loans/1/transactions?command&#x3D;merchantIssuedRefund | Merchant Issued Refund |  loans/1/transactions?command&#x3D;payoutRefund | Payout Refund |  loans/1/transactions?command&#x3D;goodwillCredit | Goodwil Credit |  loans/1/transactions?command&#x3D;chargeRefund | Charge Refund |  loans/1/transactions?command&#x3D;waiveinterest | Waive Interest |  loans/1/transactions?command&#x3D;writeoff | Write-off Loan |  loans/1/transactions?command&#x3D;close-rescheduled | Close Rescheduled Loan |  loans/1/transactions?command&#x3D;close | Close Loan |  loans/1/transactions?command&#x3D;undowriteoff | Undo Loan Write-off |  loans/1/transactions?command&#x3D;recoverypayment | Make Recovery Payment |  loans/1/transactions?command&#x3D;refundByCash | Make a Refund of an Active Loan by Cash |  loans/1/transactions?command&#x3D;foreclosure | Foreclosure of an Active Loan |  loans/1/transactions?command&#x3D;creditBalanceRefund | Credit Balance Refund |   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;charge-off | Charge-off Loan |   loans/1/transactions?command&#x3D;downPayment | Down Payment |   
        * @param loanId loanId (required)
        * @param postLoansLoanIdTransactionsRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/transactions")
    Call<PostLoansLoanIdTransactionsResponse> executeLoanTransaction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansLoanIdTransactionsRequest postLoansLoanIdTransactionsRequest, @retrofit2.http.Query("command") String command);

    /**
    * Significant Loan Transactions
    * This API covers the major loan transaction functionality  Example Requests:  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;repayment | Make a Repayment |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;merchantIssuedRefund | Merchant Issued Refund |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;payoutRefund | Payout Refund |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;goodwillCredit | Goodwil Credit |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;chargeRefund | Charge Refund |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;waiveinterest | Waive Interest |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;writeoff | Write-off Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;close-rescheduled | Close Rescheduled Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;close | Close Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;undowriteoff | Undo Loan Write-off |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;recoverypayment | Make Recovery Payment |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;refundByCash | Make a Refund of an Active Loan by Cash |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;foreclosure | Foreclosure of an Active Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;creditBalanceRefund | Credit Balance Refund |   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;charge-off | Charge-off Loan |   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;downPayment | Down Payment |   
        * @param loanExternalId loanExternalId (required)
        * @param postLoansLoanIdTransactionsRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/transactions")
    Call<PostLoansLoanIdTransactionsResponse> executeLoanTransaction1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansLoanIdTransactionsRequest postLoansLoanIdTransactionsRequest, @retrofit2.http.Query("command") String command);

    /**
    * Preview Re-Age Schedule
    * Generates a preview of the re-aged loan schedule based on the provided parameters without creating any transactions or modifying the loan.
        * @param loanId loanId (required)
        * @param frequencyNumber The frequency number for the re-aging schedule (required)
        * @param frequencyType The frequency type (DAYS, WEEKS, MONTHS, YEARS) (required)
        * @param startDate The start date for the re-aging schedule (required)
        * @param numberOfInstallments The number of installments for the re-aged loan (required)
        * @param dateFormat The date format used for the startDate parameter (required)
        * @param locale The locale to use for formatting (required)
        * @param reAgeInterestHandling The interest handling type. Applied only for progressive interest-bearing loans. DEFAULT if not provided. (optional)
    * @return Call&lt;LoanScheduleData&gt;
    */
    @GET("v1/loans/{loanId}/transactions/reage-preview")
    Call<LoanScheduleData> previewReAgeSchedule(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("frequencyNumber") Integer frequencyNumber, @retrofit2.http.Query("frequencyType") String frequencyType, @retrofit2.http.Query("startDate") String startDate, @retrofit2.http.Query("numberOfInstallments") Integer numberOfInstallments, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("reAgeInterestHandling") String reAgeInterestHandling);

    /**
    * Preview Re-Age Schedule
    * Generates a preview of the re-aged loan schedule based on the provided parameters without creating any transactions or modifying the loan.
        * @param loanExternalId loanExternalId (required)
        * @param frequencyNumber The frequency number for the re-aging schedule (required)
        * @param frequencyType The frequency type (DAYS, WEEKS, MONTHS, YEARS) (required)
        * @param startDate The start date for the re-aging schedule (required)
        * @param numberOfInstallments The number of installments for the re-aged loan (required)
        * @param dateFormat The date format used for the startDate parameter (required)
        * @param locale The locale to use for formatting (required)
        * @param reAgeInterestHandling The interest handling type. Applied only for progressive interest-bearing loans. DEFAULT if not provided. (optional)
    * @return Call&lt;LoanScheduleData&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/reage-preview")
    Call<LoanScheduleData> previewReAgeSchedule1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("frequencyNumber") Integer frequencyNumber, @retrofit2.http.Query("frequencyType") String frequencyType, @retrofit2.http.Query("startDate") String startDate, @retrofit2.http.Query("numberOfInstallments") Integer numberOfInstallments, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("reAgeInterestHandling") String reAgeInterestHandling);

    /**
    * Preview Re-Amortized Schedule
    * Generates a preview of the re-amortized loan schedule based on the provided parameters without creating any transactions or modifying the loan.
        * @param loanId loanId (required)
        * @param reAmortizationInterestHandling The interest handling type (DEFAULT, WAIVE_INTEREST, EQUAL_AMORTIZATION_INTEREST_SPLIT) (required)
    * @return Call&lt;LoanScheduleData&gt;
    */
    @GET("v1/loans/{loanId}/transactions/reamortization-preview")
    Call<LoanScheduleData> previewReAmortizationSchedule(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("reAmortizationInterestHandling") String reAmortizationInterestHandling);

    /**
    * Preview Re-amortized Schedule
    * Generates a preview of the re-amortized loan schedule based on the provided parameters without creating any transactions or modifying the loan.
        * @param loanExternalId loanExternalId (required)
        * @param reAmortizationInterestHandling The interest handling type (DEFAULT, WAIVE_INTEREST, EQUAL_AMORTIZATION_INTEREST_SPLIT) (required)
    * @return Call&lt;LoanScheduleData&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/reamortization-preview")
    Call<LoanScheduleData> previewReAmortizationSchedule1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("reAmortizationInterestHandling") String reAmortizationInterestHandling);

    /**
    * Retrieve a Transaction Details
    * Retrieves a Transaction Details  Example Request:  loans/5/transactions/3
        * @param loanId loanId (required)
        * @param transactionId transactionId (required)
        * @param fields Optional Loan Transaction attribute list to be in the response (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/loans/{loanId}/transactions/{transactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransaction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("fields") String fields);

    /**
    * Retrieve a Transaction Details
    * Retrieves a Transaction Details  Example Request:  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/5dd80a7c-ccba-4446-b378-01eb6f53e871
        * @param loanExternalId loanExternalId (required)
        * @param externalTransactionId externalTransactionId (required)
        * @param fields Optional Loan Transaction attribute list to be in the response (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/external-id/{externalTransactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransactionByLoanExternalIdAndTransactionExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Query("fields") String fields);

    /**
    * Retrieve a Transaction Details
    * Retrieves a Transaction Details  Example Request:  loans/5/transactions/3
        * @param loanExternalId loanExternalId (required)
        * @param transactionId transactionId (required)
        * @param fields Optional Loan Transaction attribute list to be in the response (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/{transactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransactionByLoanExternalIdAndTransactionId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("fields") String fields);

    /**
    * Retrieve a Transaction Details
    * Retrieves a Transaction Details  Example Request:  loans/5/transactions/external-id/5dd80a7c-ccba-4446-b378-01eb6f53e871
        * @param loanId loanId (required)
        * @param externalTransactionId externalTransactionId (required)
        * @param fields Optional Loan Transaction attribute list to be in the response (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/loans/{loanId}/transactions/external-id/{externalTransactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransactionByTransactionExternalId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Query("fields") String fields);

    /**
    * Retrieve Loan Transaction Template
    * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed Value Lists  Example Requests:  loans/1/transactions/template?command&#x3D;repaymentloans/1/transactions/template?command&#x3D;merchantIssuedRefundloans/1/transactions/template?command&#x3D;payoutRefundloans/1/transactions/template?command&#x3D;goodwillCredit loans/1/transactions/template?command&#x3D;waiveinterest loans/1/transactions/template?command&#x3D;writeoff loans/1/transactions/template?command&#x3D;close-rescheduled loans/1/transactions/template?command&#x3D;close loans/1/transactions/template?command&#x3D;disburse loans/1/transactions/template?command&#x3D;disburseToSavings loans/1/transactions/template?command&#x3D;recoverypayment loans/1/transactions/template?command&#x3D;prepayLoan loans/1/transactions/template?command&#x3D;refundbycash loans/1/transactions/template?command&#x3D;refundbytransfer loans/1/transactions/template?command&#x3D;foreclosure loans/1/transactions/template?command&#x3D;interestPaymentWaiver loans/1/transactions/template?command&#x3D;creditBalanceRefund (returned &#39;amount&#39; field will have the overpaid value) loans/1/transactions/template?command&#x3D;charge-off loans/1/transactions/template?command&#x3D;downPayment loans/1/transactions/template?command&#x3D;interest-refund
        * @param loanId loanId (required)
        * @param command command (optional)
        * @param dateFormat dateFormat (optional)
        * @param transactionDate transactionDate (optional)
        * @param locale locale (optional)
        * @param transactionId transactionId (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsTemplateResponse&gt;
    */
    @GET("v1/loans/{loanId}/transactions/template")
    Call<GetLoansLoanIdTransactionsTemplateResponse> retrieveTransactionTemplate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("command") String command, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("transactionDate") Object transactionDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("transactionId") Long transactionId);

    /**
    * Retrieve Loan Transaction Template
    * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed Value Lists  Example Requests:  loans/1/transactions/template?command&#x3D;repaymentloans/1/transactions/template?command&#x3D;merchantIssuedRefundloans/1/transactions/template?command&#x3D;payoutRefundloans/1/transactions/template?command&#x3D;goodwillCredit loans/1/transactions/template?command&#x3D;waiveinterest loans/1/transactions/template?command&#x3D;writeoff loans/1/transactions/template?command&#x3D;close-rescheduled loans/1/transactions/template?command&#x3D;close loans/1/transactions/template?command&#x3D;disburse loans/1/transactions/template?command&#x3D;disburseToSavings loans/1/transactions/template?command&#x3D;recoverypayment loans/1/transactions/template?command&#x3D;prepayLoan loans/1/transactions/template?command&#x3D;refundbycash loans/1/transactions/template?command&#x3D;refundbytransfer loans/1/transactions/template?command&#x3D;foreclosure loans/1/transactions/template?command&#x3D;interestPaymentWaiver loans/1/transactions/template?command&#x3D;creditBalanceRefund (returned &#39;amount&#39; field will have the overpaid value) loans/1/transactions/template?command&#x3D;charge-off loans/1/transactions/template?command&#x3D;downPayment loans/1/transactions/template?command&#x3D;interest-refund
        * @param loanExternalId loanExternalId (required)
        * @param command command (optional)
        * @param dateFormat dateFormat (optional)
        * @param transactionDate transactionDate (optional)
        * @param locale locale (optional)
        * @param transactionId transactionId (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsTemplateResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/template")
    Call<GetLoansLoanIdTransactionsTemplateResponse> retrieveTransactionTemplate1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("command") String command, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("transactionDate") Object transactionDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("transactionId") Long transactionId);

    /**
    * Retrieve Transactions
    * Retrieves transactions of a loan
        * @param loanExternalId loanId (required)
        * @param excludedTypes excludedTypes (optional)
        * @param page page (optional)
        * @param size size (optional)
        * @param sort sort (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/transactions")
    Call<GetLoansLoanIdTransactionsResponse> retrieveTransactionsByExternalLoanId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("excludedTypes") List<TransactionType> excludedTypes, @retrofit2.http.Query("page") Integer page, @retrofit2.http.Query("size") Integer size, @retrofit2.http.Query("sort") String sort);

    /**
    * Retrieve Transactions
    * Retrieves transactions of a loan
        * @param loanId loanId (required)
        * @param excludedTypes excludedTypes (optional)
        * @param page page (optional)
        * @param size size (optional)
        * @param sort sort (optional)
    * @return Call&lt;GetLoansLoanIdTransactionsResponse&gt;
    */
    @GET("v1/loans/{loanId}/transactions")
    Call<GetLoansLoanIdTransactionsResponse> retrieveTransactionsByLoanId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("excludedTypes") List<TransactionType> excludedTypes, @retrofit2.http.Query("page") Integer page, @retrofit2.http.Query("size") Integer size, @retrofit2.http.Query("sort") String sort);

    /**
    * Undo a Waive Charge Transaction
    * Undo a Waive Charge Transaction
        * @param loanId loanId (required)
        * @param transactionId transactionId (required)
        * @param putChargeTransactionChangesRequest  (required)
    * @return Call&lt;PutChargeTransactionChangesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/transactions/{transactionId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest);

    /**
    * Undo a Waive Charge Transaction
    * Undo a Waive Charge Transaction
        * @param loanId loanId (required)
        * @param transactionExternalId transactionExternalId (required)
        * @param putChargeTransactionChangesRequest  (required)
    * @return Call&lt;PutChargeTransactionChangesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/transactions/external-id/{transactionExternalId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest);

    /**
    * Undo a Waive Charge Transaction
    * Undo a Waive Charge Transaction
        * @param loanExternalId loanExternalId (required)
        * @param transactionId transactionId (required)
        * @param putChargeTransactionChangesRequest  (required)
    * @return Call&lt;PutChargeTransactionChangesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/transactions/{transactionId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest);

    /**
    * Undo a Waive Charge Transaction
    * Undo a Waive Charge Transaction
        * @param loanExternalId loanExternalId (required)
        * @param transactionExternalId transactionExternalId (required)
        * @param putChargeTransactionChangesRequest  (required)
    * @return Call&lt;PutChargeTransactionChangesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/transactions/external-id/{transactionExternalId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest);



        /**
        * Adjust a Transaction
        * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
            * @param loanId loanId (required)
            * @param transactionId transactionId (required)
            * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/transactions/{transactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Adjust a Transaction
        * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
            * @param loanId loanId (required)
            * @param externalTransactionId externalTransactionId (required)
            * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/transactions/external-id/{externalTransactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Adjust a Transaction
        * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
            * @param loanExternalId loanExternalId (required)
            * @param transactionId transactionId (required)
            * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/transactions/{transactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Adjust a Transaction
        * Note: there is no need to specify command&#x3D;{transactionType} parameter.  Mandatory Fields: transactionDate, transactionAmount
            * @param loanExternalId loanExternalId (required)
            * @param externalTransactionId externalTransactionId (required)
            * @param postLoansLoanIdTransactionsTransactionIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/transactions/external-id/{externalTransactionId}")
    Call<PostLoansLoanIdTransactionsResponse> adjustLoanTransaction3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Body PostLoansLoanIdTransactionsTransactionIdRequest postLoansLoanIdTransactionsTransactionIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Significant Loan Transactions
        * This API covers the major loan transaction functionality  Example Requests:  loans/1/transactions?command&#x3D;repayment | Make a Repayment |  loans/1/transactions?command&#x3D;merchantIssuedRefund | Merchant Issued Refund |  loans/1/transactions?command&#x3D;payoutRefund | Payout Refund |  loans/1/transactions?command&#x3D;goodwillCredit | Goodwil Credit |  loans/1/transactions?command&#x3D;chargeRefund | Charge Refund |  loans/1/transactions?command&#x3D;waiveinterest | Waive Interest |  loans/1/transactions?command&#x3D;writeoff | Write-off Loan |  loans/1/transactions?command&#x3D;close-rescheduled | Close Rescheduled Loan |  loans/1/transactions?command&#x3D;close | Close Loan |  loans/1/transactions?command&#x3D;undowriteoff | Undo Loan Write-off |  loans/1/transactions?command&#x3D;recoverypayment | Make Recovery Payment |  loans/1/transactions?command&#x3D;refundByCash | Make a Refund of an Active Loan by Cash |  loans/1/transactions?command&#x3D;foreclosure | Foreclosure of an Active Loan |  loans/1/transactions?command&#x3D;creditBalanceRefund | Credit Balance Refund |   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;charge-off | Charge-off Loan |   loans/1/transactions?command&#x3D;downPayment | Down Payment |   
            * @param loanId loanId (required)
            * @param postLoansLoanIdTransactionsRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/transactions")
    Call<PostLoansLoanIdTransactionsResponse> executeLoanTransaction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansLoanIdTransactionsRequest postLoansLoanIdTransactionsRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Significant Loan Transactions
        * This API covers the major loan transaction functionality  Example Requests:  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;repayment | Make a Repayment |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;merchantIssuedRefund | Merchant Issued Refund |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;payoutRefund | Payout Refund |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;goodwillCredit | Goodwil Credit |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;chargeRefund | Charge Refund |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;waiveinterest | Waive Interest |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;writeoff | Write-off Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;close-rescheduled | Close Rescheduled Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;close | Close Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;undowriteoff | Undo Loan Write-off |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;recoverypayment | Make Recovery Payment |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;refundByCash | Make a Refund of an Active Loan by Cash |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;foreclosure | Foreclosure of an Active Loan |  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;creditBalanceRefund | Credit Balance Refund |   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;charge-off | Charge-off Loan |   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command&#x3D;downPayment | Down Payment |   
            * @param loanExternalId loanExternalId (required)
            * @param postLoansLoanIdTransactionsRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/transactions")
    Call<PostLoansLoanIdTransactionsResponse> executeLoanTransaction1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansLoanIdTransactionsRequest postLoansLoanIdTransactionsRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Preview Re-Age Schedule
        * Generates a preview of the re-aged loan schedule based on the provided parameters without creating any transactions or modifying the loan.
            * @param loanId loanId (required)
            * @param frequencyNumber The frequency number for the re-aging schedule (required)
            * @param frequencyType The frequency type (DAYS, WEEKS, MONTHS, YEARS) (required)
            * @param startDate The start date for the re-aging schedule (required)
            * @param numberOfInstallments The number of installments for the re-aged loan (required)
            * @param dateFormat The date format used for the startDate parameter (required)
            * @param locale The locale to use for formatting (required)
            * @param reAgeInterestHandling The interest handling type. Applied only for progressive interest-bearing loans. DEFAULT if not provided. (optional)
        * @return Call&lt;LoanScheduleData&gt;
        */
    @GET("v1/loans/{loanId}/transactions/reage-preview")
    Call<LoanScheduleData> previewReAgeSchedule(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("frequencyNumber") Integer frequencyNumber, @retrofit2.http.Query("frequencyType") String frequencyType, @retrofit2.http.Query("startDate") String startDate, @retrofit2.http.Query("numberOfInstallments") Integer numberOfInstallments, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("reAgeInterestHandling") String reAgeInterestHandling, @HeaderMap Map<String, String> headers);

        /**
        * Preview Re-Age Schedule
        * Generates a preview of the re-aged loan schedule based on the provided parameters without creating any transactions or modifying the loan.
            * @param loanExternalId loanExternalId (required)
            * @param frequencyNumber The frequency number for the re-aging schedule (required)
            * @param frequencyType The frequency type (DAYS, WEEKS, MONTHS, YEARS) (required)
            * @param startDate The start date for the re-aging schedule (required)
            * @param numberOfInstallments The number of installments for the re-aged loan (required)
            * @param dateFormat The date format used for the startDate parameter (required)
            * @param locale The locale to use for formatting (required)
            * @param reAgeInterestHandling The interest handling type. Applied only for progressive interest-bearing loans. DEFAULT if not provided. (optional)
        * @return Call&lt;LoanScheduleData&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/reage-preview")
    Call<LoanScheduleData> previewReAgeSchedule1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("frequencyNumber") Integer frequencyNumber, @retrofit2.http.Query("frequencyType") String frequencyType, @retrofit2.http.Query("startDate") String startDate, @retrofit2.http.Query("numberOfInstallments") Integer numberOfInstallments, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("reAgeInterestHandling") String reAgeInterestHandling, @HeaderMap Map<String, String> headers);

        /**
        * Preview Re-Amortized Schedule
        * Generates a preview of the re-amortized loan schedule based on the provided parameters without creating any transactions or modifying the loan.
            * @param loanId loanId (required)
            * @param reAmortizationInterestHandling The interest handling type (DEFAULT, WAIVE_INTEREST, EQUAL_AMORTIZATION_INTEREST_SPLIT) (required)
        * @return Call&lt;LoanScheduleData&gt;
        */
    @GET("v1/loans/{loanId}/transactions/reamortization-preview")
    Call<LoanScheduleData> previewReAmortizationSchedule(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("reAmortizationInterestHandling") String reAmortizationInterestHandling, @HeaderMap Map<String, String> headers);

        /**
        * Preview Re-amortized Schedule
        * Generates a preview of the re-amortized loan schedule based on the provided parameters without creating any transactions or modifying the loan.
            * @param loanExternalId loanExternalId (required)
            * @param reAmortizationInterestHandling The interest handling type (DEFAULT, WAIVE_INTEREST, EQUAL_AMORTIZATION_INTEREST_SPLIT) (required)
        * @return Call&lt;LoanScheduleData&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/reamortization-preview")
    Call<LoanScheduleData> previewReAmortizationSchedule1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("reAmortizationInterestHandling") String reAmortizationInterestHandling, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Transaction Details
        * Retrieves a Transaction Details  Example Request:  loans/5/transactions/3
            * @param loanId loanId (required)
            * @param transactionId transactionId (required)
            * @param fields Optional Loan Transaction attribute list to be in the response (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/loans/{loanId}/transactions/{transactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransaction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Transaction Details
        * Retrieves a Transaction Details  Example Request:  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/5dd80a7c-ccba-4446-b378-01eb6f53e871
            * @param loanExternalId loanExternalId (required)
            * @param externalTransactionId externalTransactionId (required)
            * @param fields Optional Loan Transaction attribute list to be in the response (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/external-id/{externalTransactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransactionByLoanExternalIdAndTransactionExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Transaction Details
        * Retrieves a Transaction Details  Example Request:  loans/5/transactions/3
            * @param loanExternalId loanExternalId (required)
            * @param transactionId transactionId (required)
            * @param fields Optional Loan Transaction attribute list to be in the response (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/{transactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransactionByLoanExternalIdAndTransactionId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Transaction Details
        * Retrieves a Transaction Details  Example Request:  loans/5/transactions/external-id/5dd80a7c-ccba-4446-b378-01eb6f53e871
            * @param loanId loanId (required)
            * @param externalTransactionId externalTransactionId (required)
            * @param fields Optional Loan Transaction attribute list to be in the response (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/loans/{loanId}/transactions/external-id/{externalTransactionId}")
    Call<GetLoansLoanIdTransactionsTransactionIdResponse> retrieveTransactionByTransactionExternalId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("externalTransactionId") String externalTransactionId, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Loan Transaction Template
        * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed Value Lists  Example Requests:  loans/1/transactions/template?command&#x3D;repaymentloans/1/transactions/template?command&#x3D;merchantIssuedRefundloans/1/transactions/template?command&#x3D;payoutRefundloans/1/transactions/template?command&#x3D;goodwillCredit loans/1/transactions/template?command&#x3D;waiveinterest loans/1/transactions/template?command&#x3D;writeoff loans/1/transactions/template?command&#x3D;close-rescheduled loans/1/transactions/template?command&#x3D;close loans/1/transactions/template?command&#x3D;disburse loans/1/transactions/template?command&#x3D;disburseToSavings loans/1/transactions/template?command&#x3D;recoverypayment loans/1/transactions/template?command&#x3D;prepayLoan loans/1/transactions/template?command&#x3D;refundbycash loans/1/transactions/template?command&#x3D;refundbytransfer loans/1/transactions/template?command&#x3D;foreclosure loans/1/transactions/template?command&#x3D;interestPaymentWaiver loans/1/transactions/template?command&#x3D;creditBalanceRefund (returned &#39;amount&#39; field will have the overpaid value) loans/1/transactions/template?command&#x3D;charge-off loans/1/transactions/template?command&#x3D;downPayment loans/1/transactions/template?command&#x3D;interest-refund
            * @param loanId loanId (required)
            * @param command command (optional)
            * @param dateFormat dateFormat (optional)
            * @param transactionDate transactionDate (optional)
            * @param locale locale (optional)
            * @param transactionId transactionId (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsTemplateResponse&gt;
        */
    @GET("v1/loans/{loanId}/transactions/template")
    Call<GetLoansLoanIdTransactionsTemplateResponse> retrieveTransactionTemplate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("command") String command, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("transactionDate") Object transactionDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Loan Transaction Template
        * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed Value Lists  Example Requests:  loans/1/transactions/template?command&#x3D;repaymentloans/1/transactions/template?command&#x3D;merchantIssuedRefundloans/1/transactions/template?command&#x3D;payoutRefundloans/1/transactions/template?command&#x3D;goodwillCredit loans/1/transactions/template?command&#x3D;waiveinterest loans/1/transactions/template?command&#x3D;writeoff loans/1/transactions/template?command&#x3D;close-rescheduled loans/1/transactions/template?command&#x3D;close loans/1/transactions/template?command&#x3D;disburse loans/1/transactions/template?command&#x3D;disburseToSavings loans/1/transactions/template?command&#x3D;recoverypayment loans/1/transactions/template?command&#x3D;prepayLoan loans/1/transactions/template?command&#x3D;refundbycash loans/1/transactions/template?command&#x3D;refundbytransfer loans/1/transactions/template?command&#x3D;foreclosure loans/1/transactions/template?command&#x3D;interestPaymentWaiver loans/1/transactions/template?command&#x3D;creditBalanceRefund (returned &#39;amount&#39; field will have the overpaid value) loans/1/transactions/template?command&#x3D;charge-off loans/1/transactions/template?command&#x3D;downPayment loans/1/transactions/template?command&#x3D;interest-refund
            * @param loanExternalId loanExternalId (required)
            * @param command command (optional)
            * @param dateFormat dateFormat (optional)
            * @param transactionDate transactionDate (optional)
            * @param locale locale (optional)
            * @param transactionId transactionId (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsTemplateResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/transactions/template")
    Call<GetLoansLoanIdTransactionsTemplateResponse> retrieveTransactionTemplate1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("command") String command, @retrofit2.http.Query("dateFormat") String dateFormat, @retrofit2.http.Query("transactionDate") Object transactionDate, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Transactions
        * Retrieves transactions of a loan
            * @param loanExternalId loanId (required)
            * @param excludedTypes excludedTypes (optional)
            * @param page page (optional)
            * @param size size (optional)
            * @param sort sort (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/transactions")
    Call<GetLoansLoanIdTransactionsResponse> retrieveTransactionsByExternalLoanId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("excludedTypes") List<TransactionType> excludedTypes, @retrofit2.http.Query("page") Integer page, @retrofit2.http.Query("size") Integer size, @retrofit2.http.Query("sort") String sort, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Transactions
        * Retrieves transactions of a loan
            * @param loanId loanId (required)
            * @param excludedTypes excludedTypes (optional)
            * @param page page (optional)
            * @param size size (optional)
            * @param sort sort (optional)
        * @return Call&lt;GetLoansLoanIdTransactionsResponse&gt;
        */
    @GET("v1/loans/{loanId}/transactions")
    Call<GetLoansLoanIdTransactionsResponse> retrieveTransactionsByLoanId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("excludedTypes") List<TransactionType> excludedTypes, @retrofit2.http.Query("page") Integer page, @retrofit2.http.Query("size") Integer size, @retrofit2.http.Query("sort") String sort, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Waive Charge Transaction
        * Undo a Waive Charge Transaction
            * @param loanId loanId (required)
            * @param transactionId transactionId (required)
            * @param putChargeTransactionChangesRequest  (required)
        * @return Call&lt;PutChargeTransactionChangesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/transactions/{transactionId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Waive Charge Transaction
        * Undo a Waive Charge Transaction
            * @param loanId loanId (required)
            * @param transactionExternalId transactionExternalId (required)
            * @param putChargeTransactionChangesRequest  (required)
        * @return Call&lt;PutChargeTransactionChangesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/transactions/external-id/{transactionExternalId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Waive Charge Transaction
        * Undo a Waive Charge Transaction
            * @param loanExternalId loanExternalId (required)
            * @param transactionId transactionId (required)
            * @param putChargeTransactionChangesRequest  (required)
        * @return Call&lt;PutChargeTransactionChangesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/transactions/{transactionId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Waive Charge Transaction
        * Undo a Waive Charge Transaction
            * @param loanExternalId loanExternalId (required)
            * @param transactionExternalId transactionExternalId (required)
            * @param putChargeTransactionChangesRequest  (required)
        * @return Call&lt;PutChargeTransactionChangesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/transactions/external-id/{transactionExternalId}")
    Call<PutChargeTransactionChangesResponse> undoWaiveCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Body PutChargeTransactionChangesRequest putChargeTransactionChangesRequest, @HeaderMap Map<String, String> headers);


}
