/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.dfa;

import java.io.Serializable;
import org.apache.flink.streaming.examples.statemachine.dfa.State;
import org.apache.flink.streaming.examples.statemachine.event.EventType;
import org.apache.flink.util.Preconditions;

public class Transition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EventType eventType;
    private final State targetState;
    private final float prob;

    public Transition(EventType eventType, State targetState, float prob) {
        this.eventType = (EventType)((Object)Preconditions.checkNotNull((Object)((Object)eventType)));
        this.targetState = (State)((Object)Preconditions.checkNotNull((Object)((Object)targetState)));
        this.prob = prob;
    }

    public EventType eventType() {
        return this.eventType;
    }

    public State targetState() {
        return this.targetState;
    }

    public float prob() {
        return this.prob;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Transition that = (Transition)obj;
        return this.eventType == that.eventType && this.targetState == that.targetState && Float.compare(this.prob, that.prob) == 0;
    }

    public int hashCode() {
        int code = 31 * this.eventType.hashCode() + this.targetState.hashCode();
        return 31 * code + (this.prob != 0.0f ? Float.floatToIntBits(this.prob) : 0);
    }

    public String toString() {
        return "--[" + this.eventType.name() + "]--> " + this.targetState.name() + " (" + this.prob + ")";
    }
}

