/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.planner.typeutils.RowTypeUtils;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class OverAggregateUtil$ {
    public static OverAggregateUtil$ MODULE$;

    static {
        new OverAggregateUtil$();
    }

    public OverSpec createOverSpec(Window logicalWindow) {
        ImmutableList<Window.Group> groups = logicalWindow.groups.asList();
        PartitionSpec partition = new PartitionSpec(((Window.Group)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(groups).head()).keys.toArray());
        ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(groups).tail()).foreach((Function1 & Serializable & scala.Serializable)g2 -> {
            OverAggregateUtil$.$anonfun$createOverSpec$1(partition, g2);
            return BoxedUnit.UNIT;
        });
        return new OverSpec(partition, JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(groups).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.createGroupSpec((Window.Group)x$1, logicalWindow), Buffer$.MODULE$.canBuildFrom())), logicalWindow.constants.asList(), this.calcOriginalInputFields(logicalWindow));
    }

    public OverSpec.GroupSpec createGroupSpec(Window.Group windowGroup, Window window) {
        return new OverSpec.GroupSpec(SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowGroup.orderKeys.getFieldCollations())), windowGroup.isRows, windowGroup.lowerBound, windowGroup.upperBound, windowGroup.getAggregateCalls(window));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Window.Group> splitOutOffsetOrInsensitiveGroup(Seq<Window.Group> windowGroups) {
        void var2_2;
        ArrayBuffer newWindowGroups = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        windowGroups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            OverAggregateUtil$.$anonfun$splitOutOffsetOrInsensitiveGroup$1(newWindowGroups, group);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public int calcOriginalInputFields(Window logicWindow) {
        return logicWindow.getRowType().getFieldCount() - ((SeqLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicWindow.groups).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(x$2.aggCalls), Buffer$.MODULE$.canBuildFrom())).size();
    }

    public long getLongBoundary(OverSpec overSpec, RexWindowBound windowBound) {
        return Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)this.getBoundary(overSpec, windowBound)));
    }

    public Object getBoundary(Window logicWindow, RexWindowBound windowBound) {
        return this.getBoundary(windowBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicWindow.getConstants()), this.calcOriginalInputFields(logicWindow));
    }

    public Object getBoundary(OverSpec overSpec, RexWindowBound windowBound) {
        return this.getBoundary(windowBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(overSpec.getConstants()), overSpec.getOriginalInputFields());
    }

    private Object getBoundary(RexWindowBound windowBound, Seq<RexLiteral> constants, int originalInputFields) {
        Number number;
        if (windowBound.isCurrentRow()) {
            number = BoxesRunTime.boxToLong((long)0L);
        } else {
            RexInputRef ref = (RexInputRef)windowBound.getOffset();
            int boundIndex = ref.getIndex() - originalInputFields;
            int flag = windowBound.isPreceding() ? -1 : 1;
            RexLiteral literal = (RexLiteral)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(constants).get(boundIndex);
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number2 = ((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName) ? ((BigDecimal)literal.getValue3()).multiply(new BigDecimal(flag)) : BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(literal.getValueAs(Long.class)) * (long)flag));
            number = number2;
        }
        return number;
    }

    public RelCollation createCollation(Window.Group windowGroup) {
        RelCollation relCollation;
        int[] groupSet = windowGroup.keys.toArray();
        List<RelFieldCollation> collations = windowGroup.orderKeys.getFieldCollations();
        int[] orderKeyIndexes = SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(collations)).getFieldIndices();
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).nonEmpty() || new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(orderKeyIndexes)).nonEmpty()) {
            Buffer collectionIndexes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(collations).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.getFieldIndex()), Buffer$.MODULE$.canBuildFrom());
            int[] intersectIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(orderKeyIndexes)).intersect((GenSeq)Predef$.MODULE$.wrapIntArray(groupSet));
            Tuple3[] groupCollation = (Tuple3[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).map((Function1 & Serializable & scala.Serializable)idx -> OverAggregateUtil$.$anonfun$createCollation$2(collations, collectionIndexes, intersectIds, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            Buffer orderCollation = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(collations).filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)OverAggregateUtil$.$anonfun$createCollation$3(intersectIds, c)))).map((Function1 & Serializable & scala.Serializable)c -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()), (Object)c.getDirection(), (Object)c.nullDirection), Buffer$.MODULE$.canBuildFrom());
            ArrayList<RelFieldCollation> fields = new ArrayList<RelFieldCollation>();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupCollation)).$plus$plus((GenTraversableOnce)orderCollation, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).foreach((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)fields.add(FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(BoxesRunTime.unboxToInt((Object)field._1()), (RelFieldCollation.Direction)((Object)field._2()), (RelFieldCollation.NullDirection)((Object)field._3())))));
            relCollation = RelCollations.of(fields);
        } else {
            relCollation = RelCollations.EMPTY;
        }
        return relCollation;
    }

    public boolean needCollationTrait(Window logicalWindow, Window.Group windowGroup) {
        boolean bl;
        if (windowGroup.lowerBound.isPreceding() || windowGroup.upperBound.isFollowing() || !windowGroup.isRows) {
            bl = true;
        } else {
            long offsetLower = BoxesRunTime.unboxToLong((Object)this.getBoundary(windowGroup.lowerBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicalWindow.constants).toList(), this.calcOriginalInputFields(logicalWindow)));
            long offsetUpper = BoxesRunTime.unboxToLong((Object)this.getBoundary(windowGroup.upperBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicalWindow.constants).toList(), this.calcOriginalInputFields(logicalWindow)));
            bl = offsetLower != 0L || offsetUpper != 0L || !windowGroup.orderKeys.getFieldCollations().isEmpty();
        }
        return bl;
    }

    public RelDataType inferOutputRowType(RelOptCluster cluster, RelDataType inputType, Seq<AggregateCall> aggCalls) {
        List<String> inputNameList = inputType.getFieldNames();
        Buffer inputTypeList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getType(), Buffer$.MODULE$.canBuildFrom());
        List<String> aggNames = RowTypeUtils.getUniqueName(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)aggCalls.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Seq$.MODULE$.canBuildFrom())), inputNameList);
        Seq aggTypes = (Seq)aggCalls.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getType(), Seq$.MODULE$.canBuildFrom());
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        return typeFactory.createStructType(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)inputTypeList.$plus$plus((GenTraversableOnce)aggTypes, Buffer$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputNameList).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggNames))));
    }

    public static final /* synthetic */ void $anonfun$createOverSpec$1(PartitionSpec partition$1, Window.Group g2) {
        if (!partition$1.equals(new PartitionSpec(g2.keys.toArray()))) {
            throw new TableException("OverSpec requires all groups should have same partition key.");
        }
    }

    private static final boolean compareAggCall$1(Window.RexWinAggCall c1, Window.RexWinAggCall c2) {
        boolean bl;
        boolean allowsFraming1 = c1.getOperator().allowsFraming();
        boolean allowsFraming2 = c2.getOperator().allowsFraming();
        if (!allowsFraming1 && !allowsFraming2) {
            Class<?> clazz = c1.getOperator().getClass();
            Class<?> clazz2 = c2.getOperator().getClass();
            bl = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        } else {
            bl = allowsFraming1 == allowsFraming2;
        }
        return bl;
    }

    private static final Window.Group createNewGroup$1(Window.Group windowGroup, Seq newAggCalls) {
        return new Window.Group(windowGroup.keys, windowGroup.isRows, windowGroup.lowerBound, windowGroup.upperBound, windowGroup.orderKeys, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(newAggCalls));
    }

    public static final /* synthetic */ void $anonfun$splitOutOffsetOrInsensitiveGroup$2(ArrayBuffer newWindowGroups$1, ObjectRef lastAggCall$1, ArrayBuffer aggCallsBuffer$1, Window.Group group$1, Window.RexWinAggCall aggCall) {
        if ((Window.RexWinAggCall)lastAggCall$1.elem != null && !OverAggregateUtil$.compareAggCall$1((Window.RexWinAggCall)lastAggCall$1.elem, aggCall)) {
            JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)newWindowGroups$1).add(OverAggregateUtil$.createNewGroup$1(group$1, (Seq)aggCallsBuffer$1));
            aggCallsBuffer$1.clear();
        }
        JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)aggCallsBuffer$1).add(aggCall);
        lastAggCall$1.elem = aggCall;
    }

    public static final /* synthetic */ void $anonfun$splitOutOffsetOrInsensitiveGroup$1(ArrayBuffer newWindowGroups$1, Window.Group group) {
        block0: {
            ObjectRef lastAggCall = ObjectRef.create(null);
            ArrayBuffer aggCallsBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(group.aggCalls).foreach((Function1 & Serializable & scala.Serializable)aggCall -> {
                OverAggregateUtil$.$anonfun$splitOutOffsetOrInsensitiveGroup$2(newWindowGroups$1, lastAggCall, aggCallsBuffer, group, aggCall);
                return BoxedUnit.UNIT;
            });
            if (!aggCallsBuffer.nonEmpty()) break block0;
            JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)newWindowGroups$1).add(OverAggregateUtil$.createNewGroup$1(group, (Seq)aggCallsBuffer));
            aggCallsBuffer.clear();
        }
    }

    public static final /* synthetic */ Tuple3 $anonfun$createCollation$2(List collations$1, Buffer collectionIndexes$1, int[] intersectIds$1, int idx) {
        Tuple3 tuple3;
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(intersectIds$1)).contains((Object)BoxesRunTime.boxToInteger((int)idx))) {
            int index = collectionIndexes$1.indexOf((Object)BoxesRunTime.boxToInteger((int)idx));
            RelFieldCollation collation = (RelFieldCollation)collations$1.get(index);
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)collation.getFieldIndex()), (Object)collation.getDirection(), (Object)collation.nullDirection);
        } else {
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)RelFieldCollation.Direction.ASCENDING, (Object)RelFieldCollation.NullDirection.FIRST);
        }
        return tuple3;
    }

    public static final /* synthetic */ boolean $anonfun$createCollation$3(int[] intersectIds$1, RelFieldCollation c) {
        return !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(intersectIds$1)).contains((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()));
    }

    private OverAggregateUtil$() {
        MODULE$ = this;
    }
}

