/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.materializedtable;

import java.io.IOException;
import java.net.URLClassLoader;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.deployment.application.cli.ApplicationClusterDeployer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.factories.WorkflowSchedulerFactoryUtil;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactoryUtils;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestOptions;
import org.apache.flink.table.gateway.service.operation.OperationExecutor;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.command.DescribeJobOperation;
import org.apache.flink.table.operations.command.StopJobOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableAsQueryOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableChangeOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableRefreshOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableResumeOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableSuspendOperation;
import org.apache.flink.table.operations.materializedtable.CreateMaterializedTableOperation;
import org.apache.flink.table.operations.materializedtable.DropMaterializedTableOperation;
import org.apache.flink.table.operations.materializedtable.MaterializedTableOperation;
import org.apache.flink.table.refresh.ContinuousRefreshHandler;
import org.apache.flink.table.refresh.ContinuousRefreshHandlerSerializer;
import org.apache.flink.table.refresh.RefreshHandler;
import org.apache.flink.table.refresh.RefreshHandlerSerializer;
import org.apache.flink.table.runtime.application.SqlDriver;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.table.utils.IntervalFreshnessUtils;
import org.apache.flink.table.workflow.CreatePeriodicRefreshWorkflow;
import org.apache.flink.table.workflow.CreateRefreshWorkflow;
import org.apache.flink.table.workflow.DeleteRefreshWorkflow;
import org.apache.flink.table.workflow.ModifyRefreshWorkflow;
import org.apache.flink.table.workflow.ResumeRefreshWorkflow;
import org.apache.flink.table.workflow.SuspendRefreshWorkflow;
import org.apache.flink.table.workflow.WorkflowScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MaterializedTableManager {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedTableManager.class);
    private final URLClassLoader userCodeClassLoader;
    @Nullable
    private final WorkflowScheduler<? extends RefreshHandler> workflowScheduler;
    private final String restEndpointUrl;

    public MaterializedTableManager(Configuration configuration, URLClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = userCodeClassLoader;
        this.restEndpointUrl = this.buildRestEndpointUrl(configuration);
        this.workflowScheduler = this.buildWorkflowScheduler(configuration, userCodeClassLoader);
    }

    private String buildRestEndpointUrl(Configuration configuration) {
        Configuration restEndpointConfig = Configuration.fromMap(SqlGatewayEndpointFactoryUtils.getEndpointConfig(configuration, "rest"));
        String address = (String)restEndpointConfig.get(SqlGatewayRestOptions.ADDRESS);
        int port = (Integer)restEndpointConfig.get(SqlGatewayRestOptions.PORT);
        return String.format("http://%s:%s", address, port);
    }

    private WorkflowScheduler<? extends RefreshHandler> buildWorkflowScheduler(Configuration configuration, URLClassLoader userCodeClassLoader) {
        return WorkflowSchedulerFactoryUtil.createWorkflowScheduler((Configuration)configuration, (ClassLoader)userCodeClassLoader);
    }

    public void open() throws Exception {
        if (this.workflowScheduler != null) {
            this.workflowScheduler.open();
        }
    }

    public void close() throws Exception {
        if (this.workflowScheduler != null) {
            this.workflowScheduler.close();
        }
    }

    public ResultFetcher callMaterializedTableOperation(OperationExecutor operationExecutor, OperationHandle handle, MaterializedTableOperation op, String statement) {
        if (op instanceof CreateMaterializedTableOperation) {
            return this.callCreateMaterializedTableOperation(operationExecutor, handle, (CreateMaterializedTableOperation)op);
        }
        if (op instanceof AlterMaterializedTableRefreshOperation) {
            return this.callAlterMaterializedTableRefreshOperation(operationExecutor, handle, (AlterMaterializedTableRefreshOperation)op);
        }
        if (op instanceof AlterMaterializedTableSuspendOperation) {
            return this.callAlterMaterializedTableSuspend(operationExecutor, handle, (AlterMaterializedTableSuspendOperation)op);
        }
        if (op instanceof AlterMaterializedTableResumeOperation) {
            return this.callAlterMaterializedTableResume(operationExecutor, handle, (AlterMaterializedTableResumeOperation)op);
        }
        if (op instanceof DropMaterializedTableOperation) {
            return this.callDropMaterializedTableOperation(operationExecutor, handle, (DropMaterializedTableOperation)op);
        }
        if (op instanceof AlterMaterializedTableAsQueryOperation) {
            return this.callAlterMaterializedTableAsQueryOperation(operationExecutor, handle, (AlterMaterializedTableAsQueryOperation)op);
        }
        throw new SqlExecutionException(String.format("Unsupported Operation %s for materialized table.", op.asSummaryString()));
    }

    private ResultFetcher callCreateMaterializedTableOperation(OperationExecutor operationExecutor, OperationHandle handle, CreateMaterializedTableOperation createMaterializedTableOperation) {
        CatalogMaterializedTable materializedTable = createMaterializedTableOperation.getCatalogMaterializedTable();
        if (CatalogMaterializedTable.RefreshMode.CONTINUOUS == materializedTable.getRefreshMode()) {
            this.createMaterializedTableInContinuousMode(operationExecutor, handle, createMaterializedTableOperation);
        } else {
            this.createMaterializedTableInFullMode(operationExecutor, handle, createMaterializedTableOperation);
        }
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private void createMaterializedTableInContinuousMode(OperationExecutor operationExecutor, OperationHandle handle, CreateMaterializedTableOperation createMaterializedTableOperation) {
        operationExecutor.callExecutableOperation(handle, (ExecutableOperation)createMaterializedTableOperation);
        ObjectIdentifier materializedTableIdentifier = createMaterializedTableOperation.getTableIdentifier();
        CatalogMaterializedTable catalogMaterializedTable = createMaterializedTableOperation.getCatalogMaterializedTable();
        try {
            this.executeContinuousRefreshJob(operationExecutor, handle, catalogMaterializedTable, materializedTableIdentifier, Collections.emptyMap(), Optional.empty());
        }
        catch (Exception e) {
            operationExecutor.callExecutableOperation(handle, (ExecutableOperation)new DropMaterializedTableOperation(materializedTableIdentifier, true));
            throw new SqlExecutionException(String.format("Submit continuous refresh job for materialized table %s occur exception.", materializedTableIdentifier), e);
        }
    }

    private void createMaterializedTableInFullMode(OperationExecutor operationExecutor, OperationHandle handle, CreateMaterializedTableOperation createMaterializedTableOperation) {
        if (this.workflowScheduler == null) {
            throw new SqlExecutionException("The workflow scheduler must be configured when creating materialized table in full refresh mode.");
        }
        operationExecutor.callExecutableOperation(handle, (ExecutableOperation)createMaterializedTableOperation);
        ObjectIdentifier materializedTableIdentifier = createMaterializedTableOperation.getTableIdentifier();
        CatalogMaterializedTable catalogMaterializedTable = createMaterializedTableOperation.getCatalogMaterializedTable();
        String cronExpression = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)catalogMaterializedTable.getDefinitionFreshness());
        CreatePeriodicRefreshWorkflow createRefreshWorkflow = new CreatePeriodicRefreshWorkflow(materializedTableIdentifier, catalogMaterializedTable.getDefinitionQuery(), cronExpression, this.getSessionInitializationConf(operationExecutor), Collections.emptyMap(), this.restEndpointUrl);
        try {
            RefreshHandler refreshHandler = this.workflowScheduler.createRefreshWorkflow((CreateRefreshWorkflow)createRefreshWorkflow);
            RefreshHandlerSerializer refreshHandlerSerializer = this.workflowScheduler.getRefreshHandlerSerializer();
            byte[] serializedRefreshHandler = refreshHandlerSerializer.serialize(refreshHandler);
            this.updateRefreshHandler(operationExecutor, handle, materializedTableIdentifier, catalogMaterializedTable, CatalogMaterializedTable.RefreshStatus.ACTIVATED, refreshHandler.asSummaryString(), serializedRefreshHandler);
        }
        catch (Exception e) {
            operationExecutor.callExecutableOperation(handle, (ExecutableOperation)new DropMaterializedTableOperation(materializedTableIdentifier, true));
            throw new SqlExecutionException(String.format("Failed to create refresh workflow for materialized table %s.", materializedTableIdentifier), e);
        }
    }

    private ResultFetcher callAlterMaterializedTableSuspend(OperationExecutor operationExecutor, OperationHandle handle, AlterMaterializedTableSuspendOperation op) {
        ObjectIdentifier tableIdentifier = op.getTableIdentifier();
        ResolvedCatalogMaterializedTable materializedTable = this.getCatalogMaterializedTable(operationExecutor, tableIdentifier);
        if (CatalogMaterializedTable.RefreshStatus.INITIALIZING == materializedTable.getRefreshStatus()) {
            throw new SqlExecutionException(String.format("Materialized table %s is being initialized and does not support suspend operation.", tableIdentifier));
        }
        if (CatalogMaterializedTable.RefreshMode.CONTINUOUS == materializedTable.getRefreshMode()) {
            this.suspendContinuousRefreshJob(operationExecutor, handle, tableIdentifier, (CatalogMaterializedTable)materializedTable);
        } else {
            this.suspendRefreshWorkflow(operationExecutor, handle, tableIdentifier, (CatalogMaterializedTable)materializedTable);
        }
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private CatalogMaterializedTable suspendContinuousRefreshJob(OperationExecutor operationExecutor, OperationHandle handle, ObjectIdentifier tableIdentifier, CatalogMaterializedTable materializedTable) {
        try {
            ContinuousRefreshHandler refreshHandler = this.deserializeContinuousHandler(materializedTable.getSerializedRefreshHandler());
            if (CatalogMaterializedTable.RefreshStatus.SUSPENDED == materializedTable.getRefreshStatus()) {
                throw new SqlExecutionException(String.format("Materialized table %s continuous refresh job has been suspended, jobId is %s.", tableIdentifier, refreshHandler.getJobId()));
            }
            String savepointPath = MaterializedTableManager.stopJobWithSavepoint(operationExecutor, handle, refreshHandler);
            ContinuousRefreshHandler updateRefreshHandler = new ContinuousRefreshHandler(refreshHandler.getExecutionTarget(), refreshHandler.getClusterId(), refreshHandler.getJobId(), savepointPath);
            return this.updateRefreshHandler(operationExecutor, handle, tableIdentifier, materializedTable, CatalogMaterializedTable.RefreshStatus.SUSPENDED, updateRefreshHandler.asSummaryString(), this.serializeContinuousHandler(updateRefreshHandler));
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Failed to suspend the continuous refresh job for materialized table %s.", tableIdentifier), e);
        }
    }

    private void suspendRefreshWorkflow(OperationExecutor operationExecutor, OperationHandle handle, ObjectIdentifier tableIdentifier, CatalogMaterializedTable materializedTable) {
        if (CatalogMaterializedTable.RefreshStatus.SUSPENDED == materializedTable.getRefreshStatus()) {
            throw new SqlExecutionException(String.format("Materialized table %s refresh workflow has been suspended.", tableIdentifier));
        }
        if (this.workflowScheduler == null) {
            throw new SqlExecutionException("The workflow scheduler must be configured when suspending materialized table in full refresh mode.");
        }
        try {
            RefreshHandlerSerializer refreshHandlerSerializer = this.workflowScheduler.getRefreshHandlerSerializer();
            RefreshHandler refreshHandler = refreshHandlerSerializer.deserialize(materializedTable.getSerializedRefreshHandler(), (ClassLoader)this.userCodeClassLoader);
            SuspendRefreshWorkflow modifyRefreshWorkflow = new SuspendRefreshWorkflow(refreshHandler);
            this.workflowScheduler.modifyRefreshWorkflow((ModifyRefreshWorkflow)modifyRefreshWorkflow);
            this.updateRefreshHandler(operationExecutor, handle, tableIdentifier, materializedTable, CatalogMaterializedTable.RefreshStatus.SUSPENDED, refreshHandler.asSummaryString(), materializedTable.getSerializedRefreshHandler());
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Failed to suspend the refresh workflow for materialized table %s.", tableIdentifier), e);
        }
    }

    private ResultFetcher callAlterMaterializedTableResume(OperationExecutor operationExecutor, OperationHandle handle, AlterMaterializedTableResumeOperation op) {
        ObjectIdentifier tableIdentifier = op.getTableIdentifier();
        ResolvedCatalogMaterializedTable catalogMaterializedTable = this.getCatalogMaterializedTable(operationExecutor, tableIdentifier);
        if (CatalogMaterializedTable.RefreshStatus.INITIALIZING == catalogMaterializedTable.getRefreshStatus()) {
            throw new SqlExecutionException(String.format("Materialized table %s is being initialized and does not support resume operation.", tableIdentifier));
        }
        if (CatalogMaterializedTable.RefreshMode.CONTINUOUS == catalogMaterializedTable.getRefreshMode()) {
            this.resumeContinuousRefreshJob(operationExecutor, handle, tableIdentifier, (CatalogMaterializedTable)catalogMaterializedTable, op.getDynamicOptions());
        } else {
            this.resumeRefreshWorkflow(operationExecutor, handle, tableIdentifier, (CatalogMaterializedTable)catalogMaterializedTable, op.getDynamicOptions());
        }
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private void resumeContinuousRefreshJob(OperationExecutor operationExecutor, OperationHandle handle, ObjectIdentifier tableIdentifier, CatalogMaterializedTable catalogMaterializedTable, Map<String, String> dynamicOptions) {
        JobStatus jobStatus;
        ContinuousRefreshHandler refreshHandler = this.deserializeContinuousHandler(catalogMaterializedTable.getSerializedRefreshHandler());
        if (CatalogMaterializedTable.RefreshStatus.ACTIVATED == catalogMaterializedTable.getRefreshStatus() && !(jobStatus = MaterializedTableManager.getJobStatus(operationExecutor, handle, refreshHandler)).isGloballyTerminalState()) {
            throw new SqlExecutionException(String.format("Materialized table %s continuous refresh job has been resumed, jobId is %s.", tableIdentifier, refreshHandler.getJobId()));
        }
        Optional restorePath = refreshHandler.getRestorePath();
        try {
            this.executeContinuousRefreshJob(operationExecutor, handle, catalogMaterializedTable, tableIdentifier, dynamicOptions, restorePath);
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Failed to resume the continuous refresh job for materialized table %s.", tableIdentifier), e);
        }
    }

    private void resumeRefreshWorkflow(OperationExecutor operationExecutor, OperationHandle handle, ObjectIdentifier tableIdentifier, CatalogMaterializedTable catalogMaterializedTable, Map<String, String> dynamicOptions) {
        if (CatalogMaterializedTable.RefreshStatus.ACTIVATED == catalogMaterializedTable.getRefreshStatus()) {
            throw new SqlExecutionException(String.format("Materialized table %s refresh workflow has been resumed.", tableIdentifier));
        }
        if (this.workflowScheduler == null) {
            throw new SqlExecutionException("The workflow scheduler must be configured when resuming materialized table in full refresh mode.");
        }
        try {
            RefreshHandlerSerializer refreshHandlerSerializer = this.workflowScheduler.getRefreshHandlerSerializer();
            RefreshHandler refreshHandler = refreshHandlerSerializer.deserialize(catalogMaterializedTable.getSerializedRefreshHandler(), (ClassLoader)this.userCodeClassLoader);
            ResumeRefreshWorkflow modifyRefreshWorkflow = new ResumeRefreshWorkflow(refreshHandler, dynamicOptions);
            this.workflowScheduler.modifyRefreshWorkflow((ModifyRefreshWorkflow)modifyRefreshWorkflow);
            this.updateRefreshHandler(operationExecutor, handle, tableIdentifier, catalogMaterializedTable, CatalogMaterializedTable.RefreshStatus.ACTIVATED, refreshHandler.asSummaryString(), catalogMaterializedTable.getSerializedRefreshHandler());
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Failed to resume the refresh workflow for materialized table %s.", tableIdentifier), e);
        }
    }

    private void executeContinuousRefreshJob(OperationExecutor operationExecutor, OperationHandle handle, CatalogMaterializedTable catalogMaterializedTable, ObjectIdentifier materializedTableIdentifier, Map<String, String> dynamicOptions, Optional<String> restorePath) {
        Configuration customConfig = new Configuration();
        String jobName = String.format("Materialized_table_%s_continuous_refresh_job", materializedTableIdentifier.asSerializableString());
        customConfig.set(PipelineOptions.NAME, (Object)jobName);
        customConfig.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
        restorePath.ifPresent(s -> customConfig.set(StateRecoveryOptions.SAVEPOINT_PATH, s));
        if (!operationExecutor.getSessionContext().getSessionConf().contains(CheckpointingOptions.CHECKPOINTING_INTERVAL)) {
            customConfig.set(CheckpointingOptions.CHECKPOINTING_INTERVAL, (Object)catalogMaterializedTable.getFreshness());
        }
        String insertStatement = MaterializedTableManager.getInsertStatement(materializedTableIdentifier, catalogMaterializedTable.getDefinitionQuery(), dynamicOptions);
        JobExecutionResult result = MaterializedTableManager.executeRefreshJob(insertStatement, customConfig, operationExecutor, handle);
        ContinuousRefreshHandler continuousRefreshHandler = new ContinuousRefreshHandler(result.executionTarget, result.clusterId, result.jobId);
        byte[] serializedBytes = this.serializeContinuousHandler(continuousRefreshHandler);
        this.updateRefreshHandler(operationExecutor, handle, materializedTableIdentifier, catalogMaterializedTable, CatalogMaterializedTable.RefreshStatus.ACTIVATED, continuousRefreshHandler.asSummaryString(), serializedBytes);
    }

    private ResultFetcher callAlterMaterializedTableRefreshOperation(OperationExecutor operationExecutor, OperationHandle handle, AlterMaterializedTableRefreshOperation alterMaterializedTableRefreshOperation) {
        ObjectIdentifier materializedTableIdentifier = alterMaterializedTableRefreshOperation.getTableIdentifier();
        Map partitionSpec = alterMaterializedTableRefreshOperation.getPartitionSpec();
        return this.refreshMaterializedTable(operationExecutor, handle, materializedTableIdentifier, partitionSpec, Collections.emptyMap(), false, null);
    }

    public ResultFetcher refreshMaterializedTable(OperationExecutor operationExecutor, OperationHandle handle, ObjectIdentifier materializedTableIdentifier, Map<String, String> staticPartitions, Map<String, String> dynamicOptions, boolean isPeriodic, @Nullable String scheduleTime) {
        ResolvedCatalogMaterializedTable materializedTable = this.getCatalogMaterializedTable(operationExecutor, materializedTableIdentifier);
        Map<String, String> refreshPartitions = isPeriodic ? MaterializedTableManager.getPeriodRefreshPartition(scheduleTime, materializedTable.getDefinitionFreshness(), materializedTableIdentifier, materializedTable.getOptions(), operationExecutor.getTableEnvironment().getConfig().getLocalTimeZone()) : staticPartitions;
        this.validatePartitionSpec(refreshPartitions, materializedTable);
        Configuration customConfig = new Configuration();
        String jobName = isPeriodic ? String.format("Materialized_table_%s_periodic_refresh_job", materializedTableIdentifier.asSerializableString()) : String.format("Materialized_table_%s_one_time_refresh_job", materializedTableIdentifier.asSerializableString());
        customConfig.set(PipelineOptions.NAME, (Object)jobName);
        customConfig.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        String insertStatement = MaterializedTableManager.getRefreshStatement(materializedTableIdentifier, materializedTable.getDefinitionQuery(), refreshPartitions, dynamicOptions);
        try {
            LOG.info("Begin to refreshing the materialized table {}, statement: {}", (Object)materializedTableIdentifier, (Object)insertStatement);
            JobExecutionResult result = MaterializedTableManager.executeRefreshJob(insertStatement, customConfig, operationExecutor, handle);
            HashMap<StringData, StringData> clusterInfo = new HashMap<StringData, StringData>();
            clusterInfo.put(StringData.fromString((String)DeploymentOptions.TARGET.key()), StringData.fromString((String)result.executionTarget));
            Optional<String> clusterIdKeyName = MaterializedTableManager.getClusterIdKeyName(result.executionTarget);
            clusterIdKeyName.ifPresent(s -> clusterInfo.put(StringData.fromString((String)s), StringData.fromString((String)result.clusterId)));
            return ResultFetcher.fromResults(handle, ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"job id", (DataType)DataTypes.STRING()), Column.physical((String)"cluster info", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))}), Collections.singletonList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)result.jobId), new GenericMapData(clusterInfo)})));
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Refreshing the materialized table %s occur exception.", materializedTableIdentifier), e);
        }
    }

    @VisibleForTesting
    static Map<String, String> getPeriodRefreshPartition(String scheduleTime, IntervalFreshness freshness, ObjectIdentifier materializedTableIdentifier, Map<String, String> materializedTableOptions, ZoneId localZoneId) {
        if (scheduleTime == null) {
            throw new ValidationException(String.format("The scheduler time must not be null during the periodic refresh of the materialized table %s.", materializedTableIdentifier));
        }
        Set partitionFields = materializedTableOptions.keySet().stream().filter(k -> k.startsWith("partition.fields")).collect(Collectors.toSet());
        HashMap<String, String> refreshPartitions = new HashMap<String, String>();
        for (String partKey : partitionFields) {
            String partField = partKey.substring("partition.fields".length() + 1, partKey.length() - ("date-formatter".length() + 1));
            String partFieldFormatter = materializedTableOptions.get(partKey);
            String partFiledValue = DateTimeUtils.formatTimestampStringWithOffset((String)scheduleTime, (String)"yyyy-MM-dd HH:mm:ss", (String)partFieldFormatter, (TimeZone)TimeZone.getTimeZone(localZoneId), (long)(-IntervalFreshnessUtils.convertFreshnessToDuration((IntervalFreshness)freshness).toMillis()));
            if (partFiledValue == null) {
                throw new SqlExecutionException(String.format("Failed to parse a valid partition value for the field '%s' in materialized table %s using the scheduler time '%s' based on the date format '%s'.", partField, materializedTableIdentifier.asSerializableString(), scheduleTime, "yyyy-MM-dd HH:mm:ss"));
            }
            refreshPartitions.put(partField, partFiledValue);
        }
        return refreshPartitions;
    }

    private void validatePartitionSpec(Map<String, String> partitionSpec, ResolvedCatalogMaterializedTable table) {
        ResolvedSchema schema = table.getResolvedSchema();
        HashSet allPartitionKeys = new HashSet(table.getPartitionKeys());
        HashSet<String> unknownPartitionKeys = new HashSet<String>();
        HashSet<String> nonStringPartitionKeys = new HashSet<String>();
        for (String partitionKey : partitionSpec.keySet()) {
            if (!schema.getColumn(partitionKey).isPresent()) {
                unknownPartitionKeys.add(partitionKey);
                continue;
            }
            if (((Column)schema.getColumn(partitionKey).get()).getDataType().getLogicalType().getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING)) continue;
            nonStringPartitionKeys.add(partitionKey);
        }
        if (!unknownPartitionKeys.isEmpty()) {
            throw new ValidationException(String.format("The partition spec contains unknown partition keys:\n\n%s\n\nAll known partition keys are:\n\n%s", String.join((CharSequence)"\n", unknownPartitionKeys), String.join((CharSequence)"\n", allPartitionKeys)));
        }
        if (!nonStringPartitionKeys.isEmpty()) {
            throw new ValidationException(String.format("Currently, refreshing materialized table only supports referring to char, varchar and string type partition keys. All specified partition keys in partition specs with unsupported types are:\n\n%s", String.join((CharSequence)"\n", nonStringPartitionKeys)));
        }
    }

    @VisibleForTesting
    protected static String getRefreshStatement(ObjectIdentifier tableIdentifier, String definitionQuery, Map<String, String> partitionSpec, Map<String, String> dynamicOptions) {
        String tableIdentifierWithDynamicOptions = MaterializedTableManager.generateTableWithDynamicOptions(tableIdentifier, dynamicOptions);
        StringBuilder insertStatement = new StringBuilder(String.format("INSERT OVERWRITE %s\n  SELECT * FROM (%s)", tableIdentifierWithDynamicOptions, definitionQuery));
        if (!partitionSpec.isEmpty()) {
            insertStatement.append("\n  WHERE ");
            insertStatement.append(partitionSpec.entrySet().stream().map(entry -> String.format("%s = '%s'", entry.getKey(), entry.getValue())).reduce((s1, s2) -> s1 + " AND " + s2).get());
        }
        return insertStatement.toString();
    }

    private ResultFetcher callAlterMaterializedTableAsQueryOperation(OperationExecutor operationExecutor, OperationHandle handle, AlterMaterializedTableAsQueryOperation op) {
        ObjectIdentifier tableIdentifier = op.getTableIdentifier();
        ResolvedCatalogMaterializedTable oldMaterializedTable = this.getCatalogMaterializedTable(operationExecutor, tableIdentifier);
        if (CatalogMaterializedTable.RefreshMode.FULL == oldMaterializedTable.getRefreshMode()) {
            AlterMaterializedTableChangeOperation alterMaterializedTableChangeOperation = new AlterMaterializedTableChangeOperation(tableIdentifier, op.getTableChanges(), op.getNewMaterializedTable());
            return operationExecutor.callExecutableOperation(handle, (ExecutableOperation)alterMaterializedTableChangeOperation);
        }
        if (CatalogMaterializedTable.RefreshStatus.ACTIVATED == oldMaterializedTable.getRefreshStatus()) {
            CatalogMaterializedTable suspendMaterializedTable = this.suspendContinuousRefreshJob(operationExecutor, handle, tableIdentifier, (CatalogMaterializedTable)oldMaterializedTable);
            CatalogMaterializedTable updatedMaterializedTable = op.getNewMaterializedTable().copy(suspendMaterializedTable.getRefreshStatus(), (String)suspendMaterializedTable.getRefreshHandlerDescription().orElse(null), suspendMaterializedTable.getSerializedRefreshHandler());
            AlterMaterializedTableChangeOperation alterMaterializedTableChangeOperation = new AlterMaterializedTableChangeOperation(tableIdentifier, op.getTableChanges(), updatedMaterializedTable);
            operationExecutor.callExecutableOperation(handle, (ExecutableOperation)alterMaterializedTableChangeOperation);
            try {
                this.executeContinuousRefreshJob(operationExecutor, handle, updatedMaterializedTable, tableIdentifier, Collections.emptyMap(), Optional.empty());
            }
            catch (Exception e) {
                LOG.warn("Failed to start the continuous refresh job for materialized table {} using new query {}, rollback to origin query {}.", new Object[]{tableIdentifier, op.getNewMaterializedTable().getDefinitionQuery(), suspendMaterializedTable.getDefinitionQuery(), e});
                AlterMaterializedTableChangeOperation rollbackChangeOperation = this.generateRollbackAlterMaterializedTableOperation(suspendMaterializedTable, alterMaterializedTableChangeOperation);
                operationExecutor.callExecutableOperation(handle, (ExecutableOperation)rollbackChangeOperation);
                ContinuousRefreshHandler continuousRefreshHandler = this.deserializeContinuousHandler(suspendMaterializedTable.getSerializedRefreshHandler());
                this.executeContinuousRefreshJob(operationExecutor, handle, suspendMaterializedTable, tableIdentifier, Collections.emptyMap(), continuousRefreshHandler.getRestorePath());
                throw new SqlExecutionException(String.format("Failed to start the continuous refresh job using new query %s when altering materialized table %s select query.", op.getNewMaterializedTable().getDefinitionQuery(), tableIdentifier), e);
            }
        } else if (CatalogMaterializedTable.RefreshStatus.SUSPENDED == oldMaterializedTable.getRefreshStatus()) {
            ArrayList<TableChange.ModifyRefreshHandler> tableChanges = new ArrayList<TableChange.ModifyRefreshHandler>(op.getTableChanges());
            TableChange.ModifyRefreshHandler modifyRefreshHandler = this.generateResetSavepointTableChange(oldMaterializedTable.getSerializedRefreshHandler());
            tableChanges.add(modifyRefreshHandler);
            CatalogMaterializedTable updatedMaterializedTable = op.getNewMaterializedTable().copy(oldMaterializedTable.getRefreshStatus(), modifyRefreshHandler.getRefreshHandlerDesc(), modifyRefreshHandler.getRefreshHandlerBytes());
            AlterMaterializedTableChangeOperation alterMaterializedTableChangeOperation = new AlterMaterializedTableChangeOperation(tableIdentifier, tableChanges, updatedMaterializedTable);
            operationExecutor.callExecutableOperation(handle, (ExecutableOperation)alterMaterializedTableChangeOperation);
        } else {
            throw new SqlExecutionException(String.format("Materialized table %s is being initialized and does not support alter operation.", tableIdentifier));
        }
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private AlterMaterializedTableChangeOperation generateRollbackAlterMaterializedTableOperation(CatalogMaterializedTable oldMaterializedTable, AlterMaterializedTableChangeOperation op) {
        List tableChanges = op.getTableChanges();
        ArrayList<Object> rollbackChanges = new ArrayList<Object>();
        for (TableChange tableChange : tableChanges) {
            if (tableChange instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
                rollbackChanges.add(TableChange.dropColumn((String)addColumn.getColumn().getName()));
                continue;
            }
            if (tableChange instanceof TableChange.ModifyRefreshHandler) {
                rollbackChanges.add(TableChange.modifyRefreshHandler((String)oldMaterializedTable.getRefreshHandlerDescription().orElse(null), (byte[])oldMaterializedTable.getSerializedRefreshHandler()));
                continue;
            }
            if (tableChange instanceof TableChange.ModifyDefinitionQuery) {
                rollbackChanges.add(TableChange.modifyDefinitionQuery((String)oldMaterializedTable.getDefinitionQuery()));
                continue;
            }
            throw new ValidationException(String.format("Failed to generate rollback changes for materialized table '%s'. Unsupported table change detected: %s. ", op.getTableIdentifier(), tableChange));
        }
        return new AlterMaterializedTableChangeOperation(op.getTableIdentifier(), rollbackChanges, oldMaterializedTable);
    }

    private TableChange.ModifyRefreshHandler generateResetSavepointTableChange(byte[] serializedContinuousHandler) {
        ContinuousRefreshHandler continuousRefreshHandler = this.deserializeContinuousHandler(serializedContinuousHandler);
        ContinuousRefreshHandler resetContinuousRefreshHandler = new ContinuousRefreshHandler(continuousRefreshHandler.getExecutionTarget(), continuousRefreshHandler.getClusterId(), continuousRefreshHandler.getJobId());
        return TableChange.modifyRefreshHandler((String)resetContinuousRefreshHandler.asSummaryString(), (byte[])this.serializeContinuousHandler(resetContinuousRefreshHandler));
    }

    private ResultFetcher callDropMaterializedTableOperation(OperationExecutor operationExecutor, OperationHandle handle, DropMaterializedTableOperation dropMaterializedTableOperation) {
        ObjectIdentifier tableIdentifier = dropMaterializedTableOperation.getTableIdentifier();
        boolean tableExists = operationExecutor.tableExists(tableIdentifier);
        if (!tableExists) {
            if (dropMaterializedTableOperation.isIfExists()) {
                LOG.info("Materialized table {} does not exists, skip the drop operation.", (Object)tableIdentifier);
                return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
            }
            throw new ValidationException(String.format("Materialized table with identifier %s does not exist.", tableIdentifier));
        }
        ResolvedCatalogMaterializedTable materializedTable = this.getCatalogMaterializedTable(operationExecutor, tableIdentifier);
        CatalogMaterializedTable.RefreshMode refreshMode = materializedTable.getRefreshMode();
        CatalogMaterializedTable.RefreshStatus refreshStatus = materializedTable.getRefreshStatus();
        if (CatalogMaterializedTable.RefreshStatus.ACTIVATED == refreshStatus || CatalogMaterializedTable.RefreshStatus.SUSPENDED == refreshStatus) {
            if (CatalogMaterializedTable.RefreshMode.FULL == refreshMode) {
                this.deleteRefreshWorkflow(tableIdentifier, (CatalogMaterializedTable)materializedTable);
            } else if (CatalogMaterializedTable.RefreshMode.CONTINUOUS == refreshMode && CatalogMaterializedTable.RefreshStatus.ACTIVATED == refreshStatus) {
                this.cancelContinuousRefreshJob(operationExecutor, handle, tableIdentifier, (CatalogMaterializedTable)materializedTable);
            }
        } else if (CatalogMaterializedTable.RefreshStatus.INITIALIZING == materializedTable.getRefreshStatus()) {
            throw new ValidationException(String.format("Current refresh status of materialized table %s is initializing, skip the drop operation.", tableIdentifier.asSerializableString()));
        }
        operationExecutor.callExecutableOperation(handle, (ExecutableOperation)dropMaterializedTableOperation);
        return ResultFetcher.fromTableResult(handle, TableResultInternal.TABLE_RESULT_OK, false);
    }

    private void cancelContinuousRefreshJob(OperationExecutor operationExecutor, OperationHandle handle, ObjectIdentifier tableIdentifier, CatalogMaterializedTable materializedTable) {
        ContinuousRefreshHandler refreshHandler = this.deserializeContinuousHandler(materializedTable.getSerializedRefreshHandler());
        JobStatus jobStatus = MaterializedTableManager.getJobStatus(operationExecutor, handle, refreshHandler);
        if (!jobStatus.isTerminalState()) {
            try {
                MaterializedTableManager.cancelJob(operationExecutor, handle, refreshHandler);
            }
            catch (Exception e) {
                jobStatus = MaterializedTableManager.getJobStatus(operationExecutor, handle, refreshHandler);
                if (!jobStatus.isTerminalState()) {
                    throw new SqlExecutionException(String.format("Failed to drop the materialized table %s because the continuous refresh job %s could not be canceled. The current status of the continuous refresh job is %s.", tableIdentifier, refreshHandler.getJobId(), jobStatus), e);
                }
                LOG.warn("An exception occurred while canceling the continuous refresh job {} for materialized table {}, but since the job is in a terminal state, skip the cancel operation.", (Object)refreshHandler.getJobId(), (Object)tableIdentifier);
            }
        } else {
            LOG.info("No need to cancel the continuous refresh job {} for materialized table {} as it is not currently running.", (Object)refreshHandler.getJobId(), (Object)tableIdentifier);
        }
    }

    private void deleteRefreshWorkflow(ObjectIdentifier tableIdentifier, CatalogMaterializedTable catalogMaterializedTable) {
        if (this.workflowScheduler == null) {
            throw new SqlExecutionException("The workflow scheduler must be configured when dropping materialized table in full refresh mode.");
        }
        try {
            RefreshHandlerSerializer refreshHandlerSerializer = this.workflowScheduler.getRefreshHandlerSerializer();
            RefreshHandler refreshHandler = refreshHandlerSerializer.deserialize(catalogMaterializedTable.getSerializedRefreshHandler(), (ClassLoader)this.userCodeClassLoader);
            DeleteRefreshWorkflow deleteRefreshWorkflow = new DeleteRefreshWorkflow(refreshHandler);
            this.workflowScheduler.deleteRefreshWorkflow(deleteRefreshWorkflow);
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Failed to delete the refresh workflow for materialized table %s.", tableIdentifier), e);
        }
    }

    private Map<String, String> getSessionInitializationConf(OperationExecutor operationExecutor) {
        Map sessionConf = operationExecutor.getSessionContext().getSessionConf().toMap();
        Map defaultContextConf = operationExecutor.getSessionContext().getDefaultContext().getFlinkConfig().toMap();
        sessionConf.entrySet().removeIf(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            return defaultContextConf.containsKey(key) && ((String)defaultContextConf.get(key)).equals(value);
        });
        sessionConf.remove(TableConfigOptions.RESOURCES_DOWNLOAD_DIR.key());
        sessionConf.keySet().removeIf(key -> key.startsWith("workflow-scheduler"));
        return sessionConf;
    }

    private static JobStatus getJobStatus(OperationExecutor operationExecutor, OperationHandle handle, ContinuousRefreshHandler refreshHandler) {
        ResultFetcher resultFetcher = operationExecutor.callDescribeJobOperation(MaterializedTableManager.getTableEnvironment(operationExecutor, refreshHandler), handle, new DescribeJobOperation(refreshHandler.getJobId()));
        List<RowData> result = MaterializedTableManager.fetchAllResults(resultFetcher);
        String jobStatus = result.get(0).getString(2).toString();
        return JobStatus.valueOf((String)jobStatus);
    }

    private static void cancelJob(OperationExecutor operationExecutor, OperationHandle handle, ContinuousRefreshHandler refreshHandler) {
        operationExecutor.callStopJobOperation(MaterializedTableManager.getTableEnvironment(operationExecutor, refreshHandler), handle, new StopJobOperation(refreshHandler.getJobId(), false, false));
    }

    private static String stopJobWithSavepoint(OperationExecutor executor, OperationHandle handle, ContinuousRefreshHandler refreshHandler) {
        Optional savepointDir = executor.getSessionContext().getSessionConf().getOptional(CheckpointingOptions.SAVEPOINT_DIRECTORY);
        if (savepointDir.isEmpty()) {
            throw new ValidationException("Savepoint directory is not configured, can't stop job with savepoint.");
        }
        String jobId = refreshHandler.getJobId();
        ResultFetcher resultFetcher = executor.callStopJobOperation(MaterializedTableManager.getTableEnvironment(executor, refreshHandler), handle, new StopJobOperation(jobId, true, false));
        List<RowData> results = MaterializedTableManager.fetchAllResults(resultFetcher);
        return results.get(0).getString(0).toString();
    }

    private static TableEnvironmentInternal getTableEnvironment(OperationExecutor executor, ContinuousRefreshHandler refreshHandler) {
        String target = refreshHandler.getExecutionTarget();
        Configuration sessionConfiguration = new Configuration();
        sessionConfiguration.set(DeploymentOptions.TARGET, (Object)target);
        Optional<String> clusterIdKeyName = MaterializedTableManager.getClusterIdKeyName(target);
        clusterIdKeyName.ifPresent(s -> sessionConfiguration.setString(s, refreshHandler.getClusterId()));
        return executor.getTableEnvironment(executor.getSessionContext().getSessionState().resourceManager, sessionConfiguration);
    }

    private ContinuousRefreshHandler deserializeContinuousHandler(byte[] serializedRefreshHandler) {
        try {
            return ContinuousRefreshHandlerSerializer.INSTANCE.deserialize(serializedRefreshHandler, (ClassLoader)this.userCodeClassLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SqlExecutionException("Deserialize ContinuousRefreshHandler occur exception.", e);
        }
    }

    private byte[] serializeContinuousHandler(ContinuousRefreshHandler refreshHandler) {
        try {
            return ContinuousRefreshHandlerSerializer.INSTANCE.serialize(refreshHandler);
        }
        catch (IOException e) {
            throw new SqlExecutionException("Serialize ContinuousRefreshHandler occur exception.", e);
        }
    }

    private ResolvedCatalogMaterializedTable getCatalogMaterializedTable(OperationExecutor operationExecutor, ObjectIdentifier tableIdentifier) {
        ResolvedCatalogBaseTable<?> resolvedCatalogBaseTable = operationExecutor.getTable(tableIdentifier);
        if (CatalogBaseTable.TableKind.MATERIALIZED_TABLE != resolvedCatalogBaseTable.getTableKind()) {
            throw new ValidationException(String.format("Table %s is not a materialized table, does not support materialized table related operation.", tableIdentifier));
        }
        return (ResolvedCatalogMaterializedTable)resolvedCatalogBaseTable;
    }

    private CatalogMaterializedTable updateRefreshHandler(OperationExecutor operationExecutor, OperationHandle operationHandle, ObjectIdentifier materializedTableIdentifier, CatalogMaterializedTable catalogMaterializedTable, CatalogMaterializedTable.RefreshStatus refreshStatus, String refreshHandlerSummary, byte[] serializedRefreshHandler) {
        CatalogMaterializedTable updatedMaterializedTable = catalogMaterializedTable.copy(refreshStatus, refreshHandlerSummary, serializedRefreshHandler);
        ArrayList<Object> tableChanges = new ArrayList<Object>();
        tableChanges.add(TableChange.modifyRefreshStatus((CatalogMaterializedTable.RefreshStatus)refreshStatus));
        tableChanges.add(TableChange.modifyRefreshHandler((String)refreshHandlerSummary, (byte[])serializedRefreshHandler));
        AlterMaterializedTableChangeOperation alterMaterializedTableChangeOperation = new AlterMaterializedTableChangeOperation(materializedTableIdentifier, tableChanges, updatedMaterializedTable);
        operationExecutor.callExecutableOperation(operationHandle, (ExecutableOperation)alterMaterializedTableChangeOperation);
        return updatedMaterializedTable;
    }

    @VisibleForTesting
    protected static String getInsertStatement(ObjectIdentifier materializedTableIdentifier, String definitionQuery, Map<String, String> dynamicOptions) {
        return String.format("INSERT INTO %s\n%s", MaterializedTableManager.generateTableWithDynamicOptions(materializedTableIdentifier, dynamicOptions), definitionQuery);
    }

    private static String generateTableWithDynamicOptions(ObjectIdentifier objectIdentifier, Map<String, String> dynamicOptions) {
        StringBuilder builder = new StringBuilder(objectIdentifier.asSerializableString());
        if (!dynamicOptions.isEmpty()) {
            String hints = dynamicOptions.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", "));
            builder.append(String.format(" /*+ OPTIONS(%s) */", hints));
        }
        return builder.toString();
    }

    private static List<RowData> fetchAllResults(ResultFetcher resultFetcher) {
        Long token = 0L;
        ArrayList<RowData> results = new ArrayList<RowData>();
        while (token != null) {
            ResultSet result = resultFetcher.fetchResults(token, Integer.MAX_VALUE);
            results.addAll(result.getData());
            token = result.getNextToken();
        }
        return results;
    }

    private static JobExecutionResult executeRefreshJob(String script, Configuration executionConfig, OperationExecutor operationExecutor, OperationHandle operationHandle) {
        String executeTarget = (String)operationExecutor.getSessionContext().getSessionConf().get(DeploymentOptions.TARGET);
        if (executeTarget == null || executeTarget.isEmpty() || "local".equals(executeTarget)) {
            String errorMessage = String.format("Unsupported execution target detected: %s.Currently, only the following execution targets are supported: 'remote', 'yarn-session', 'yarn-application', 'kubernetes-session', 'kubernetes-application'. ", executeTarget);
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        if (executeTarget.endsWith("application")) {
            return MaterializedTableManager.executeApplicationJob(script, executionConfig, operationExecutor);
        }
        return MaterializedTableManager.executeNonApplicationJob(script, executionConfig, operationExecutor, operationHandle);
    }

    private static JobExecutionResult executeNonApplicationJob(String script, Configuration executionConfig, OperationExecutor operationExecutor, OperationHandle operationHandle) {
        String executeTarget = (String)operationExecutor.getSessionContext().getSessionConf().get(DeploymentOptions.TARGET);
        String clusterId = operationExecutor.getSessionClusterId().orElseThrow(() -> {
            String errorMessage = String.format("No cluster ID found when executing materialized table refresh job. Execution target is : %s", executeTarget);
            LOG.error(errorMessage);
            return new ValidationException(errorMessage);
        });
        ResultFetcher resultFetcher = operationExecutor.executeStatement(operationHandle, executionConfig, script);
        List<RowData> results = MaterializedTableManager.fetchAllResults(resultFetcher);
        String jobId = results.get(0).getString(0).toString();
        return new JobExecutionResult(executeTarget, clusterId, jobId);
    }

    private static JobExecutionResult executeApplicationJob(String script, Configuration executionConfig, OperationExecutor operationExecutor) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add("--" + SqlDriver.OPTION_SQL_SCRIPT.getLongOpt());
        arguments.add(script);
        Configuration mergedConfig = new Configuration(operationExecutor.getSessionContext().getSessionConf());
        mergedConfig.addAll(executionConfig);
        JobID jobId = new JobID();
        mergedConfig.set(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, (Object)jobId.toString());
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration(arguments.toArray(new String[0]), SqlDriver.class.getName());
        try {
            String clusterId = new ApplicationClusterDeployer((ClusterClientServiceLoader)new DefaultClusterClientServiceLoader()).run(mergedConfig, applicationConfiguration).toString();
            return new JobExecutionResult((String)mergedConfig.get(DeploymentOptions.TARGET), clusterId, jobId.toString());
        }
        catch (Throwable t) {
            LOG.error("Failed to deploy script {} to application cluster.", (Object)script, (Object)t);
            throw new SqlGatewayException("Failed to deploy script to cluster.", t);
        }
    }

    private static Optional<String> getClusterIdKeyName(String targetName) {
        if (targetName.startsWith("yarn")) {
            return Optional.of("yarn.application.id");
        }
        if (targetName.startsWith("kubernetes")) {
            return Optional.of("kubernetes.cluster-id");
        }
        return Optional.empty();
    }

    private static class JobExecutionResult {
        private final String executionTarget;
        private final String clusterId;
        private final String jobId;

        public JobExecutionResult(String executionTarget, String clusterId, String jobId) {
            this.executionTarget = executionTarget;
            this.clusterId = clusterId;
            this.jobId = jobId;
        }
    }
}

