/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalc;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableFlinkCalcMergeRule;
import org.apache.flink.table.planner.plan.utils.FlinkRelUtil;
import org.immutables.value.Value;

@Value.Enclosing
public class FlinkCalcMergeRule
extends RelRule<FlinkCalcMergeRuleConfig> {
    public static final FlinkCalcMergeRule INSTANCE = FlinkCalcMergeRuleConfig.DEFAULT.toRule();
    public static final FlinkCalcMergeRule STREAM_PHYSICAL_INSTANCE = FlinkCalcMergeRuleConfig.STREAM_PHYSICAL.toRule();

    protected FlinkCalcMergeRule(FlinkCalcMergeRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Calc topCalc = (Calc)call.rel(0);
        Calc bottomCalc = (Calc)call.rel(1);
        RexProgram topProgram = topCalc.getProgram();
        if (RexOver.containsOver(topProgram)) {
            return false;
        }
        return FlinkRelUtil.isMergeable(topCalc, bottomCalc);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Calc bottomCalc;
        Calc topCalc = (Calc)call.rel(0);
        Calc newCalc = FlinkRelUtil.merge(topCalc, bottomCalc = (Calc)call.rel(1));
        if (newCalc.getDigest().equals(bottomCalc.getDigest())) {
            call.getPlanner().prune(topCalc);
        }
        call.transformTo(newCalc);
    }

    @Value.Immutable(singleton=false)
    public static interface FlinkCalcMergeRuleConfig
    extends RelRule.Config {
        public static final FlinkCalcMergeRuleConfig DEFAULT = ImmutableFlinkCalcMergeRule.FlinkCalcMergeRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Calc.class).inputs(b1 -> b1.operand(Calc.class).anyInputs())).withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withDescription("FlinkCalcMergeRule");
        public static final FlinkCalcMergeRuleConfig STREAM_PHYSICAL = ImmutableFlinkCalcMergeRule.FlinkCalcMergeRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(StreamPhysicalCalc.class).inputs(b1 -> b1.operand(StreamPhysicalCalc.class).anyInputs())).withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withDescription("FlinkCalcMergeRule");

        @Override
        default public FlinkCalcMergeRule toRule() {
            return new FlinkCalcMergeRule(this);
        }
    }
}

