/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsTruncate;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ExecutableOperationUtils;

@Internal
public class TruncateTableOperation
implements ExecutableOperation {
    private final ObjectIdentifier tableIdentifier;

    public TruncateTableOperation(ObjectIdentifier tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        if (ctx.isStreamingMode()) {
            throw new TableException("TRUNCATE TABLE statement is not supported in streaming mode.");
        }
        CatalogManager catalogManager = ctx.getCatalogManager();
        ContextResolvedTable contextResolvedTable = catalogManager.getTableOrError(this.tableIdentifier);
        Object catalogBaseTable = contextResolvedTable.getTable();
        if (catalogBaseTable.getTableKind() == CatalogBaseTable.TableKind.VIEW) {
            throw new TableException("TRUNCATE TABLE statement is not supported for view.");
        }
        ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)contextResolvedTable.getResolvedTable();
        ObjectIdentifier objectIdentifier = contextResolvedTable.getIdentifier();
        if (contextResolvedTable.isAnonymous()) {
            throw new TableException("TRUNCATE TABLE statement is not supported for anonymous table.");
        }
        if (TableFactoryUtil.isLegacyConnectorOptions(ctx.getTableConfig(), ctx.isStreamingMode(), this.tableIdentifier, resolvedTable, contextResolvedTable.isTemporary())) {
            throw new TableException(String.format("Can't perform truncate table operation of the table %s because the corresponding table sink is the legacy TableSink. Please implement %s for it.", this.tableIdentifier, DynamicTableSink.class.getName()));
        }
        DynamicTableSink tableSink = ExecutableOperationUtils.createDynamicTableSink(contextResolvedTable.getCatalog().orElse(null), () -> ctx.getModuleManager().getFactory(Module::getTableSinkFactory), objectIdentifier, resolvedTable, Collections.emptyMap(), ctx.getTableConfig(), ctx.getResourceManager().getUserClassLoader(), contextResolvedTable.isTemporary());
        if (tableSink instanceof SupportsTruncate) {
            SupportsTruncate supportsTruncateTableSink = (SupportsTruncate)((Object)tableSink);
            try {
                supportsTruncateTableSink.executeTruncation();
                return TableResultInternal.TABLE_RESULT_OK;
            }
            catch (Exception e) {
                throw new TableException("Fail to execute TRUNCATE TABLE statement.", e);
            }
        }
        throw new TableException(String.format("TRUNCATE TABLE statement is not supported for the table %s since the table hasn't implemented the interface %s.", this.tableIdentifier.asSummaryString(), SupportsTruncate.class.getName()));
    }

    @VisibleForTesting
    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public String asSummaryString() {
        return "TRUNCATE TABLE " + this.tableIdentifier.toString();
    }
}

