/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePassThroughRecordWriter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class HivePassThroughOutputFormat<K, V>
implements Configurable,
HiveOutputFormat<K, V> {
    private OutputFormat<? super WritableComparable<?>, ? super Writable> actualOutputFormat = null;
    private String actualOutputFormatClass = "";
    private Configuration conf;
    private boolean initialized = false;
    public static final String HIVE_PASSTHROUGH_OF_CLASSNAME = "org.apache.hadoop.hive.ql.io.HivePassThroughOutputFormat";
    public static final String HIVE_PASSTHROUGH_STORAGEHANDLER_OF_JOBCONFKEY = "hive.passthrough.storagehandler.of";

    private void createActualOF() throws IOException {
        OutputFormat actualOF;
        Class<?> cls;
        try {
            if (this.actualOutputFormatClass == null) {
                throw new RuntimeException("Null pointer detected in actualOutputFormatClass");
            }
            cls = Class.forName(this.actualOutputFormatClass, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.actualOutputFormat = actualOF = (OutputFormat)ReflectionUtils.newInstance(cls, (Configuration)this.getConf());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (!this.initialized) {
            this.createActualOF();
            this.initialized = true;
        }
        this.actualOutputFormat.checkOutputSpecs(ignored, job);
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        if (!this.initialized) {
            this.createActualOF();
            this.initialized = true;
        }
        return this.actualOutputFormat.getRecordWriter(ignored, job, name, progress);
    }

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        if (!this.initialized) {
            this.createActualOF();
        }
        if (this.actualOutputFormat instanceof HiveOutputFormat) {
            return ((HiveOutputFormat)this.actualOutputFormat).getHiveRecordWriter(jc, finalOutPath, valueClass, isCompressed, tableProperties, progress);
        }
        FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
        HivePassThroughRecordWriter hivepassthroughrecordwriter = new HivePassThroughRecordWriter(this.actualOutputFormat.getRecordWriter(fs, jc, null, progress));
        return hivepassthroughrecordwriter;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration config) {
        if (config.get(HIVE_PASSTHROUGH_STORAGEHANDLER_OF_JOBCONFKEY) != null) {
            this.actualOutputFormatClass = config.get(HIVE_PASSTHROUGH_STORAGEHANDLER_OF_JOBCONFKEY);
        }
        this.conf = config;
    }
}

