/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.optimizer.optiq.OptiqSemanticException;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.util.Util;

public class SqlFunctionConverter {
    private static final Log LOG = LogFactory.getLog(SqlFunctionConverter.class);
    static final Map<String, SqlOperator> hiveToOptiq;
    static final Map<SqlOperator, HiveToken> optiqToHiveToken;
    static final Map<SqlOperator, String> reverseOperatorMap;

    public static SqlOperator getOptiqOperator(String funcTextName, GenericUDF hiveUDF, ImmutableList<RelDataType> optiqArgTypes, RelDataType retType) throws OptiqSemanticException {
        if (hiveUDF instanceof GenericUDFOPNegative) {
            return SqlStdOperatorTable.UNARY_MINUS;
        }
        if (hiveUDF instanceof GenericUDFOPPositive) {
            return SqlStdOperatorTable.UNARY_PLUS;
        }
        String name = null;
        if (StringUtils.isEmpty((CharSequence)funcTextName)) {
            name = SqlFunctionConverter.getName(hiveUDF);
            LOG.warn((Object)("The function text was empty, name from annotation is " + name));
        } else {
            name = FunctionRegistry.getNormalizedFunctionName(funcTextName);
        }
        return SqlFunctionConverter.getOptiqFn(name, optiqArgTypes, retType);
    }

    public static GenericUDF getHiveUDF(SqlOperator op, RelDataType dt, int argsLength) {
        FunctionInfo hFn;
        String name = reverseOperatorMap.get(op);
        if (name == null) {
            name = op.getName();
        }
        if (argsLength == 1) {
            if (name == "+") {
                name = "positive";
            } else if (name == "-") {
                name = "negative";
            }
        }
        try {
            hFn = name != null ? FunctionRegistry.getFunctionInfo(name) : null;
        }
        catch (SemanticException e) {
            LOG.warn((Object)("Failed to load udf " + name), (Throwable)e);
            hFn = null;
        }
        if (hFn == null) {
            try {
                hFn = SqlFunctionConverter.handleExplicitCast(op, dt);
            }
            catch (SemanticException e) {
                LOG.warn((Object)("Failed to load udf " + name), (Throwable)e);
                hFn = null;
            }
        }
        return hFn == null ? null : hFn.getGenericUDF();
    }

    private static FunctionInfo handleExplicitCast(SqlOperator op, RelDataType dt) throws SemanticException {
        FunctionInfo castUDF = null;
        if (op.kind == SqlKind.CAST) {
            TypeInfo castType = TypeConverter.convert(dt);
            if (castType.equals((Object)TypeInfoFactory.byteTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("tinyint");
            } else if (castType instanceof CharTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("char"));
            } else if (castType instanceof VarcharTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("varchar"));
            } else if (castType.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("string");
            } else if (castType.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("boolean");
            } else if (castType.equals((Object)TypeInfoFactory.shortTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("smallint");
            } else if (castType.equals((Object)TypeInfoFactory.intTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("int");
            } else if (castType.equals((Object)TypeInfoFactory.longTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("bigint");
            } else if (castType.equals((Object)TypeInfoFactory.floatTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("float");
            } else if (castType.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("double");
            } else if (castType.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("timestamp");
            } else if (castType.equals((Object)TypeInfoFactory.dateTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("datetime");
            } else if (castType instanceof DecimalTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("decimal"));
            } else if (castType.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("binary");
            } else {
                throw new IllegalStateException("Unexpected type : " + castType.getQualifiedName());
            }
        }
        return castUDF;
    }

    private static FunctionInfo handleCastForParameterizedType(TypeInfo ti, FunctionInfo fi) {
        SettableUDF udf = (SettableUDF)((Object)fi.getGenericUDF());
        try {
            udf.setTypeInfo(ti);
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
        return new FunctionInfo(fi.isNative(), fi.getDisplayName(), (GenericUDF)((Object)udf));
    }

    public static ASTNode buildAST(SqlOperator op, List<ASTNode> children) {
        ASTNode node;
        HiveToken hToken = optiqToHiveToken.get(op);
        if (hToken != null) {
            node = (ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text);
        } else {
            node = (ASTNode)ParseDriver.adaptor.create(679, "TOK_FUNCTION");
            if (op.kind != SqlKind.CAST) {
                if (op.kind == SqlKind.MINUS_PREFIX) {
                    node = (ASTNode)ParseDriver.adaptor.create(286, "MINUS");
                } else if (op.kind == SqlKind.PLUS_PREFIX) {
                    node = (ASTNode)ParseDriver.adaptor.create(290, "PLUS");
                } else {
                    if (op.getName().toUpperCase().equals(SqlStdOperatorTable.COUNT.getName()) && children.size() == 0) {
                        node = (ASTNode)ParseDriver.adaptor.create(681, "TOK_FUNCTIONSTAR");
                    }
                    node.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(26, op.getName())));
                }
            }
        }
        for (ASTNode c : children) {
            ParseDriver.adaptor.addChild((Object)node, (Object)c);
        }
        return node;
    }

    public static ASTNode buildAST(SqlOperator op, List<ASTNode> children, int i) {
        if (i + 1 < children.size()) {
            HiveToken hToken = optiqToHiveToken.get(op);
            ASTNode curNode = (ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text);
            ParseDriver.adaptor.addChild((Object)curNode, (Object)children.get(i));
            ParseDriver.adaptor.addChild((Object)curNode, (Object)SqlFunctionConverter.buildAST(op, children, i + 1));
            return curNode;
        }
        return children.get(i);
    }

    private static String getName(GenericUDF hiveUDF) {
        String udfName = null;
        if (hiveUDF instanceof GenericUDFBridge) {
            udfName = ((GenericUDFBridge)hiveUDF).getUdfName();
        } else {
            int indx;
            String[] aliases;
            Description udfDescription;
            Class<?> udfClass = hiveUDF.getClass();
            Description udfAnnotation = udfClass.getAnnotation(Description.class);
            if (udfAnnotation != null && udfAnnotation instanceof Description && (udfName = (udfDescription = udfAnnotation).name()) != null && (aliases = udfName.split(",")).length > 0) {
                udfName = aliases[0];
            }
            if ((udfName == null || udfName.isEmpty()) && (indx = (udfName = hiveUDF.getClass().getName()).lastIndexOf(".")) >= 0) {
                udfName = udfName.substring(++indx);
            }
        }
        return udfName;
    }

    private static HiveToken hToken(int type, String text) {
        return new HiveToken(type, text, new String[0]);
    }

    private static OptiqUDFInfo getUDFInfo(String hiveUdfName, ImmutableList<RelDataType> optiqArgTypes, RelDataType optiqRetType) {
        OptiqUDFInfo udfInfo = new OptiqUDFInfo();
        udfInfo.udfName = hiveUdfName;
        udfInfo.returnTypeInference = (SqlReturnTypeInference)ReturnTypes.explicit((RelDataType)optiqRetType);
        udfInfo.operandTypeInference = InferTypes.explicit(optiqArgTypes);
        ImmutableList.Builder typeFamilyBuilder = new ImmutableList.Builder();
        for (RelDataType at : optiqArgTypes) {
            typeFamilyBuilder.add(Util.first((Object)at.getSqlTypeName().getFamily(), (Object)SqlTypeFamily.ANY));
        }
        udfInfo.operandTypeChecker = (SqlOperandTypeChecker)OperandTypes.family((List)typeFamilyBuilder.build());
        udfInfo.argTypes = ImmutableList.copyOf(optiqArgTypes);
        udfInfo.retType = optiqRetType;
        return udfInfo;
    }

    public static SqlOperator getOptiqFn(String hiveUdfName, ImmutableList<RelDataType> optiqArgTypes, RelDataType optiqRetType) throws OptiqSemanticException {
        if (hiveUdfName != null && hiveUdfName.trim().equals("<=>")) {
            throw new OptiqSemanticException("<=> is not yet supported for cbo.");
        }
        SqlOperator optiqOp = hiveToOptiq.get(hiveUdfName);
        if (optiqOp == null) {
            OptiqUDFInfo uInf = SqlFunctionConverter.getUDFInfo(hiveUdfName, optiqArgTypes, optiqRetType);
            optiqOp = new SqlFunction(uInf.udfName, SqlKind.OTHER_FUNCTION, uInf.returnTypeInference, uInf.operandTypeInference, uInf.operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }
        return optiqOp;
    }

    public static SqlAggFunction getOptiqAggFn(String hiveUdfName, ImmutableList<RelDataType> optiqArgTypes, RelDataType optiqRetType) {
        SqlAggFunction optiqAggFn = (SqlAggFunction)hiveToOptiq.get(hiveUdfName);
        if (optiqAggFn == null) {
            OptiqUDFInfo uInf = SqlFunctionConverter.getUDFInfo(hiveUdfName, optiqArgTypes, optiqRetType);
            optiqAggFn = new OptiqUDAF(uInf.udfName, uInf.returnTypeInference, uInf.operandTypeInference, uInf.operandTypeChecker, (ImmutableList<RelDataType>)uInf.argTypes, uInf.retType);
        }
        return optiqAggFn;
    }

    static {
        StaticBlockBuilder builder = new StaticBlockBuilder();
        hiveToOptiq = ImmutableMap.copyOf(builder.hiveToOptiq);
        optiqToHiveToken = ImmutableMap.copyOf(builder.optiqToHiveToken);
        reverseOperatorMap = ImmutableMap.copyOf(builder.reverseOperatorMap);
    }

    static class HiveToken {
        int type;
        String text;
        String[] args;

        HiveToken(int type, String text, String ... args) {
            this.type = type;
            this.text = text;
            this.args = args;
        }
    }

    private static class OptiqUDFInfo {
        private String udfName;
        private SqlReturnTypeInference returnTypeInference;
        private SqlOperandTypeInference operandTypeInference;
        private SqlOperandTypeChecker operandTypeChecker;
        private ImmutableList<RelDataType> argTypes;
        private RelDataType retType;

        private OptiqUDFInfo() {
        }
    }

    public static class OptiqUDAF
    extends SqlAggFunction {
        final ImmutableList<RelDataType> argTypes;
        final RelDataType retType;

        public OptiqUDAF(String opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, ImmutableList<RelDataType> argTypes, RelDataType retType) {
            super(opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION);
            this.argTypes = argTypes;
            this.retType = retType;
        }

        public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
            return this.argTypes;
        }

        public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
            return this.retType;
        }
    }

    private static class StaticBlockBuilder {
        final Map<String, SqlOperator> hiveToOptiq = Maps.newHashMap();
        final Map<SqlOperator, HiveToken> optiqToHiveToken = Maps.newHashMap();
        final Map<SqlOperator, String> reverseOperatorMap = Maps.newHashMap();

        StaticBlockBuilder() {
            this.registerFunction("+", (SqlOperator)SqlStdOperatorTable.PLUS, SqlFunctionConverter.hToken(290, "+"));
            this.registerFunction("-", (SqlOperator)SqlStdOperatorTable.MINUS, SqlFunctionConverter.hToken(286, "-"));
            this.registerFunction("*", (SqlOperator)SqlStdOperatorTable.MULTIPLY, SqlFunctionConverter.hToken(298, "*"));
            this.registerFunction("/", (SqlOperator)SqlStdOperatorTable.DIVIDE, SqlFunctionConverter.hToken(298, "/"));
            this.registerFunction("%", (SqlOperator)SqlStdOperatorTable.MOD, SqlFunctionConverter.hToken(298, "%"));
            this.registerFunction("and", (SqlOperator)SqlStdOperatorTable.AND, SqlFunctionConverter.hToken(33, "and"));
            this.registerFunction("or", (SqlOperator)SqlStdOperatorTable.OR, SqlFunctionConverter.hToken(175, "or"));
            this.registerFunction("=", (SqlOperator)SqlStdOperatorTable.EQUALS, SqlFunctionConverter.hToken(20, "="));
            this.registerFunction("<", (SqlOperator)SqlStdOperatorTable.LESS_THAN, SqlFunctionConverter.hToken(281, "<"));
            this.registerFunction("<=", (SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlFunctionConverter.hToken(282, "<="));
            this.registerFunction(">", (SqlOperator)SqlStdOperatorTable.GREATER_THAN, SqlFunctionConverter.hToken(23, ">"));
            this.registerFunction(">=", (SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, SqlFunctionConverter.hToken(24, ">="));
            this.registerFunction("!", (SqlOperator)SqlStdOperatorTable.NOT, SqlFunctionConverter.hToken(168, "not"));
            this.registerFunction("<>", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, SqlFunctionConverter.hToken(288, "<>"));
        }

        private void registerFunction(String name, SqlOperator optiqFn, HiveToken hiveToken) {
            FunctionInfo hFn;
            this.reverseOperatorMap.put(optiqFn, name);
            try {
                hFn = FunctionRegistry.getFunctionInfo(name);
            }
            catch (SemanticException e) {
                LOG.warn((Object)("Failed to load udf " + name), (Throwable)e);
                hFn = null;
            }
            if (hFn != null) {
                String hFnName = SqlFunctionConverter.getName(hFn.getGenericUDF());
                this.hiveToOptiq.put(hFnName, optiqFn);
                if (hiveToken != null) {
                    this.optiqToHiveToken.put(optiqFn, hiveToken);
                }
            }
        }
    }
}

