/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public abstract class GenericUDFBasePad
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter converter1;
    private transient ObjectInspectorConverters.Converter converter2;
    private transient ObjectInspectorConverters.Converter converter3;
    private Text result = new Text();
    private String udfName;

    public GenericUDFBasePad(String _udfName) {
        this.udfName = _udfName;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 3) {
            throw new UDFArgumentException(this.udfName + " requires three arguments. Found :" + arguments.length);
        }
        this.converter1 = this.checkTextArguments(arguments, 0);
        this.converter2 = this.checkIntArguments(arguments, 1);
        this.converter3 = this.checkTextArguments(arguments, 2);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject1 = arguments[0].get();
        Object valObject2 = arguments[1].get();
        Object valObject3 = arguments[2].get();
        if (valObject1 == null || valObject2 == null || valObject3 == null) {
            return null;
        }
        Text str = (Text)this.converter1.convert(valObject1);
        IntWritable lenW = (IntWritable)this.converter2.convert(valObject2);
        Text pad = (Text)this.converter3.convert(valObject3);
        if (str == null || pad == null || lenW == null) {
            return null;
        }
        int len = lenW.get();
        byte[] data = this.result.getBytes();
        if (data.length < len) {
            data = new byte[len];
        }
        byte[] txt = str.getBytes();
        byte[] padTxt = pad.getBytes();
        this.performOp(data, txt, padTxt, len, str, pad);
        this.result.set(data, 0, len);
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.udfName + "(" + StringUtils.join((Object[])children, (String)", ") + ")";
    }

    protected abstract void performOp(byte[] var1, byte[] var2, byte[] var3, int var4, Text var5, Text var6);

    private ObjectInspectorConverters.Converter checkTextArguments(ObjectInspector[] arguments, int i) throws UDFArgumentException {
        if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(i + 1, "Only primitive type arguments are accepted but " + arguments[i].getTypeName() + " is passed. as  arguments");
        }
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[i]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        return converter;
    }

    private ObjectInspectorConverters.Converter checkIntArguments(ObjectInspector[] arguments, int i) throws UDFArgumentException {
        ObjectInspectorConverters.Converter converter;
        if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(i + 1, "Only primitive type arguments are accepted but " + arguments[i].getTypeName() + " is passed. as  arguments");
        }
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
        switch (inputType) {
            case INT: 
            case SHORT: 
            case BYTE: {
                converter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[i]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentTypeException(i + 1, this.udfName + " only takes INT/SHORT/BYTE types as " + (i + 1) + "-ths argument, got " + inputType);
            }
        }
        return converter;
    }
}

