/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.test;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.gobblin.writer.test.TestingEventBuses;

public class TestingEventBusAsserter
implements Closeable {
    private final BlockingDeque<TestingEventBuses.Event> _events = new LinkedBlockingDeque<TestingEventBuses.Event>();
    private final EventBus _eventBus;
    private long _defaultTimeoutValue = 1L;
    private TimeUnit _defaultTimeoutUnit = TimeUnit.SECONDS;

    public TestingEventBusAsserter(String eventBusId) {
        this._eventBus = TestingEventBuses.getEventBus(eventBusId);
        this._eventBus.register((Object)this);
    }

    @Subscribe
    public void processEvent(TestingEventBuses.Event e) {
        this._events.offer(e);
    }

    @Override
    public void close() throws IOException {
        this._eventBus.unregister((Object)this);
    }

    public BlockingDeque<TestingEventBuses.Event> getEvents() {
        return this._events;
    }

    public void clear() {
        this._events.clear();
    }

    public TestingEventBusAsserter withTimeout(long timeout, TimeUnit unit) {
        this._defaultTimeoutValue = timeout;
        this._defaultTimeoutUnit = unit;
        return this;
    }

    public TestingEventBuses.Event assertNext(Predicate<TestingEventBuses.Event> predicate, Function<TestingEventBuses.Event, String> messageGen) throws InterruptedException, TimeoutException {
        TestingEventBuses.Event nextEvent = this._events.pollFirst(this._defaultTimeoutValue, this._defaultTimeoutUnit);
        if (null == nextEvent) {
            throw new TimeoutException();
        }
        if (!predicate.apply((Object)nextEvent)) {
            throw new AssertionError(messageGen.apply((Object)nextEvent));
        }
        return nextEvent;
    }

    public TestingEventBuses.Event assertNext(Predicate<TestingEventBuses.Event> predicate, String message) throws InterruptedException, TimeoutException {
        return this.assertNext(predicate, new StaticMessage(message));
    }

    public <T> TestingEventBuses.Event assertNextValue(final Predicate<T> predicate, Function<TestingEventBuses.Event, String> messageGen) throws InterruptedException, TimeoutException {
        return this.assertNext(new Predicate<TestingEventBuses.Event>(){

            public boolean apply(@Nonnull TestingEventBuses.Event input) {
                return predicate.apply(input.getTypedValue());
            }
        }, messageGen);
    }

    public <T> TestingEventBuses.Event assertNextValue(final Predicate<T> predicate, String message) throws InterruptedException, TimeoutException {
        return this.assertNext(new Predicate<TestingEventBuses.Event>(){

            public boolean apply(@Nonnull TestingEventBuses.Event input) {
                return predicate.apply(input.getTypedValue());
            }
        }, message);
    }

    public <T> TestingEventBuses.Event assertNextValueEq(final T expected) throws InterruptedException, TimeoutException {
        return this.assertNextValue(Predicates.equalTo(expected), new Function<TestingEventBuses.Event, String>(){

            public String apply(@Nonnull TestingEventBuses.Event input) {
                return "Event value mismatch: " + input.getValue() + " != " + expected;
            }
        });
    }

    public <T> void assertNextValuesEq(Collection<T> expected) throws InterruptedException, TimeoutException {
        final HashSet<T> remainingExpectedValues = new HashSet<T>(expected);
        Predicate checkInRemainingAndRemove = new Predicate<T>(){

            public boolean apply(@Nonnull T input) {
                if (!remainingExpectedValues.contains(input)) {
                    return false;
                }
                remainingExpectedValues.remove(input);
                return true;
            }
        };
        while (remainingExpectedValues.size() > 0) {
            this.assertNextValue(checkInRemainingAndRemove, new Function<TestingEventBuses.Event, String>(){

                public String apply(@Nonnull TestingEventBuses.Event input) {
                    return "Event value " + input.getValue() + " not in set " + remainingExpectedValues;
                }
            });
        }
    }

    public static class StaticMessage
    implements Function<TestingEventBuses.Event, String> {
        private final String message;

        public String apply(TestingEventBuses.Event input) {
            return this.message;
        }

        @ConstructorProperties(value={"message"})
        public StaticMessage(String message) {
            this.message = message;
        }
    }
}

