/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;

public class D2Uri
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2Uri\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"A URI resource as represented in D2\",\"fields\":[{\"name\":\"URI\",\"type\":\"string\",\"doc\":\"URI for this machine.\"},{\"name\":\"clusterName\",\"type\":\"string\",\"doc\":\"The cluster where this URI belongs.\"},{\"name\":\"partitionDescription\",\"type\":{\"type\":\"map\",\"values\":\"double\"},\"doc\":\"partitionId key to weight\"}]}");
    private static final RecordDataSchema.Field FIELD_URI = SCHEMA.getField("URI");
    private static final RecordDataSchema.Field FIELD_ClusterName = SCHEMA.getField("clusterName");
    private static final RecordDataSchema.Field FIELD_PartitionDescription = SCHEMA.getField("partitionDescription");

    public D2Uri() {
        super(new DataMap(), SCHEMA);
    }

    public D2Uri(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasURI() {
        return this.contains(FIELD_URI);
    }

    public void removeURI() {
        this.remove(FIELD_URI);
    }

    public String getURI(GetMode mode) {
        return (String)this.obtainDirect(FIELD_URI, String.class, mode);
    }

    public String getURI() {
        return (String)this.obtainDirect(FIELD_URI, String.class, GetMode.STRICT);
    }

    public D2Uri setURI(String value, SetMode mode) {
        this.putDirect(FIELD_URI, String.class, String.class, value, mode);
        return this;
    }

    public D2Uri setURI(String value) {
        this.putDirect(FIELD_URI, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasClusterName() {
        return this.contains(FIELD_ClusterName);
    }

    public void removeClusterName() {
        this.remove(FIELD_ClusterName);
    }

    public String getClusterName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_ClusterName, String.class, mode);
    }

    public String getClusterName() {
        return (String)this.obtainDirect(FIELD_ClusterName, String.class, GetMode.STRICT);
    }

    public D2Uri setClusterName(String value, SetMode mode) {
        this.putDirect(FIELD_ClusterName, String.class, String.class, value, mode);
        return this;
    }

    public D2Uri setClusterName(String value) {
        this.putDirect(FIELD_ClusterName, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPartitionDescription() {
        return this.contains(FIELD_PartitionDescription);
    }

    public void removePartitionDescription() {
        this.remove(FIELD_PartitionDescription);
    }

    public DoubleMap getPartitionDescription(GetMode mode) {
        return (DoubleMap)this.obtainWrapped(FIELD_PartitionDescription, DoubleMap.class, mode);
    }

    public DoubleMap getPartitionDescription() {
        return (DoubleMap)this.obtainWrapped(FIELD_PartitionDescription, DoubleMap.class, GetMode.STRICT);
    }

    public D2Uri setPartitionDescription(DoubleMap value, SetMode mode) {
        this.putWrapped(FIELD_PartitionDescription, DoubleMap.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Uri setPartitionDescription(DoubleMap value) {
        this.putWrapped(FIELD_PartitionDescription, DoubleMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Uri clone() throws CloneNotSupportedException {
        return (D2Uri)super.clone();
    }

    public D2Uri copy() throws CloneNotSupportedException {
        return (D2Uri)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec URI() {
            return new PathSpec(this.getPathComponents(), "URI");
        }

        public PathSpec clusterName() {
            return new PathSpec(this.getPathComponents(), "clusterName");
        }

        public PathSpec partitionDescription() {
            return new PathSpec(this.getPathComponents(), "partitionDescription");
        }
    }
}

