/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.client;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.gobblin.runtime.cli.CliObjectSupport;
import org.apache.gobblin.runtime.cli.ConstructorAndPublicMethodsCliObjectFactory;

@Alias(value="config", description="Query the config library")
public class ConfigClientCLI
implements CliApplication {
    public void run(String[] args) throws Exception {
        ConstructorAndPublicMethodsCliObjectFactory factory = new ConstructorAndPublicMethodsCliObjectFactory(Command.class);
        Command command = (Command)factory.buildObject(args, 1, true, args[0]);
        ConfigClient configClient = ConfigClient.createConfigClient(VersionStabilityPolicy.READ_FRESHEST);
        if (command.resolvedConfig) {
            Config resolvedConfig = configClient.getConfig(command.uri);
            System.out.println(resolvedConfig.root().render(ConfigRenderOptions.defaults()));
        }
    }

    public static class Command {
        private final URI uri;
        private boolean resolvedConfig = false;

        @CliObjectSupport(argumentNames={"configUri"})
        public Command(String uri) throws URISyntaxException {
            this.uri = new URI(uri);
        }

        public void resolvedConfig() {
            this.resolvedConfig = true;
        }
    }
}

