/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import java.util.HashSet;
import java.util.Set;

public class AsciiHexEncoding {
    private final char _encodingChar;
    private final Set<Character> _reservedChars;

    public AsciiHexEncoding(char escapeChar, char[] reservedChars) throws IllegalArgumentException {
        this(escapeChar, AsciiHexEncoding.toSet(reservedChars));
    }

    private static Set<Character> toSet(char[] chars) {
        HashSet<Character> reservedCharsSet = new HashSet<Character>();
        for (char c : chars) {
            reservedCharsSet.add(Character.valueOf(c));
        }
        return reservedCharsSet;
    }

    public AsciiHexEncoding(char encodingChar, Set<Character> reservedChars) throws IllegalArgumentException {
        if (encodingChar > '\u007f') {
            throw new IllegalArgumentException(reservedChars + " not allowed.  Only ascii chars may be used as encoding char.");
        }
        if (reservedChars == null) {
            throw new IllegalArgumentException("reservedChars must be non-null");
        }
        for (Character reservedChar : reservedChars) {
            if (reservedChar.charValue() == encodingChar) {
                throw new IllegalArgumentException("The characters you can encode must be different from the encoding character!");
            }
            if (reservedChar.charValue() <= '\u007f') continue;
            throw new IllegalArgumentException(reservedChar + " not allowed.  Only ascii chars may be used as reserved chars.");
        }
        this._reservedChars = reservedChars;
        this._encodingChar = encodingChar;
    }

    public String encode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == this._encodingChar || this._reservedChars.contains(Character.valueOf(c))) {
                sb.append(this._encodingChar);
                char asciiVal = c;
                if (asciiVal < '\u0010') {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(asciiVal).toUpperCase());
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String decode(String s) throws CannotDecodeException {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == this._encodingChar) {
                if (i + 3 > len) {
                    throw new CannotDecodeException(s + " - Failed to decode incomplete escaped char at offset " + i);
                }
                String asciiHex = s.substring(i + 1, i + 3);
                try {
                    Integer asciiInt = Integer.parseInt(asciiHex, 16);
                    sb.append((char)asciiInt.intValue());
                }
                catch (NumberFormatException ex) {
                    throw new CannotDecodeException(s + " - Failed to decode escaped char at offset " + i);
                }
                i += 2;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static class CannotDecodeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CannotDecodeException(String msg) {
            super(msg);
        }

        public CannotDecodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

