/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class HeaderUtil {
    public static final List<String> NONINHERITABLE_REQUEST_HEADERS = Arrays.asList("content-length");
    public static final List<String> NONINHERITABLE_RESPONSE_HEADERS = Arrays.asList("content-length");

    public static String getIdHeaderName(ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion()) >= 0 && protocolVersion.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) < 0) {
            return "X-LinkedIn-Id";
        }
        return "X-RestLi-Id";
    }

    public static String getIdHeaderName(Map<String, String> headers) {
        return HeaderUtil.getIdHeaderName(ProtocolVersionUtil.extractProtocolVersion(headers));
    }

    public static String getIdHeaderValue(Map<String, String> headers) {
        return headers.get(HeaderUtil.getIdHeaderName(ProtocolVersionUtil.extractProtocolVersion(headers)));
    }

    public static String getErrorResponseHeaderName(ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion()) >= 0 && protocolVersion.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) < 0) {
            return "X-LinkedIn-Error-Response";
        }
        return "X-RestLi-Error-Response";
    }

    public static String getErrorResponseHeaderName(Map<String, String> headers) {
        return HeaderUtil.getErrorResponseHeaderName(ProtocolVersionUtil.extractProtocolVersion(headers));
    }

    public static String getErrorResponseHeaderValue(Map<String, String> headers) {
        return headers.get(HeaderUtil.getErrorResponseHeaderName(ProtocolVersionUtil.extractProtocolVersion(headers)));
    }

    public static Map<String, String> removeHeaders(Map<String, String> headers, Collection<String> headerNames) {
        if (headers == null || headerNames == null || headerNames.isEmpty()) {
            return headers;
        }
        TreeSet<String> headersToRemove = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headersToRemove.addAll(headerNames);
        TreeMap<String, String> newHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String name = header.getKey();
            if (headersToRemove.contains(name)) continue;
            newHeaders.put(name, header.getValue());
        }
        return newHeaders;
    }

    public static Map<String, String> mergeHeaders(Map<String, String> headers1, Map<String, String> headers2) {
        TreeMap<String, String> combinedHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (headers2 != null) {
            combinedHeaders.putAll(headers2);
        }
        if (headers1 != null) {
            for (Map.Entry<String, String> header : headers1.entrySet()) {
                String name = header.getKey();
                if (combinedHeaders.containsKey(name)) continue;
                combinedHeaders.put(name, header.getValue());
            }
        }
        return combinedHeaders;
    }
}

